/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.collect.Lists;
import io.hops.exception.UniqueKeyConstraintViolationException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.metadata.hdfs.entity.Group;
import io.hops.metadata.hdfs.entity.User;
import io.hops.security.UsersGroups;
import io.hops.security.UsersGroupsCache;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback;
import org.apache.hadoop.security.UserGroupInformation;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestUsersGroups {
    @After
    public void afterTest() {
        UsersGroups.stop();
    }

    @Test
    public void testUsersGroupsCache() {
        Integer groupId;
        UsersGroupsCache cache = new UsersGroupsCache(10);
        User currentUser = new User(1, "user0");
        ArrayList groups = Lists.newArrayList();
        for (int i = 1; i < 10; ++i) {
            groups.add(new Group(i, "group" + i));
        }
        cache.addUserGroups(currentUser, groups.subList(0, 2));
        Integer userId = cache.getUserId(currentUser.getName());
        Assert.assertNotNull((Object)userId);
        Assert.assertEquals((long)userId.intValue(), (long)currentUser.getId());
        for (int i = 0; i < 2; ++i) {
            groupId = cache.getGroupId(((Group)groups.get(i)).getName());
            Assert.assertNotNull((Object)groupId);
            Assert.assertEquals((long)groupId.intValue(), (long)((Group)groups.get(i)).getId());
        }
        Assert.assertNull((Object)cache.getGroupId(((Group)groups.get(2)).getName()));
        List cachedGroups = cache.getGroups(currentUser.getName());
        Assert.assertNotNull((Object)cachedGroups);
        Assert.assertTrue((boolean)cachedGroups.equals(Arrays.asList(((Group)groups.get(0)).getName(), ((Group)groups.get(1)).getName())));
        cache.removeGroup(((Group)groups.get(0)).getName());
        groupId = cache.getGroupId(((Group)groups.get(0)).getName());
        Assert.assertNull((Object)groupId);
        cachedGroups = cache.getGroups(currentUser.getName());
        Assert.assertNotNull((Object)cachedGroups);
        Assert.assertTrue((boolean)cachedGroups.equals(Arrays.asList(((Group)groups.get(1)).getName())));
        cache.removeGroup(Integer.valueOf(((Group)groups.get(1)).getId()));
        String groupName = cache.getGroupName(Integer.valueOf(((Group)groups.get(1)).getId()));
        Assert.assertNull((Object)groupName);
        cachedGroups = cache.getGroups(currentUser.getName());
        Assert.assertNull((Object)cachedGroups);
        cache.addGroup((Group)groups.get(2));
        groupId = cache.getGroupId(((Group)groups.get(2)).getName());
        Assert.assertNotNull((Object)groupId);
        Assert.assertEquals((long)groupId.intValue(), (long)((Group)groups.get(2)).getId());
        cachedGroups = cache.getGroups(currentUser.getName());
        Assert.assertNull((Object)cachedGroups);
        cache.appendUserGroups(currentUser.getName(), Arrays.asList(((Group)groups.get(2)).getName()));
        cachedGroups = cache.getGroups(currentUser.getName());
        Assert.assertNotNull((Object)cachedGroups);
        Assert.assertTrue((boolean)cachedGroups.equals(Arrays.asList(((Group)groups.get(2)).getName())));
    }

    @Test
    public void testCacheEviction() {
        int i;
        int CACHE_SIZE = 5;
        UsersGroupsCache cache = new UsersGroupsCache(5);
        ArrayList users = Lists.newArrayList();
        ArrayList groups = Lists.newArrayList();
        ArrayList groupNames = Lists.newArrayList();
        for (i = 1; i <= 5; ++i) {
            users.add(new User(i, "user" + i));
            String groupName = "group" + i;
            groups.add(new Group(i, groupName));
            groupNames.add(groupName);
        }
        for (i = 0; i < 5; ++i) {
            cache.addUserGroups((User)users.get(i), groups.subList(i, i == 4 ? i + 1 : i + 2));
        }
        for (i = 0; i < 5; ++i) {
            List cachedGroups = cache.getGroups(((User)users.get(i)).getName());
            Assert.assertNotNull((Object)cachedGroups);
            Assert.assertTrue((boolean)cachedGroups.equals(groupNames.subList(i, i == 4 ? i + 1 : i + 2)));
        }
        User newUser = new User(6, "newUser");
        cache.addUser(newUser);
        Integer userId = cache.getUserId(newUser.getName());
        Assert.assertNotNull((Object)userId);
        Assert.assertEquals((long)userId.intValue(), (long)newUser.getId());
        userId = cache.getUserId(((User)users.get(0)).getName());
        Assert.assertNull((Object)userId);
        List cachedGroups = cache.getGroups(((User)users.get(0)).getName());
        Assert.assertNull((Object)cachedGroups);
        Integer groupId = cache.getGroupId(((Group)groups.get(0)).getName());
        Assert.assertNull((String)("Cache eviction should remove " + ((Group)groups.get(0)).getName()), (Object)groupId);
        groupId = cache.getGroupId(((Group)groups.get(1)).getName());
        Assert.assertNotNull((String)("Cache eviction shouldn't remove " + ((Group)groups.get(1)).getName()), (Object)groupId);
        Group newGroup1 = new Group(6, "newgroup1");
        Group newGroup2 = new Group(7, "newgroup2");
        cache.addGroup(newGroup1);
        groupId = cache.getGroupId(newGroup1.getName());
        Assert.assertNotNull((Object)groupId);
        Assert.assertEquals((long)groupId.intValue(), (long)newGroup1.getId());
        cache.addGroup(newGroup2);
        groupId = cache.getGroupId(newGroup2.getName());
        Assert.assertNotNull((Object)groupId);
        Assert.assertEquals((long)groupId.intValue(), (long)newGroup2.getId());
        groupId = cache.getGroupId(((Group)groups.get(1)).getName());
        Assert.assertNull((String)("Cache eviction should remove " + ((Group)groups.get(1)).getName()), (Object)groupId);
        userId = cache.getUserId(((User)users.get(1)).getName());
        Assert.assertNull((String)"Cache eviction should remove all users associated with a removed group ", (Object)userId);
        groupId = cache.getGroupId(((Group)groups.get(2)).getName());
        Assert.assertNotNull((String)("Cache eviction shouldn't remove " + ((Group)groups.get(2)).getName()), (Object)groupId);
        userId = cache.getUserId(((User)users.get(2)).getName());
        Assert.assertNotNull((String)("Cache eviction shouldn't remove " + ((User)users.get(2)).getName() + " since it wasn't associated with " + ((Group)groups.get(1)).getName()), (Object)userId);
        cachedGroups = cache.getGroups(((User)users.get(2)).getName());
        Assert.assertNotNull((Object)cachedGroups);
        Assert.assertEquals((Object)cachedGroups, Arrays.asList(((Group)groups.get(2)).getName(), ((Group)groups.get(3)).getName()));
        Group newGroup3 = new Group(8, "newgroup3");
        cache.addGroup(newGroup3);
        groupId = cache.getGroupId(newGroup1.getName());
        Assert.assertNotNull((Object)groupId);
        Assert.assertEquals((long)groupId.intValue(), (long)newGroup1.getId());
        groupId = cache.getGroupId(((Group)groups.get(2)).getName());
        Assert.assertNull((String)("Cache eviction should remove " + ((Group)groups.get(2)).getName()), (Object)groupId);
        userId = cache.getUserId(((User)users.get(2)).getName());
        Assert.assertNull((String)"Cache eviction should remove all users associated with a removed group ", (Object)userId);
    }

    @Test
    public void testUsersGroupsNotConfigurad() throws IOException {
        UsersGroups.addUserToGroups((String)"user", (String[])new String[]{"group1", "group2"});
        Assert.assertEquals((long)UsersGroups.getGroupID((String)"group1"), (long)0L);
        Assert.assertEquals((long)UsersGroups.getUserID((String)"user"), (long)0L);
    }

    @Test
    public void testGetUnixUserGroups() throws Exception {
        Configuration conf = new Configuration();
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        JniBasedUnixGroupsMappingWithFallback jniGroupsMapping = new JniBasedUnixGroupsMappingWithFallback();
        List loginUserGroups = jniGroupsMapping.getGroups(ugi.getUserName());
        Assert.assertFalse((boolean)loginUserGroups.isEmpty());
        UsersGroups.addUserToGroupsTx((String)ugi.getUserName(), (String[])new String[0]);
        List ugiGroups = ugi.getGroups();
        Assert.assertFalse((boolean)ugiGroups.isEmpty());
        Assert.assertThat((Object)ugiGroups, (Matcher)Matchers.equalTo((Object)loginUserGroups));
    }

    @Test
    public void testAddUsers() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("hops.groups.updater.round", 10);
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group1", "group2"});
        int userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertEquals((Object)UsersGroups.getUser((int)userId), (Object)"user");
        int groupId = UsersGroups.getGroupID((String)"group1");
        Assert.assertNotSame((Object)0, (Object)groupId);
        Assert.assertEquals((Object)UsersGroups.getGroup((int)groupId), (Object)"group1");
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
        this.removeUser(userId);
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        try {
            Thread.sleep(10500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertEquals((long)0L, (long)userId);
        Assert.assertNull((Object)UsersGroups.getGroups((String)"user"));
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group1", "group2"});
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
        this.removeUser(userId);
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group3"});
        int newUserId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertTrue((newUserId > userId ? 1 : 0) != 0);
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group1", "group2"});
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2", "group3"}));
    }

    @Test
    public void testGroupMappingsRefresh() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        cluster.getNameNode().getRpcServer().refreshUserToGroupsMappings();
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group1", "group2"});
        int userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertEquals((Object)UsersGroups.getUser((int)userId), (Object)"user");
        int groupId = UsersGroups.getGroupID((String)"group1");
        Assert.assertNotSame((Object)0, (Object)groupId);
        Assert.assertEquals((Object)UsersGroups.getGroup((int)groupId), (Object)"group1");
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
        this.removeUser(userId);
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        cluster.getNameNode().getRpcServer().refreshUserToGroupsMappings();
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertEquals((long)0L, (long)userId);
        Assert.assertNull((Object)UsersGroups.getGroups((String)"user"));
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group1", "group2"});
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
        this.removeUser(userId);
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group3"});
        int newUserId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertTrue((newUserId > userId ? 1 : 0) != 0);
        UsersGroups.addUserToGroupsTx((String)"user", (String[])new String[]{"group1", "group2"});
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2", "group3"}));
        cluster.shutdown();
    }

    @Test
    public void setOwnerMultipleTimes() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path base = new Path("/projects/project1");
        dfs.mkdirs(base);
        Path child = new Path(base, "dataset");
        dfs.mkdirs(child);
        dfs.setOwner(base, "testUser", "testGroup");
        this.removeGroup(UsersGroups.getGroupID((String)"testGroup"));
        dfs.flushCacheGroup("testGroup");
        dfs.setOwner(base, "testUser", "testGroup");
        cluster.shutdown();
    }

    private void removeUser(final int userId) throws IOException {
        new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                UserDataAccess da = (UserDataAccess)HdfsStorageFactory.getDataAccess(UserDataAccess.class);
                da.removeUser(userId);
                return null;
            }
        }.handle();
    }

    private void removeGroup(final int groupId) throws IOException {
        new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                GroupDataAccess da = (GroupDataAccess)HdfsStorageFactory.getDataAccess(GroupDataAccess.class);
                da.removeGroup(groupId);
                return null;
            }
        }.handle();
    }

    @Test
    public void testUserNameAndGroupNameCaseSensitivity() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path base = new Path("/projects/project1");
        dfs.mkdirs(base);
        Path child = new Path(base, "dataset");
        dfs.mkdirs(child);
        dfs.setOwner(base, "testUser", "testGroup");
        FileStatus fileStatus = dfs.getFileStatus(base);
        Assert.assertTrue((boolean)fileStatus.getOwner().equals("testUser"));
        Assert.assertTrue((boolean)fileStatus.getGroup().equals("testGroup"));
        dfs.setOwner(base, "testuser", "testgroup");
        fileStatus = dfs.getFileStatus(base);
        Assert.assertTrue((boolean)fileStatus.getOwner().equals("testuser"));
        Assert.assertTrue((boolean)fileStatus.getGroup().equals("testgroup"));
        cluster.getNameNode().getRpcServer().refreshUserToGroupsMappings();
        Assert.assertTrue((UsersGroups.getUserID((String)"testUser") != 0 ? 1 : 0) != 0);
        Assert.assertTrue((UsersGroups.getUserID((String)"testuser") != 0 ? 1 : 0) != 0);
        Assert.assertNotEquals((long)UsersGroups.getUserID((String)"testUser"), (long)UsersGroups.getUserID((String)"testuser"));
        Assert.assertTrue((UsersGroups.getGroupID((String)"testGroup") != 0 ? 1 : 0) != 0);
        Assert.assertTrue((UsersGroups.getGroupID((String)"testgroup") != 0 ? 1 : 0) != 0);
        Assert.assertNotEquals((long)UsersGroups.getGroupID((String)"testGroup"), (long)UsersGroups.getGroupID((String)"testgroup"));
        cluster.shutdown();
    }

    @Test
    public void testConcurrentAddUser() throws Exception {
        Configuration conf = new Configuration();
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        String userName = "user1";
        int CONCURRENT_USERS = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        ArrayList<AddUser> callables = new ArrayList<AddUser>();
        for (int i = 0; i < 100; ++i) {
            callables.add(new AddUser(false, "user1"));
        }
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.SECONDS);
        UsersGroups.clearCache();
        Integer userId = UsersGroups.getUserID((String)"user1");
        int success = 0;
        int failure = 0;
        for (Future f : futures) {
            try {
                Integer otherUserId = (Integer)f.get();
                Assert.assertNotEquals((Object)otherUserId, (Object)0);
                Assert.assertEquals((Object)otherUserId, (Object)userId);
                ++success;
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof UniqueKeyConstraintViolationException) {
                    ++failure;
                    continue;
                }
                Assert.fail();
            }
        }
        Assert.assertTrue((success >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((failure == 100 - success ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentAddUserTx() throws Exception {
        Configuration conf = new Configuration();
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        String userName = "user1";
        int CONCURRENT_USERS = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        ArrayList<AddUser> callables = new ArrayList<AddUser>();
        for (int i = 0; i < 100; ++i) {
            callables.add(new AddUser(true, "user1"));
        }
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.SECONDS);
        UsersGroups.clearCache();
        Integer userId = UsersGroups.getUserID((String)"user1");
        for (Future f : futures) {
            Integer otherUserId = (Integer)f.get();
            Assert.assertNotEquals((Object)otherUserId, (Object)0);
            Assert.assertEquals((Object)otherUserId, (Object)userId);
        }
    }

    @Test
    public void testConcurrentSetSameOwner() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path base = new Path("/base");
        dfs.mkdirs(base);
        String userName = "user";
        String groupName = "group";
        int CONCURRENT_USERS = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        ArrayList<SetOwner> callables = new ArrayList<SetOwner>();
        for (int i = 0; i < 100; ++i) {
            Path file = new Path(base, "file" + i);
            dfs.create(file).close();
            callables.add(new SetOwner(dfs, file, "user", "group"));
        }
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.SECONDS);
        for (Future f : futures) {
            Assert.assertTrue((boolean)((Boolean)f.get()));
        }
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetOwnerOnOutdatedCache() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path base = new Path("/base");
            dfs.mkdirs(base);
            String username = "user";
            String groupname = "group";
            String newgroupname = "newgroup";
            dfs.setOwner(base, "user", "group");
            FileStatus fileStatus = dfs.getFileStatus(base);
            Assert.assertEquals((Object)"user", (Object)fileStatus.getOwner());
            Assert.assertEquals((Object)"group", (Object)fileStatus.getGroup());
            int userId = UsersGroups.getUserID((String)"user");
            this.removeUser(userId);
            dfs.setOwner(base, "user", "newgroup");
            fileStatus = dfs.getFileStatus(base);
            Assert.assertEquals((Object)"user", (Object)fileStatus.getOwner());
            Assert.assertEquals((Object)"newgroup", (Object)fileStatus.getGroup());
            int newUserId = UsersGroups.getUserID((String)"user");
            Assert.assertTrue((newUserId > userId ? 1 : 0) != 0);
            Assert.assertNotEquals((long)userId, (long)newUserId);
        }
        finally {
            cluster.shutdown();
        }
    }

    private class SetOwner
    implements Callable<Boolean> {
        private final DistributedFileSystem dfs;
        private final Path path;
        private final String userName;
        private final String groupName;

        SetOwner(DistributedFileSystem dfs, Path path, String userName, String groupName) {
            this.dfs = dfs;
            this.path = path;
            this.userName = userName;
            this.groupName = groupName;
        }

        @Override
        public Boolean call() throws Exception {
            this.dfs.setOwner(this.path, this.userName, this.groupName);
            FileStatus fileStatus = this.dfs.getFileStatus(this.path);
            if (this.userName != null) {
                Assert.assertEquals((Object)this.userName, (Object)fileStatus.getOwner());
            }
            if (this.groupName != null) {
                Assert.assertEquals((Object)this.groupName, (Object)fileStatus.getGroup());
            }
            return true;
        }
    }

    private class AddUser
    implements Callable<Integer> {
        private final boolean useTransaction;
        private final String userName;

        AddUser(boolean useTransaction, String userName) {
            this.useTransaction = useTransaction;
            this.userName = userName;
        }

        @Override
        public Integer call() throws Exception {
            if (this.useTransaction) {
                UsersGroups.addUserToGroupsTx((String)this.userName, null);
            } else {
                UsersGroups.addUserToGroups((String)this.userName, null);
            }
            return UsersGroups.getUserID((String)this.userName);
        }
    }
}

