/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.Test;

public class TestDatanodeReport {
    private static final Configuration conf = new HdfsConfiguration();
    private static final int NUM_OF_DATANODES = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatanodeReport() throws Exception {
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setLong("dfs.heartbeat.interval", 1L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
        try {
            cluster.waitActive();
            InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            DFSClient client = new DFSClient(addr, conf);
            Assert.assertEquals((long)client.datanodeReport(HdfsConstants.DatanodeReportType.ALL).length, (long)4L);
            Assert.assertEquals((long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length, (long)4L);
            Assert.assertEquals((long)client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD).length, (long)0L);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            datanodes.remove(datanodes.size() - 1).shutdown();
            DatanodeInfo[] nodeInfo = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
            while (nodeInfo.length != 1) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                nodeInfo = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
            }
            Assert.assertEquals((long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length, (long)3L);
            Assert.assertEquals((long)client.datanodeReport(HdfsConstants.DatanodeReportType.ALL).length, (long)4L);
            Thread.sleep(5000L);
            MetricsAsserts.assertGauge((String)"ExpiredHeartbeats", (int)1, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"FSNamesystem"));
        }
        finally {
            cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestDatanodeReport().testDatanodeReport();
    }
}

