/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.TestUtil;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.MetadataLogDataAccess;
import io.hops.metadata.hdfs.entity.MetadataLogEntry;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.Test;

public class TestMetadataLog
extends TestCase {
    private static final int ANY_DATASET = -1;
    private static final String ANY_NAME = "-1";
    private static Comparator<MetadataLogEntry> LOGICAL_TIME_COMPARATOR = new Comparator<MetadataLogEntry>(){

        @Override
        public int compare(MetadataLogEntry o1, MetadataLogEntry o2) {
            return Integer.compare(o1.getLogicalTime(), o2.getLogicalTime());
        }
    };

    private boolean checkLog(int inodeId, MetadataLogEntry.Operation operation) throws IOException {
        return this.checkLog(-1, inodeId, operation);
    }

    private boolean checkLog(int datasetId, int inodeId, MetadataLogEntry.Operation operation) throws IOException {
        return this.checkLog(datasetId, inodeId, ANY_NAME, operation);
    }

    private boolean checkLog(int datasetId, int inodeId, String inodeName, MetadataLogEntry.Operation operation) throws IOException {
        Collection<MetadataLogEntry> logEntries = this.getMetadataLogEntries(inodeId);
        for (MetadataLogEntry logEntry : logEntries) {
            if (!logEntry.getOperation().equals((Object)operation) || datasetId != -1 && datasetId != logEntry.getDatasetId() || !inodeName.equals(ANY_NAME) && !inodeName.equals(logEntry.getInodeName())) continue;
            return true;
        }
        return false;
    }

    private Collection<MetadataLogEntry> getMetadataLogEntries(final int inodeId) throws IOException {
        return (Collection)new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.GET_METADATA_LOG_ENTRIES){

            public Object performTask() throws IOException {
                MetadataLogDataAccess da = (MetadataLogDataAccess)HdfsStorageFactory.getDataAccess(MetadataLogDataAccess.class);
                return da.find(inodeId);
            }
        }.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonLoggingFolder() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path subdir = new Path(dataset, "subdir");
            Path file = new Path(dataset, "file");
            dfs.mkdirs(dataset, FsPermission.getDefault());
            dfs.mkdirs(subdir);
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), subdir), MetadataLogEntry.Operation.ADD));
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), file), MetadataLogEntry.Operation.ADD));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreate() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path subdir = new Path(dataset, "subdir");
            Path file = new Path(subdir, "file");
            dfs.mkdirs(dataset, FsPermission.getDefault());
            dfs.setMetaEnabled(dataset, true);
            dfs.mkdirs(subdir);
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), subdir), MetadataLogEntry.Operation.ADD));
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), file), MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{subdir, file}, new int[]{1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path subdir = new Path(dataset, "subdir");
            Path file = new Path(subdir, "file");
            dfs.mkdirs(dataset, FsPermission.getDefault());
            dfs.setMetaEnabled(dataset, true);
            dfs.mkdirs(subdir);
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), subdir), MetadataLogEntry.Operation.ADD));
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            int inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{subdir, file}, new int[]{1, 1});
            dfs.append(file).close();
            dfs.append(file).close();
            ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
            Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
            TestMetadataLog.assertTrue((inodeLogEntries.size() == 3 ? 1 : 0) != 0);
            for (int i = 0; i < 3; ++i) {
                TestMetadataLog.assertEquals((int)(i + 1), (int)((MetadataLogEntry)inodeLogEntries.get(i)).getLogicalTime());
                TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(i)).getOperation() == MetadataLogEntry.Operation.ADD ? 1 : 0) != 0);
            }
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{subdir, file}, new int[]{1, 3});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoLogEntryBeforeClosing() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path file = new Path(dataset, "file");
            dfs.mkdirs(dataset, FsPermission.getDefault());
            dfs.setMetaEnabled(dataset, true);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), file), MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file}, new int[]{0});
            out.close();
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), file), MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file}, new int[]{1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            dfs.setMetaEnabled(dataset, true);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            int inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            int folderId = TestUtil.getINodeId(cluster.getNameNode(), folder);
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder, file}, new int[]{1, 1});
            dfs.delete(folder, true);
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, MetadataLogEntry.Operation.DELETE));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, MetadataLogEntry.Operation.DELETE));
            this.checkLogicalTimeDeleteAfterAdd(new int[]{folderId, inodeId});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOldRename() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset0 = new Path(project, "dataset0");
            Path dataset1 = new Path(project, "dataset1");
            Path file0 = new Path(dataset0, "file");
            Path file1 = new Path(dataset1, "file");
            dfs.mkdirs(dataset0, FsPermission.getDefault());
            dfs.mkdirs(dataset1, FsPermission.getDefault());
            dfs.setMetaEnabled(dataset0, true);
            dfs.setMetaEnabled(dataset1, true);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file0, 1);
            out.close();
            int inodeId = TestUtil.getINodeId(cluster.getNameNode(), file0);
            int dataset1Id = TestUtil.getINodeId(cluster.getNameNode(), dataset1);
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file0}, new int[]{1});
            TestMetadataLog.assertTrue((boolean)dfs.rename(file0, file1));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, inodeId, MetadataLogEntry.Operation.RENAME));
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(inodeId).size());
            this.checkLogicalTimeAddRename(inodeId);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file1}, new int[]{2});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRename() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset0 = new Path(project, "dataset0");
            Path dataset1 = new Path(project, "dataset1");
            Path file0 = new Path(dataset0, "file");
            Path file1 = new Path(dataset1, "file");
            dfs.mkdirs(dataset0, FsPermission.getDefault());
            dfs.mkdirs(dataset1, FsPermission.getDefault());
            dfs.setMetaEnabled(dataset0, true);
            dfs.setMetaEnabled(dataset1, true);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file0, 1);
            out.close();
            int inodeId = TestUtil.getINodeId(cluster.getNameNode(), file0);
            int dataset1Id = TestUtil.getINodeId(cluster.getNameNode(), dataset1);
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file0}, new int[]{1});
            dfs.rename(file0, file1, new Options.Rename[]{Options.Rename.NONE});
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, inodeId, MetadataLogEntry.Operation.RENAME));
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(inodeId).size());
            this.checkLogicalTimeAddRename(inodeId);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file1}, new int[]{2});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeepOldRename() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset0 = new Path(project, "dataset0");
            Path folder0 = new Path(dataset0, "folder0");
            Path dataset1 = new Path(project, "dataset1");
            Path folder1 = new Path(dataset1, "folder1");
            Path file0 = new Path(folder0, "file");
            dfs.mkdirs(folder0, FsPermission.getDefault());
            dfs.mkdirs(dataset1, FsPermission.getDefault());
            dfs.setMetaEnabled(dataset0, true);
            dfs.setMetaEnabled(dataset1, true);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file0, 1);
            out.close();
            int inodeId = TestUtil.getINodeId(cluster.getNameNode(), file0);
            int folder0Id = TestUtil.getINodeId(cluster.getNameNode(), folder0);
            int dataset0Id = TestUtil.getINodeId(cluster.getNameNode(), dataset0);
            int dataset1Id = TestUtil.getINodeId(cluster.getNameNode(), dataset1);
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset0Id, folder0Id, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset0Id, inodeId, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder0, file0}, new int[]{1, 1});
            dfs.rename(folder0, folder1);
            int folder1Id = TestUtil.getINodeId(cluster.getNameNode(), folder1);
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, folder1Id, MetadataLogEntry.Operation.RENAME));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, inodeId, MetadataLogEntry.Operation.CHANGEDATASET));
            this.checkLogicalTimeAddRename(folder0Id);
            this.checkLogicalTimeAddRChangeDataset(inodeId);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder1, new Path(folder1, file0.getName())}, new int[]{2, 2});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeepRename() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset0 = new Path(project, "dataset0");
            Path folder0 = new Path(dataset0, "folder0");
            Path dataset1 = new Path(project, "dataset1");
            Path folder1 = new Path(dataset1, "folder1");
            Path file0 = new Path(folder0, "file");
            dfs.mkdirs(folder0, FsPermission.getDefault());
            dfs.mkdirs(dataset1, FsPermission.getDefault());
            dfs.setMetaEnabled(dataset0, true);
            dfs.setMetaEnabled(dataset1, true);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file0, 1);
            out.close();
            int inodeId = TestUtil.getINodeId(cluster.getNameNode(), file0);
            int folder0Id = TestUtil.getINodeId(cluster.getNameNode(), folder0);
            int dataset0Id = TestUtil.getINodeId(cluster.getNameNode(), dataset0);
            int dataset1Id = TestUtil.getINodeId(cluster.getNameNode(), dataset1);
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset0Id, folder0Id, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset0Id, inodeId, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder0, file0}, new int[]{1, 1});
            dfs.rename(folder0, folder1, new Options.Rename[]{Options.Rename.NONE});
            int folder1Id = TestUtil.getINodeId(cluster.getNameNode(), folder1);
            TestMetadataLog.assertEquals((int)folder0Id, (int)folder1Id);
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, folder0Id, MetadataLogEntry.Operation.RENAME));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, inodeId, MetadataLogEntry.Operation.CHANGEDATASET));
            this.checkLogicalTimeAddRename(folder0Id);
            this.checkLogicalTimeAddRChangeDataset(inodeId);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder1, new Path(folder1, file0.getName())}, new int[]{2, 2});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableLogForExistingDirectory() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{projects, project, dataset, folder, file}, new int[]{0, 0, 0, 0, 0});
            dfs.setMetaEnabled(dataset, true);
            int inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            int folderId = TestUtil.getINodeId(cluster.getNameNode(), folder);
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{projects, project, dataset, folder, file}, new int[]{0, 0, 0, 1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFileWhileOpen() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean BYTES_PER_CHECKSUM = true;
        boolean PACKET_SIZE = true;
        boolean BLOCK_SIZE = true;
        conf.setInt("dfs.bytes-per-checksum", 1);
        conf.setLong("dfs.blocksize", 1L);
        conf.setInt("dfs.client-write-packet-size", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            dfs.setMetaEnabled(dataset, true);
            FSDataOutputStream out = dfs.create(file);
            out.writeByte(0);
            int inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            int folderId = TestUtil.getINodeId(cluster.getNameNode(), folder);
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertFalse((boolean)this.checkLog(inodeId, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder, file}, new int[]{1, 0});
            DistributedFileSystem dfs2 = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
            try {
                dfs2.delete(file, false);
            }
            catch (Exception ex) {
                TestMetadataLog.fail((String)("we shouldn't have any exception: " + ex.getMessage()));
            }
            TestMetadataLog.assertFalse((boolean)this.checkLog(inodeId, MetadataLogEntry.Operation.DELETE));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder}, new int[]{1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testDeepOldRenameInTheSameDataset() throws Exception {
        this.testDeepRenameInTheSameDataset(true);
    }

    @Test
    public void testDeepRenameInTheSameDataset() throws Exception {
        this.testDeepRenameInTheSameDataset(false);
    }

    @Test
    public void testOldDeepRenameToNonMetaEnabledDir() throws Exception {
        this.testDeepRenameToNonMetaEnabledDir(true);
    }

    @Test
    public void testDeepRenameToNonMetaEnabledDir() throws Exception {
        this.testDeepRenameToNonMetaEnabledDir(false);
    }

    @Test
    public void testDeleteDatasetAfterOldRename() throws Exception {
        this.testDeleteDatasetAfterRename(true);
    }

    @Test
    public void testDeleteDatasetAfterRename() throws Exception {
        this.testDeleteDatasetAfterRename(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeepRenameInTheSameDataset(boolean oldRename) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder0 = new Path(dataset, "folder0");
            Path folder1 = new Path(folder0, "folder1");
            Path file = new Path(folder1, "file");
            Path newFolder = new Path(dataset, "newFolder");
            dfs.mkdirs(folder1, FsPermission.getDefault());
            dfs.setMetaEnabled(dataset, true);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            int inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            int folder0Id = TestUtil.getINodeId(cluster.getNameNode(), folder0);
            int folder1Id = TestUtil.getINodeId(cluster.getNameNode(), folder1);
            int datasetId = TestUtil.getINodeId(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder0, folder1, file}, new int[]{1, 1, 1});
            if (oldRename) {
                dfs.rename(folder0, newFolder);
            } else {
                dfs.rename(folder0, newFolder, new Options.Rename[]{Options.Rename.NONE});
            }
            int newFolderId = TestUtil.getINodeId(cluster.getNameNode(), newFolder);
            TestMetadataLog.assertEquals((int)folder0Id, (int)newFolderId);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, newFolder.getName(), MetadataLogEntry.Operation.RENAME));
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged during a rename in the same dataset", (int)1, (int)this.getMetadataLogEntries(folder1Id).size());
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged during a rename in the same dataset", (int)1, (int)this.getMetadataLogEntries(inodeId).size());
            this.checkLogicalTimeAddRename(folder0Id);
            Path newFolder1 = new Path(newFolder, folder1.getName());
            Path newFile = new Path(newFolder1, file.getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{newFolder, newFolder1, newFile}, new int[]{2, 1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeepRenameToNonMetaEnabledDir(boolean oldRename) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder0 = new Path(dataset, "folder0");
            Path folder1 = new Path(folder0, "folder1");
            Path file = new Path(folder1, "file");
            Path newFolder = new Path(project, "newFolder");
            dfs.mkdirs(folder1, FsPermission.getDefault());
            dfs.setMetaEnabled(dataset, true);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            int inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            int folder0Id = TestUtil.getINodeId(cluster.getNameNode(), folder0);
            int folder1Id = TestUtil.getINodeId(cluster.getNameNode(), folder1);
            int datasetId = TestUtil.getINodeId(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder0, folder1, file}, new int[]{1, 1, 1});
            if (oldRename) {
                dfs.rename(folder0, newFolder);
            } else {
                dfs.rename(folder0, newFolder, new Options.Rename[]{Options.Rename.NONE});
            }
            int newFolderId = TestUtil.getINodeId(cluster.getNameNode(), newFolder);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, MetadataLogEntry.Operation.DELETE));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, MetadataLogEntry.Operation.DELETE));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, inodeId, MetadataLogEntry.Operation.DELETE));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, newFolderId, newFolder.getName(), MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged for addition during a move to a non MetaEnabled directoy", (int)2, (int)this.getMetadataLogEntries(folder1Id).size());
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged for addition during a move to a non MetaEnabled directoy", (int)2, (int)this.getMetadataLogEntries(inodeId).size());
            this.checkLogicalTimeDeleteAfterAdd(new int[]{folder0Id, folder1Id, inodeId});
            Path newFolder1 = new Path(newFolder, folder1.getName());
            Path newFile = new Path(newFolder1, file.getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{newFolder, newFolder1, newFile}, new int[]{2, 2, 2});
            if (oldRename) {
                dfs.rename(newFolder, folder0);
            } else {
                dfs.rename(newFolder, folder0, new Options.Rename[]{Options.Rename.NONE});
            }
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeAddDeleteAdd(folder0Id);
            this.checkLogicalTimeAddDeleteAdd(folder1Id);
            this.checkLogicalTimeAddDeleteAdd(inodeId);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder0, folder1, file}, new int[]{3, 3, 3});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteDatasetAfterRename(boolean oldRename) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dataset = new Path("/dataset");
            Path folder1 = new Path(dataset, "folder1");
            Path folder2 = new Path(folder1, "folder2");
            Path folder3 = new Path(folder2, "folder3");
            dfs.mkdirs(folder3, FsPermission.getDefault());
            dfs.setMetaEnabled(dataset, true);
            int datasetId = TestUtil.getINodeId(cluster.getNameNode(), dataset);
            int folder1Id = TestUtil.getINodeId(cluster.getNameNode(), folder1);
            int folder2Id = TestUtil.getINodeId(cluster.getNameNode(), folder2);
            int folder3Id = TestUtil.getINodeId(cluster.getNameNode(), folder3);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder2Id, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder3Id, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder1, folder2, folder3}, new int[]{1, 1, 1});
            Path file1 = new Path(folder3, "file1");
            TestFileCreation.create(dfs, file1, 1).close();
            Path file2 = new Path(folder3, "file2");
            TestFileCreation.create(dfs, file2, 1).close();
            int file1Id = TestUtil.getINodeId(cluster.getNameNode(), file1);
            int file2Id = TestUtil.getINodeId(cluster.getNameNode(), file2);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, file1Id, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, file2Id, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder1, folder2, folder3, file1, file1}, new int[]{1, 1, 1, 1, 1});
            Path newDataset = new Path("/newDataset");
            if (oldRename) {
                dfs.rename(dataset, newDataset);
            } else {
                dfs.rename(dataset, newDataset, new Options.Rename[]{Options.Rename.NONE});
            }
            int newDatasetId = TestUtil.getINodeId(cluster.getNameNode(), newDataset);
            TestMetadataLog.assertTrue((newDatasetId == datasetId ? 1 : 0) != 0);
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, folder1Id, MetadataLogEntry.Operation.DELETE));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, folder2Id, MetadataLogEntry.Operation.DELETE));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, folder3Id, MetadataLogEntry.Operation.DELETE));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, file1Id, MetadataLogEntry.Operation.DELETE));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, file2Id, MetadataLogEntry.Operation.DELETE));
            Path newFolder1 = new Path(newDataset, folder1.getName());
            Path newFolder2 = new Path(newFolder1, folder2.getName());
            Path newFolder3 = new Path(newFolder2, folder3.getName());
            Path newFile1 = new Path(newFolder3, file1.getName());
            Path newFile2 = new Path(newFolder3, file2.getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{newFolder1, newFolder2, newFolder3, newFile1, newFile2}, new int[]{1, 1, 1, 1, 1});
            TestMetadataLog.assertTrue((boolean)dfs.delete(newDataset, true));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, MetadataLogEntry.Operation.DELETE));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder2Id, MetadataLogEntry.Operation.DELETE));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder3Id, MetadataLogEntry.Operation.DELETE));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, file1Id, MetadataLogEntry.Operation.DELETE));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, file2Id, MetadataLogEntry.Operation.DELETE));
            this.checkLogicalTimeDeleteAfterAdd(new int[]{folder1Id, folder2Id, folder3Id, file1Id, file2Id});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingAndUnsettingMetaEnabled() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            dfs.setMetaEnabled(dataset, true);
            int inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            int folderId = TestUtil.getINodeId(cluster.getNameNode(), folder);
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, MetadataLogEntry.Operation.ADD));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, MetadataLogEntry.Operation.ADD));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder, file}, new int[]{1, 1});
            dfs.setMetaEnabled(dataset, false);
            TestMetadataLog.assertEquals((int)1, (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)1, (int)this.getMetadataLogEntries(folderId).size());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder, file}, new int[]{1, 1});
            dfs.setMetaEnabled(dataset, true);
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(folderId).size());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder, file}, new int[]{2, 2});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void checkLogicalTimeDeleteAfterAdd(int[] inodesIds) throws IOException {
        for (int inodeId : inodesIds) {
            ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
            Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
            TestMetadataLog.assertTrue((inodeLogEntries.size() == 2 ? 1 : 0) != 0);
            TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperation() == MetadataLogEntry.Operation.ADD ? 1 : 0) != 0);
            TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperation() == MetadataLogEntry.Operation.DELETE ? 1 : 0) != 0);
        }
    }

    private void checkLogicalTimeAddDeleteAdd(int inodeId) throws IOException {
        ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
        Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((inodeLogEntries.size() == 3 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperation() == MetadataLogEntry.Operation.ADD ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperation() == MetadataLogEntry.Operation.DELETE ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(2)).getOperation() == MetadataLogEntry.Operation.ADD ? 1 : 0) != 0);
    }

    private void checkLogicalTimeAddRename(int inodeId) throws IOException {
        ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
        Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((inodeLogEntries.size() == 2 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperation() == MetadataLogEntry.Operation.ADD ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperation() == MetadataLogEntry.Operation.RENAME ? 1 : 0) != 0);
    }

    private void checkLogicalTimeAddRChangeDataset(int inodeId) throws IOException {
        ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
        Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((inodeLogEntries.size() == 2 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperation() == MetadataLogEntry.Operation.ADD ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperation() == MetadataLogEntry.Operation.CHANGEDATASET ? 1 : 0) != 0);
    }

    private void checkLogicalTimeForINodes(NameNode nameNode, Path[] inodesPaths, int[] logicalTimes) throws IOException {
        int i = 0;
        for (Path path : inodesPaths) {
            TestMetadataLog.assertEquals((int)logicalTimes[i], (int)TestUtil.getINode(nameNode, path).getLogicalTime());
            ++i;
        }
    }
}

