/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.ReplicaDataAccess;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.security.Users;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBlockManager {
    static final Log LOG = LogFactory.getLog(TestBlockManager.class);
    private DatanodeStorageInfo[] storages;
    private List<DatanodeDescriptor> nodes;
    private List<DatanodeDescriptor> rackA;
    private List<DatanodeDescriptor> rackB;
    private static final int NUM_TEST_ITERS = 30;
    private static final int BLOCK_SIZE = 65536;
    private Configuration conf = new HdfsConfiguration();
    private FSNamesystem fsn;
    private static BlockManager bm;
    private int numBuckets;
    private static final String USER = "user";
    private static final String GROUP = "grp";

    @Before
    public void setupMockCluster() throws IOException {
        HdfsStorageFactory.setConfiguration((Configuration)this.conf);
        this.conf.set("net.topology.script.file.name", "need to set a dummy value here so it assumes a multi-rack cluster");
        ExecutorService subTreeOpsPool = Executors.newFixedThreadPool(this.conf.getInt("dfs.namenode.subtree-executor-limit", 80));
        this.fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        ((FSNamesystem)Mockito.doReturn((Object)subTreeOpsPool).when((Object)this.fsn)).getSubtreeOperationsExecutor();
        this.formatStorage();
        bm = new BlockManager((Namesystem)this.fsn, (FSClusterStats)this.fsn, this.conf);
        String[] racks = new String[]{"/rackA", "/rackA", "/rackA", "/rackB", "/rackB", "/rackB"};
        this.storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        this.nodes = Arrays.asList(DFSTestUtil.toDatanodeDescriptor(this.storages));
        for (DatanodeDescriptor node : this.nodes) {
            node.setDatanodeUuidForTesting("DN-Name-" + DatanodeStorage.generateUuid());
        }
        this.rackA = this.nodes.subList(0, 3);
        this.rackB = this.nodes.subList(3, 6);
        this.numBuckets = this.conf.getInt("dfs.blockreport.numbuckets", 1000);
        DFSTestUtil.createRootFolder();
    }

    private void formatStorage() throws IOException {
        HdfsStorageFactory.formatStorage();
        Users.addUserToGroup((String)USER, (String)GROUP);
    }

    private void addNodes(Iterable<DatanodeDescriptor> nodesToAdd) throws IOException {
        NetworkTopology cluster = bm.getDatanodeManager().getNetworkTopology();
        for (DatanodeDescriptor dn : nodesToAdd) {
            cluster.add((Node)dn);
            dn.getStorageInfos()[0].setUtilizationForTesting((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 65536), 0L, (long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 65536), 0L);
            dn.updateHeartbeat(BlockManagerTestUtil.getStorageReportsForDatanode(dn), 0L, 0L, 0, 0);
            bm.getDatanodeManager().checkIfClusterIsNowMultiRack(dn);
            bm.getDatanodeManager().addDnToStorageMapInDB(dn);
            bm.getDatanodeManager().addDatanode(dn);
        }
    }

    private void removeNode(DatanodeDescriptor deadNode) throws IOException {
        NetworkTopology cluster = bm.getDatanodeManager().getNetworkTopology();
        cluster.remove((Node)deadNode);
        bm.datanodeRemoved(deadNode);
    }

    @Test
    public void testBasicReplication() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doBasicTest(i);
        }
    }

    private void doBasicTest(int testIndex) throws IOException {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfo blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        DatanodeStorageInfo[] pipeline = this.scheduleSingleReplication(blockInfo);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on (" + origStorages.toString() + "), butwas on: " + pipeline[0]), (boolean)origStorages.contains(pipeline[0]));
        Assert.assertTrue((String)("Destination of replication should be on the other rack. Was: " + pipeline[1]), (boolean)this.rackB.contains(pipeline[1].getDatanodeDescriptor()));
    }

    @Test
    public void testTwoOfThreeNodesDecommissioned() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doTestTwoOfThreeNodesDecommissioned(i);
        }
    }

    private void doTestTwoOfThreeNodesDecommissioned(int testIndex) throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1, 3);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfo blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        List<DatanodeDescriptor> decomNodes = this.startDecommission(0, 1);
        Object[] pipeline = this.scheduleSingleReplication(blockInfo);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on(" + origStorages.toString() + "). Was: " + pipeline[0]), (boolean)origStorages.contains(pipeline[0]));
        Assert.assertEquals((String)"Should have three targets", (long)3L, (long)pipeline.length);
        boolean foundOneOnRackA = false;
        for (int i = 1; i < pipeline.length; ++i) {
            DatanodeDescriptor target = pipeline[i].getDatanodeDescriptor();
            if (this.rackA.contains(target)) {
                foundOneOnRackA = true;
            }
            Assert.assertFalse((boolean)decomNodes.contains(target));
            Assert.assertFalse((boolean)origNodes.contains(target));
        }
        Assert.assertTrue((String)("Should have at least one target on rack A. Pipeline: " + Joiner.on((String)",").join(pipeline)), (boolean)foundOneOnRackA);
    }

    @Test
    public void testAllNodesHoldingReplicasDecommissioned() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doTestAllNodesHoldingReplicasDecommissioned(i);
        }
    }

    private void doTestAllNodesHoldingReplicasDecommissioned(int testIndex) throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1, 3);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfo blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        List<DatanodeDescriptor> decomNodes = this.startDecommission(0, 1, 3);
        Object[] pipeline = this.scheduleSingleReplication(blockInfo);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origStorages.contains(pipeline[0]));
        Assert.assertEquals((String)"Should have three targets", (long)4L, (long)pipeline.length);
        boolean foundOneOnRackA = false;
        boolean foundOneOnRackB = false;
        for (int i = 1; i < pipeline.length; ++i) {
            DatanodeDescriptor target = pipeline[i].getDatanodeDescriptor();
            if (this.rackA.contains(target)) {
                foundOneOnRackA = true;
            } else if (this.rackB.contains(target)) {
                foundOneOnRackB = true;
            }
            Assert.assertFalse((boolean)decomNodes.contains(target));
            Assert.assertFalse((boolean)origNodes.contains(target));
        }
        Assert.assertTrue((String)("Should have at least one target on rack A. Pipeline: " + Joiner.on((String)",").join(pipeline)), (boolean)foundOneOnRackA);
        Assert.assertTrue((String)("Should have at least one target on rack B. Pipeline: " + Joiner.on((String)",").join(pipeline)), (boolean)foundOneOnRackB);
    }

    @Test
    public void testOneOfTwoRacksDecommissioned() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doTestOneOfTwoRacksDecommissioned(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestOneOfTwoRacksDecommissioned(int testIndex) throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1, 3);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfo blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        List<DatanodeDescriptor> decomNodes = this.startDecommission(0, 1, 2);
        Object[] pipeline = this.scheduleSingleReplication(blockInfo);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origStorages.contains(pipeline[0]));
        Assert.assertEquals((String)"Should have two targets", (long)2L, (long)pipeline.length);
        boolean foundOneOnRackB = false;
        for (int i = 1; i < pipeline.length; ++i) {
            DatanodeDescriptor target = pipeline[i].getDatanodeDescriptor();
            if (this.rackB.contains(target)) {
                foundOneOnRackB = true;
            }
            Assert.assertFalse((boolean)decomNodes.contains(target));
            Assert.assertFalse((boolean)origNodes.contains(target));
        }
        Assert.assertTrue((String)("Should have at least one target on rack B. Pipeline: " + Joiner.on((String)",").join(pipeline)), (boolean)foundOneOnRackB);
        this.fulfillPipeline(blockInfo, (DatanodeStorageInfo[])pipeline);
        DatanodeDescriptor rackCNode = DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/rackC");
        rackCNode.updateStorage(new DatanodeStorage(DatanodeStorage.generateUuid()));
        this.addNodes((Iterable<DatanodeDescriptor>)ImmutableList.of((Object)rackCNode));
        try {
            DatanodeStorageInfo[] pipeline2 = this.scheduleSingleReplication(blockInfo);
            Assert.assertEquals((long)2L, (long)pipeline2.length);
            Assert.assertEquals((Object)rackCNode, (Object)pipeline2[1].getDatanodeDescriptor());
        }
        finally {
            this.removeNode(rackCNode);
        }
    }

    @Test
    public void testSufficientlyReplBlocksUsesNewRack() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doTestSufficientlyReplBlocksUsesNewRack(i);
        }
    }

    private void doTestSufficientlyReplBlocksUsesNewRack(int testIndex) throws IOException {
        List<DatanodeDescriptor> origNodes = this.rackA;
        BlockInfo blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        DatanodeStorageInfo[] pipeline = this.scheduleSingleReplication(blockInfo);
        Assert.assertEquals((long)2L, (long)pipeline.length);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origNodes.contains(pipeline[0].getDatanodeDescriptor()));
        Assert.assertTrue((String)("Destination node of replication should be on the other rack. Was: " + pipeline[1].getDatanodeDescriptor()), (boolean)this.rackB.contains(pipeline[1].getDatanodeDescriptor()));
    }

    @Test
    public void testBlocksAreNotUnderreplicatedInSingleRack() throws Exception {
        ImmutableList nodes = ImmutableList.of((Object)BlockManagerTestUtil.getDatanodeDescriptor("1.1.1.1", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("2.2.2.2", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("3.3.3.3", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("4.4.4.4", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("5.5.5.5", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("6.6.6.6", "/rackA", true));
        for (int i = 0; i < nodes.size(); ++i) {
            ((DatanodeDescriptor)nodes.get(i)).setDatanodeUuidForTesting("DN-Name-" + i);
        }
        this.addNodes((Iterable<DatanodeDescriptor>)nodes);
        List<DatanodeDescriptor> origNodes = nodes.subList(0, 3);
        for (int i = 0; i < 30; ++i) {
            this.doTestSingleRackClusterIsSufficientlyReplicated(i, origNodes);
        }
    }

    private void doTestSingleRackClusterIsSufficientlyReplicated(int testIndex, List<DatanodeDescriptor> origNodes) throws Exception {
        Assert.assertEquals((long)0L, (long)bm.numOfUnderReplicatedBlocks());
        this.addBlockOnNodes(testIndex, origNodes);
        bm.processMisReplicatedBlocks();
        Assert.assertEquals((long)0L, (long)bm.numOfUnderReplicatedBlocks());
    }

    private void fulfillPipeline(final BlockInfo blockInfo, DatanodeStorageInfo[] pipeline) throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.FULFILL_PIPELINE){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)blockInfo);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier)).add(lf.getIndividualBlockLock(blockInfo.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UR, LockFactory.BLK.UC, LockFactory.BLK.PE, LockFactory.BLK.IV}));
            }

            public Object performTask() throws IOException {
                DatanodeStorageInfo storage = (DatanodeStorageInfo)this.getParams()[0];
                bm.addBlock(storage, (Block)blockInfo, null);
                return null;
            }
        };
        for (int i = 1; i < pipeline.length; ++i) {
            handler.setParams(new Object[]{pipeline[i]}).handle();
        }
    }

    private static BlockInfo blockOnNodes(final long blkId, final List<DatanodeDescriptor> nodes, final int inode_id) throws IOException {
        return (BlockInfo)new HopsTransactionalRequestHandler(HDFSOperationType.BLOCK_ON_NODES){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(blkId, new INodeIdentifier(Integer.valueOf(inode_id)))).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE}));
            }

            public Object performTask() throws IOException {
                Block block = new Block(blkId);
                BlockInfo blockInfo = new BlockInfo(block, inode_id);
                for (DatanodeDescriptor dn : nodes) {
                    for (DatanodeStorageInfo storage : dn.getStorageInfos()) {
                        blockInfo.addReplica(storage);
                    }
                }
                return blockInfo;
            }
        }.handle();
    }

    private List<DatanodeDescriptor> getNodes(int ... indexes) {
        ArrayList ret = Lists.newArrayList();
        for (int idx : indexes) {
            ret.add(this.nodes.get(idx));
        }
        return ret;
    }

    private List<DatanodeDescriptor> getNodes(List<DatanodeStorageInfo> storages) {
        ArrayList ret = Lists.newArrayList();
        for (DatanodeStorageInfo s : storages) {
            ret.add(s.getDatanodeDescriptor());
        }
        return ret;
    }

    private List<DatanodeStorageInfo> getStorages(int ... indexes) {
        ArrayList ret = Lists.newArrayList();
        for (int idx : indexes) {
            ret.add(this.storages[idx]);
        }
        return ret;
    }

    private List<DatanodeDescriptor> startDecommission(int ... indexes) {
        List<DatanodeDescriptor> nodes = this.getNodes(indexes);
        for (DatanodeDescriptor node : nodes) {
            node.startDecommission();
        }
        return nodes;
    }

    private BlockInfo addBlockOnNodes(long blockId, List<DatanodeDescriptor> nodes) throws IOException {
        return TestBlockManager.addBlockOnNodes(blockId, nodes, 100);
    }

    private static BlockInfo addBlockOnNodes(final long blockId, List<DatanodeDescriptor> nodes, final int inodeId) throws IOException {
        LightWeightRequestHandler handle = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public INodeFile performTask() throws IOException {
                INodeFile file = new INodeFile(inodeId, new PermissionStatus(TestBlockManager.USER, TestBlockManager.GROUP, new FsPermission(511)), null, 3, System.currentTimeMillis(), System.currentTimeMillis(), 1000L, 0);
                file.setHasBlocksNoPersistance(true);
                file.setLocalNameNoPersistance("hop" + inodeId);
                file.setParentIdNoPersistance(1);
                file.setPartitionIdNoPersistance(Integer.valueOf(1));
                ArrayList<INodeFile> newed = new ArrayList<INodeFile>();
                newed.add(file);
                INodeDataAccess da = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                da.prepare(new ArrayList(), newed, new ArrayList());
                return file;
            }
        };
        INodeFile bc = (INodeFile)handle.handle();
        final BlockInfo blockInfo = TestBlockManager.blockOnNodes(blockId, nodes, inodeId);
        new HopsTransactionalRequestHandler(HDFSOperationType.BLOCK_ON_NODES, (BlockCollection)bc){
            INodeIdentifier inodeIdentifier;
            final /* synthetic */ BlockCollection val$bc;
            {
                this.val$bc = blockCollection;
                super(x0);
            }

            public void setUp() throws StorageException, IOException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlockID((long)blockId);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(blockId, this.inodeIdentifier));
            }

            public Object performTask() throws StorageException, IOException {
                bm.blocksMap.addBlockCollection(blockInfo, this.val$bc);
                return null;
            }
        }.handle();
        return blockInfo;
    }

    private DatanodeStorageInfo[] scheduleSingleReplication(final BlockInfo block) throws IOException {
        final ArrayList list_p1 = new ArrayList();
        final ArrayList list_all = new ArrayList();
        new HopsTransactionalRequestHandler(HDFSOperationType.SCHEDULE_SINGLE_REPLICATION){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier)).add(lf.getIndividualBlockLock(block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UR, LockFactory.BLK.PE}));
            }

            public Object performTask() throws StorageException, IOException {
                list_p1.add(block);
                list_all.add(new ArrayList());
                list_all.add(list_p1);
                Assert.assertEquals((String)"Block not initially pending replication", (long)0L, (long)bm.pendingReplications.getNumReplicas(block));
                return null;
            }
        }.handle((Object)this.fsn);
        Assert.assertEquals((String)"computeReplicationWork should indicate replication is needed", (long)1L, (long)bm.computeReplicationWorkForBlocks(list_all));
        return (DatanodeStorageInfo[])new HopsTransactionalRequestHandler(HDFSOperationType.SCHEDULE_SINGLE_REPLICATION){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier)).add(lf.getIndividualBlockLock(block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UR, LockFactory.BLK.PE}));
            }

            public Object performTask() throws IOException {
                Assert.assertTrue((String)"replication is pending after work is computed", (bm.pendingReplications.getNumReplicas(block) > 0 ? 1 : 0) != 0);
                LinkedListMultimap repls = TestBlockManager.this.getAllPendingReplications();
                Assert.assertEquals((long)1L, (long)repls.size());
                Map.Entry repl = (Map.Entry)repls.entries().iterator().next();
                DatanodeStorageInfo[] targets = ((DatanodeDescriptor.BlockTargetPair)repl.getValue()).targets;
                DatanodeStorageInfo[] pipeline = new DatanodeStorageInfo[1 + targets.length];
                pipeline[0] = (DatanodeStorageInfo)repl.getKey();
                System.arraycopy(targets, 0, pipeline, 1, targets.length);
                return pipeline;
            }
        }.handle((Object)this.fsn);
    }

    private LinkedListMultimap<DatanodeStorageInfo, DatanodeDescriptor.BlockTargetPair> getAllPendingReplications() {
        LinkedListMultimap repls = LinkedListMultimap.create();
        for (DatanodeDescriptor dn : this.nodes) {
            List thisRepls = dn.getReplicationCommand(10);
            if (thisRepls == null) continue;
            for (DatanodeStorageInfo storage : dn.getStorageInfos()) {
                repls.putAll((Object)storage, (Iterable)thisRepls);
            }
        }
        return repls;
    }

    @Test
    public void testHighestPriReplSrcChosenDespiteMaxReplLimit() throws Exception {
        this.formatStorage();
        TestBlockManager.bm.maxReplicationStreams = 0;
        TestBlockManager.bm.replicationStreamsHardLimit = 1;
        long blockId = 42L;
        final Block aBlock = new Block(42L, 0L, 0L);
        final List<DatanodeDescriptor> origNodes = this.getNodes(0, 1);
        this.addNodes(origNodes);
        this.addBlockOnNodes(42L, origNodes.subList(0, 1));
        final LinkedList cntNodes = new LinkedList();
        final LinkedList liveNodes = new LinkedList();
        new HopsTransactionalRequestHandler(HDFSOperationType.TEST){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)aBlock);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier)).add(lf.getIndividualBlockLock(aBlock.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UR, LockFactory.BLK.PE}));
            }

            public Object performTask() throws IOException {
                Assert.assertNotNull((String)"Chooses source node for a highest-priority replication even if all available source nodes have reached their replication limits below the hard limit.", (Object)bm.chooseSourceDatanode(aBlock, cntNodes, liveNodes, new NumberReplicas(), 0));
                Assert.assertNull((String)"Does not choose a source node for a less-than-highest-priority replication since all available source nodes have reached their replication limits.", (Object)bm.chooseSourceDatanode(aBlock, cntNodes, liveNodes, new NumberReplicas(), 1));
                DatanodeStorageInfo[] targets = new DatanodeStorageInfo[]{((DatanodeDescriptor)origNodes.get(1)).getStorageInfos()[0]};
                ((DatanodeDescriptor)origNodes.get(0)).addBlockToBeReplicated(aBlock, targets);
                Assert.assertNull((String)"Does not choose a source node for a highest-priority replication when all available nodes exceed the hard limit.", (Object)bm.chooseSourceDatanode(aBlock, cntNodes, liveNodes, new NumberReplicas(), 0));
                return null;
            }
        }.handle();
    }

    @Test
    public void testSafeModeIBR() throws Exception {
        DatanodeDescriptor node = (DatanodeDescriptor)Mockito.spy((Object)this.nodes.get(0));
        DatanodeStorageInfo ds = node.getStorageInfos()[0];
        node.setDatanodeUuidForTesting(ds.getStorageID());
        node.isAlive = true;
        DatanodeRegistration nodeReg = new DatanodeRegistration((DatanodeID)node, null, null, "");
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).isInStartupSafeMode();
        bm.getDatanodeManager().registerDatanode(nodeReg);
        bm.getDatanodeManager().addDatanode(node);
        Assert.assertEquals((Object)node, (Object)bm.getDatanodeManager().getDatanode((DatanodeID)node));
        Assert.assertEquals((long)0L, (long)ds.getBlockReportCount());
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), BlockReport.builder((int)this.numBuckets).build());
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), BlockReport.builder((int)this.numBuckets).build());
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
        bm.getDatanodeManager().removeDatanode((DatanodeID)node);
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        bm.getDatanodeManager().registerDatanode(nodeReg);
        ((DatanodeDescriptor)Mockito.verify((Object)node)).updateRegInfo((DatanodeID)nodeReg);
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), BlockReport.builder((int)this.numBuckets).build());
        ds = node.getStorageInfos()[0];
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
    }

    @Test
    public void testSafeModeIBRAfterIncremental() throws Exception {
        DatanodeDescriptor node = (DatanodeDescriptor)Mockito.spy((Object)this.nodes.get(0));
        DatanodeStorageInfo ds = node.getStorageInfos()[0];
        node.setDatanodeUuidForTesting(ds.getStorageID());
        node.isAlive = true;
        DatanodeRegistration nodeReg = new DatanodeRegistration((DatanodeID)node, null, null, "");
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).isInStartupSafeMode();
        bm.getDatanodeManager().registerDatanode(nodeReg);
        bm.getDatanodeManager().addDatanode(node);
        Assert.assertEquals((Object)node, (Object)bm.getDatanodeManager().getDatanode((DatanodeID)node));
        Assert.assertEquals((long)0L, (long)ds.getBlockReportCount());
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        ((DatanodeDescriptor)Mockito.doReturn((Object)1).when((Object)node)).numBlocks();
        bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), BlockReport.builder((int)this.numBuckets).build());
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
    }

    @Test
    public void testUseDelHint() throws IOException {
        DatanodeStorageInfo delHint = new DatanodeStorageInfo(DFSTestUtil.getLocalDatanodeDescriptor(), new DatanodeStorage("id"));
        List<DatanodeStorageInfo> moreThan1Racks = Arrays.asList(delHint);
        ArrayList<StorageType> excessTypes = new ArrayList<StorageType>();
        excessTypes.add(StorageType.DEFAULT);
        Assert.assertTrue((boolean)BlockManager.useDelHint((boolean)true, (DatanodeStorageInfo)delHint, null, moreThan1Racks, excessTypes));
        excessTypes.remove(0);
        excessTypes.add(StorageType.SSD);
        Assert.assertFalse((boolean)BlockManager.useDelHint((boolean)true, (DatanodeStorageInfo)delHint, null, moreThan1Racks, excessTypes));
    }

    @Test
    public void testRemoveBlocks() throws IOException, InterruptedException, ExecutionException {
        ArrayList<DatanodeDescriptor> testNodes = new ArrayList<DatanodeDescriptor>();
        testNodes.add(this.nodes.get(0));
        testNodes.add(this.nodes.get(1));
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        long blockId = 0L;
        ArrayList<Long> blockIds = new ArrayList<Long>();
        for (int i = 2; i < 4002; ++i) {
            for (int j = 0; j < 2; ++j) {
                blockIds.add(blockId);
                futures.add(executor.submit(new SliceRunner(blockId++, testNodes, i)));
            }
        }
        for (Future future : futures) {
            future.get();
        }
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        Iterator iterator = ((DatanodeDescriptor)testNodes.get(0)).getSidsOnNode().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.checkNbReplicas(n, blockIds.size());
        }
        iterator = ((DatanodeDescriptor)testNodes.get(1)).getSidsOnNode().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.checkNbReplicas(n, blockIds.size());
        }
        bm.removeBlocks(blockIds, (DatanodeDescriptor)testNodes.get(0));
        iterator = ((DatanodeDescriptor)testNodes.get(0)).getSidsOnNode().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.checkNbReplicas(n, 0);
        }
        iterator = ((DatanodeDescriptor)testNodes.get(1)).getSidsOnNode().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.checkNbReplicas(n, blockIds.size());
        }
    }

    private void checkNbReplicas(final int sid, final int expected) throws IOException {
        new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                ReplicaDataAccess da = (ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class);
                Assert.assertEquals((long)expected, (long)da.countAllReplicasForStorageId(sid));
                return null;
            }
        }.handle();
    }

    private static class SliceRunner
    implements Callable<Object> {
        long blockId;
        List<DatanodeDescriptor> testNodes;
        int inodeId;

        public SliceRunner(long blockId, List<DatanodeDescriptor> testNodes, int inodeId) {
            this.blockId = blockId;
            this.testNodes = testNodes;
            this.inodeId = inodeId;
        }

        @Override
        public Object call() throws Exception {
            TestBlockManager.addBlockOnNodes(this.blockId++, this.testNodes, this.inodeId);
            return null;
        }
    }
}

