/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.UnderReplicatedBlocks;
import org.junit.Assert;
import org.junit.Test;

public class TestUnderReplicatedBlockQueues
extends Assert {
    @Test
    public void testBlockPriorities() throws Throwable {
        HdfsStorageFactory.setConfiguration((Configuration)new HdfsConfiguration());
        HdfsStorageFactory.formatStorage();
        UnderReplicatedBlocks queues = new UnderReplicatedBlocks();
        BlockInfo block1 = this.add(new BlockInfo(new Block(1L), 1));
        BlockInfo block2 = this.add(new BlockInfo(new Block(2L), 2));
        BlockInfo block_very_under_replicated = this.add(new BlockInfo(new Block(3L), 3));
        BlockInfo block_corrupt = this.add(new BlockInfo(new Block(4L), 4));
        this.assertAdded(queues, block1, 1, 0, 3);
        TestUnderReplicatedBlockQueues.assertEquals((long)1L, (long)queues.getUnderReplicatedBlockCount());
        TestUnderReplicatedBlockQueues.assertEquals((long)1L, (long)queues.size());
        this.assertInLevel(queues, block1, 0);
        TestUnderReplicatedBlockQueues.assertFalse((boolean)this.add(queues, block1, 1, 0, 3));
        this.assertAdded(queues, block2, 2, 0, 3);
        TestUnderReplicatedBlockQueues.assertEquals((long)2L, (long)queues.getUnderReplicatedBlockCount());
        TestUnderReplicatedBlockQueues.assertEquals((long)2L, (long)queues.size());
        this.assertInLevel(queues, block2, 2);
        this.assertAdded(queues, block_corrupt, 0, 0, 3);
        TestUnderReplicatedBlockQueues.assertEquals((long)3L, (long)queues.size());
        TestUnderReplicatedBlockQueues.assertEquals((long)2L, (long)queues.getUnderReplicatedBlockCount());
        TestUnderReplicatedBlockQueues.assertEquals((long)1L, (long)queues.getCorruptBlockSize());
        this.assertInLevel(queues, block_corrupt, 4);
        this.assertAdded(queues, block_very_under_replicated, 4, 0, 25);
        this.assertInLevel(queues, block_very_under_replicated, 1);
    }

    private void assertAdded(UnderReplicatedBlocks queues, BlockInfo block, int curReplicas, int decomissionedReplicas, int expectedReplicas) throws IOException {
        TestUnderReplicatedBlockQueues.assertTrue((String)("Failed to add " + block), (boolean)this.add(queues, block, curReplicas, decomissionedReplicas, expectedReplicas));
    }

    private void assertInLevel(UnderReplicatedBlocks queues, BlockInfo block, int level) {
        UnderReplicatedBlocks.BlockIterator bi = queues.iterator(level);
        while (bi.hasNext()) {
            Block next = bi.next();
            if (!block.equals((Object)next)) continue;
            return;
        }
        TestUnderReplicatedBlockQueues.fail((String)("Block " + block + " not found in level " + level));
    }

    private BlockInfo add(final BlockInfo block) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws StorageException, IOException {
                EntityManager.add((Object)new BlockInfo(block));
                return null;
            }
        }.handle();
        return block;
    }

    private boolean add(final UnderReplicatedBlocks queues, final BlockInfo block, final int curReplicas, final int decomissionedReplicas, final int expectedReplicas) throws IOException {
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(block.getBlockId(), new INodeIdentifier(Integer.valueOf(block.getInodeId())))).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.UR}));
            }

            public Object performTask() throws StorageException, IOException {
                return queues.add(block, curReplicas, decomissionedReplicas, expectedReplicas);
            }
        }.handle();
    }
}

