/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import com.google.common.base.Strings;
import io.hops.metadata.StorageMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TestJspHelper {
    private Configuration conf = new HdfsConfiguration();
    private String jspWriterOutput = "";

    @Test
    public void testGetUgi() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String user = "TheDoctor";
        Text userText = new Text(user);
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(userText, userText, null);
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)new DummySecretManager(0L, 0L, 0L, 0L));
        String tokenString = token.encodeToUrlString();
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)user);
        Mockito.when((Object)request.getParameter("nnaddr")).thenReturn((Object)"1.1.1.1:1111");
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.verifyServiceInToken(context, request, "1.1.1.1:1111");
        Mockito.when((Object)request.getParameter("nnaddr")).thenReturn(null);
        InetSocketAddress addr = new InetSocketAddress("localhost", 2222);
        Mockito.when((Object)context.getAttribute("name.node.address")).thenReturn((Object)addr);
        this.verifyServiceInToken(context, request, addr.getAddress().getHostAddress() + ":2222");
        token.setService(new Text("3.3.3.3:3333"));
        tokenString = token.encodeToUrlString();
        Mockito.when((Object)context.getAttribute("name.node.address")).thenReturn(null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        this.verifyServiceInToken(context, request, "3.3.3.3:3333");
    }

    private void verifyServiceInToken(ServletContext context, HttpServletRequest request, String expected) throws IOException {
        UserGroupInformation ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Token tokenInUgi = (Token)ugi.getTokens().iterator().next();
        Assert.assertEquals((Object)expected, (Object)tokenInUgi.getService().toString());
    }

    @Test
    public void testDelegationTokenUrlParam() {
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        String tokenString = "xyzabc";
        String delegationTokenParam = JspHelper.getDelegationTokenUrlParam((String)tokenString);
        Assert.assertEquals((Object)"&delegation=xyzabc", (Object)delegationTokenParam);
        this.conf.set("hadoop.security.authentication", "simple");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        delegationTokenParam = JspHelper.getDelegationTokenUrlParam((String)tokenString);
        Assert.assertEquals((Object)"", (Object)delegationTokenParam);
    }

    @Test
    public void testGetUgiFromToken() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String realUser = "TheDoctor";
        String user = "TheNurse";
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        Text ownerText = new Text(user);
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(ownerText, ownerText, new Text(realUser));
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)new DummySecretManager(0L, 0L, 0L, 0L));
        String tokenString = token.encodeToUrlString();
        HttpServletRequest request = this.getMockRequest(null, null, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        UserGroupInformation ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getRealUser().getShortUserName(), (Object)realUser);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)user);
        this.checkUgiFromToken(ugi);
        request = this.getMockRequest(realUser, null, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getRealUser().getShortUserName(), (Object)realUser);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)user);
        this.checkUgiFromToken(ugi);
        request = this.getMockRequest("rogue", null, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getRealUser().getShortUserName(), (Object)realUser);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)user);
        this.checkUgiFromToken(ugi);
        request = this.getMockRequest(null, user, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getRealUser().getShortUserName(), (Object)realUser);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)user);
        this.checkUgiFromToken(ugi);
        request = this.getMockRequest(null, null, "rogue");
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)("Usernames not matched: name=rogue != expected=" + user), (Object)ioe.getMessage());
        }
        request = this.getMockRequest(null, user, "rogue");
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)("Usernames not matched: name=rogue != expected=" + user), (Object)ioe.getMessage());
        }
    }

    @Test
    public void testGetNonProxyUgi() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String realUser = "TheDoctor";
        String user = "TheNurse";
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        HttpServletRequest request = this.getMockRequest(null, null, null);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"Security enabled but user not authenticated by filter", (Object)ioe.getMessage());
        }
        request = this.getMockRequest(null, realUser, null);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"Security enabled but user not authenticated by filter", (Object)ioe.getMessage());
        }
        request = this.getMockRequest(realUser, null, null);
        UserGroupInformation ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)realUser);
        this.checkUgiFromAuth(ugi);
        request = this.getMockRequest(realUser, realUser, null);
        ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)realUser);
        this.checkUgiFromAuth(ugi);
        request = this.getMockRequest(realUser, user, null);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)("Usernames not matched: name=" + user + " != expected=" + realUser), (Object)ioe.getMessage());
        }
    }

    @Test
    public void testGetProxyUgi() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String realUser = "TheDoctor";
        String user = "TheNurse";
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(realUser), "*");
        this.conf.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(realUser), "*");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.conf);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        HttpServletRequest request = this.getMockRequest(null, null, user);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"Security enabled but user not authenticated by filter", (Object)ioe.getMessage());
        }
        request = this.getMockRequest(null, realUser, user);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"Security enabled but user not authenticated by filter", (Object)ioe.getMessage());
        }
        request = this.getMockRequest(realUser, null, user);
        UserGroupInformation ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getRealUser().getShortUserName(), (Object)realUser);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)user);
        this.checkUgiFromAuth(ugi);
        request = this.getMockRequest(realUser, realUser, user);
        ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Assert.assertNotNull((Object)ugi.getRealUser());
        Assert.assertEquals((Object)ugi.getRealUser().getShortUserName(), (Object)realUser);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)user);
        this.checkUgiFromAuth(ugi);
        request = this.getMockRequest(realUser, user, user);
        try {
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)("Usernames not matched: name=" + user + " != expected=" + realUser), (Object)ioe.getMessage());
        }
        try {
            request = this.getMockRequest(user, null, realUser);
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad proxy request allowed");
        }
        catch (AuthorizationException ae) {
            Assert.assertEquals((Object)("User: " + user + " is not allowed to impersonate " + realUser), (Object)ae.getMessage());
        }
        try {
            request = this.getMockRequest(user, user, realUser);
            JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
            Assert.fail((String)"bad proxy request allowed");
        }
        catch (AuthorizationException ae) {
            Assert.assertEquals((Object)("User: " + user + " is not allowed to impersonate " + realUser), (Object)ae.getMessage());
        }
    }

    @Test
    public void testPrintGotoFormWritesValidXML() throws IOException, ParserConfigurationException, SAXException {
        JspWriter mockJspWriter = (JspWriter)Mockito.mock(JspWriter.class);
        ArgumentCaptor arg = ArgumentCaptor.forClass(String.class);
        ((JspWriter)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invok) {
                Object[] args = invok.getArguments();
                TestJspHelper.this.jspWriterOutput = TestJspHelper.this.jspWriterOutput + (String)args[0];
                return null;
            }
        }).when((Object)mockJspWriter)).print((String)arg.capture());
        this.jspWriterOutput = "";
        JspHelper.printGotoForm((JspWriter)mockJspWriter, (int)424242, (String)"a token string", (String)"foobar/file", (String)"0.0.0.0");
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(this.jspWriterOutput));
        parser.parse(is);
    }

    private HttpServletRequest getMockRequest(String remoteUser, String user, String doAs) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getParameter("user.name")).thenReturn((Object)user);
        if (doAs != null) {
            Mockito.when((Object)request.getParameter("doas")).thenReturn((Object)doAs);
        }
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)remoteUser);
        return request;
    }

    private void checkUgiFromAuth(UserGroupInformation ugi) {
        if (ugi.getRealUser() != null) {
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.PROXY, (Object)ugi.getAuthenticationMethod());
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS_SSL, (Object)ugi.getRealUser().getAuthenticationMethod());
        } else {
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS_SSL, (Object)ugi.getAuthenticationMethod());
        }
    }

    private void checkUgiFromToken(UserGroupInformation ugi) {
        if (ugi.getRealUser() != null) {
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.PROXY, (Object)ugi.getAuthenticationMethod());
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.TOKEN, (Object)ugi.getRealUser().getAuthenticationMethod());
        } else {
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.TOKEN, (Object)ugi.getAuthenticationMethod());
        }
    }

    @Test
    public void testSortNodeByFields() throws Exception {
        DatanodeID dnId1 = new DatanodeID("127.0.0.1", "localhost1", "datanode1", 1234, 2345, 3456, 4567);
        DatanodeID dnId2 = new DatanodeID("127.0.0.2", "localhost2", "datanode2", 1235, 2346, 3457, 4568);
        StorageMap storageMap = (StorageMap)Mockito.mock(StorageMap.class);
        DatanodeDescriptor dnDesc1 = new DatanodeDescriptor(storageMap, dnId1, "rack1");
        DatanodeDescriptor dnDesc2 = new DatanodeDescriptor(storageMap, dnId2, "rack2");
        BlockManagerTestUtil.updateStorage(dnDesc1, new DatanodeStorage("dnStorage1"));
        BlockManagerTestUtil.updateStorage(dnDesc2, new DatanodeStorage("dnStorage2"));
        DatanodeStorage dns1 = new DatanodeStorage("dnStorage1");
        DatanodeStorage dns2 = new DatanodeStorage("dnStorage2");
        StorageReport[] report1 = new StorageReport[]{new StorageReport(dns1, false, 1024L, 100L, 924L, 100L)};
        StorageReport[] report2 = new StorageReport[]{new StorageReport(dns2, false, 2500L, 200L, 1848L, 200L)};
        dnDesc1.updateHeartbeat(report1, 5L, 3L, 10, 2);
        dnDesc2.updateHeartbeat(report2, 10L, 2L, 20, 1);
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        live.add(dnDesc1);
        live.add(dnDesc2);
        JspHelper.sortNodeList(live, (String)"volfails", (String)"ASC");
        Assert.assertEquals((Object)dnDesc2, live.get(0));
        Assert.assertEquals((Object)dnDesc1, live.get(1));
        JspHelper.sortNodeList(live, (String)"volfails", (String)"DSC");
        Assert.assertEquals((Object)dnDesc1, live.get(0));
        Assert.assertEquals((Object)dnDesc2, live.get(1));
        JspHelper.sortNodeList(live, (String)"bpused", (String)"ASC");
        Assert.assertEquals((Object)dnDesc1, live.get(0));
        Assert.assertEquals((Object)dnDesc2, live.get(1));
        JspHelper.sortNodeList(live, (String)"bpused", (String)"DSC");
        Assert.assertEquals((Object)dnDesc2, live.get(0));
        Assert.assertEquals((Object)dnDesc1, live.get(1));
        JspHelper.sortNodeList(live, (String)"pcbpused", (String)"ASC");
        Assert.assertEquals((Object)dnDesc2, live.get(0));
        Assert.assertEquals((Object)dnDesc1, live.get(1));
        JspHelper.sortNodeList(live, (String)"pcbpused", (String)"DSC");
        Assert.assertEquals((Object)dnDesc1, live.get(0));
        Assert.assertEquals((Object)dnDesc2, live.get(1));
        JspHelper.sortNodeList(live, (String)"unexists", (String)"ASC");
        Assert.assertEquals((Object)dnDesc1, live.get(0));
        Assert.assertEquals((Object)dnDesc2, live.get(1));
        JspHelper.sortNodeList(live, (String)"unexists", (String)"DSC");
        Assert.assertEquals((Object)dnDesc2, live.get(0));
        Assert.assertEquals((Object)dnDesc1, live.get(1));
        JspHelper.sortNodeList(live, (String)"capacity", (String)"ASC");
        Assert.assertEquals((Object)dnDesc1, live.get(0));
        Assert.assertEquals((Object)dnDesc2, live.get(1));
        JspHelper.sortNodeList(live, (String)"capacity", (String)"DSC");
        Assert.assertEquals((Object)dnDesc2, live.get(0));
        Assert.assertEquals((Object)dnDesc1, live.get(1));
        JspHelper.sortNodeList(live, (String)"used", (String)"ASC");
        Assert.assertEquals((Object)dnDesc1, live.get(0));
        Assert.assertEquals((Object)dnDesc2, live.get(1));
        JspHelper.sortNodeList(live, (String)"used", (String)"DSC");
        Assert.assertEquals((Object)dnDesc2, live.get(0));
        Assert.assertEquals((Object)dnDesc1, live.get(1));
        JspHelper.sortNodeList(live, (String)"nondfsused", (String)"ASC");
        Assert.assertEquals((Object)dnDesc1, live.get(0));
        Assert.assertEquals((Object)dnDesc2, live.get(1));
        JspHelper.sortNodeList(live, (String)"nondfsused", (String)"DSC");
        Assert.assertEquals((Object)dnDesc2, live.get(0));
        Assert.assertEquals((Object)dnDesc1, live.get(1));
        JspHelper.sortNodeList(live, (String)"remaining", (String)"ASC");
        Assert.assertEquals((Object)dnDesc1, live.get(0));
        Assert.assertEquals((Object)dnDesc2, live.get(1));
        JspHelper.sortNodeList(live, (String)"remaining", (String)"DSC");
        Assert.assertEquals((Object)dnDesc2, live.get(0));
        Assert.assertEquals((Object)dnDesc1, live.get(1));
    }

    @Test
    public void testPrintMethods() throws IOException {
        JspWriter out = (JspWriter)Mockito.mock(JspWriter.class);
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        final StringBuffer buffer = new StringBuffer();
        ArgumentCaptor arg = ArgumentCaptor.forClass(String.class);
        ((JspWriter)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invok) {
                Object[] args = invok.getArguments();
                buffer.append((String)args[0]);
                return null;
            }
        }).when((Object)out)).print((String)arg.capture());
        JspHelper.createTitle((JspWriter)out, (HttpServletRequest)req, (String)"testfile.txt");
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)1))).print(Mockito.anyString());
        JspHelper.addTableHeader((JspWriter)out);
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)3))).print(Mockito.anyString());
        JspHelper.addTableRow((JspWriter)out, (String[])new String[]{" row11", "row12 "});
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)7))).print(Mockito.anyString());
        JspHelper.addTableRow((JspWriter)out, (String[])new String[]{" row11", "row12 "}, (int)3);
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)11))).print(Mockito.anyString());
        JspHelper.addTableRow((JspWriter)out, (String[])new String[]{" row21", "row22"});
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)15))).print(Mockito.anyString());
        JspHelper.addTableFooter((JspWriter)out);
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)16))).print(Mockito.anyString());
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)buffer.toString()));
    }

    @Test
    public void testReadWriteReplicaState() {
        try {
            DataOutputBuffer out = new DataOutputBuffer();
            DataInputBuffer in = new DataInputBuffer();
            for (HdfsServerConstants.ReplicaState repState : HdfsServerConstants.ReplicaState.values()) {
                repState.write((DataOutput)out);
                in.reset(out.getData(), out.getLength());
                HdfsServerConstants.ReplicaState result = HdfsServerConstants.ReplicaState.read((DataInput)in);
                Assert.assertTrue((String)"testReadWrite error !!!", (repState == result ? 1 : 0) != 0);
                out.reset();
                in.reset();
            }
        }
        catch (Exception ex) {
            Assert.fail((String)"testReadWrite ex error ReplicaState");
        }
    }

    @Test
    public void testAuthority() {
        DatanodeID dnWithIp = new DatanodeID("127.0.0.1", "hostName", null, 50020, 50075, 50076, 50010);
        Assert.assertNotNull((Object)JspHelper.Url.authority((String)"http", (DatanodeID)dnWithIp));
        DatanodeID dnWithNullIp = new DatanodeID(null, "hostName", null, 50020, 50075, 50076, 50010);
        Assert.assertNotNull((Object)JspHelper.Url.authority((String)"http", (DatanodeID)dnWithNullIp));
        DatanodeID dnWithEmptyIp = new DatanodeID("", "hostName", null, 50020, 50075, 50076, 50010);
        Assert.assertNotNull((Object)JspHelper.Url.authority((String)"http", (DatanodeID)dnWithEmptyIp));
    }

    public static class DummySecretManager
    extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
        public DummySecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        }

        public DelegationTokenIdentifier createIdentifier() {
            return null;
        }

        public byte[] createPassword(DelegationTokenIdentifier dtId) {
            return new byte[1];
        }
    }
}

