/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.HdfsStorageFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.blockmanagement.BRTrackingService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestBlockReportLoadBalancing2 {
    public static final Log LOG = LogFactory.getLog(TestBlockReportLoadBalancing2.class);

    @Before
    public void startUpCluster() throws IOException {
    }

    @After
    public void shutDownCluster() throws IOException {
    }

    @Ignore
    @Test
    public void TestClusterWithDataNodes() throws Exception {
        int NN_COUNT = 2;
        long DFS_BR_LB_TIME_WINDOW_SIZE = 10000L;
        long DFS_BR_LB_MAX_BLK_PER_NN_PER_TW = 10L;
        long DFS_BR_LB_DB_VAR_UPDATE_THRESHOLD = 1L;
        int BLOCK_SIZE = 1024;
        int NUM_BLOCKS = 10;
        int FILE_SIZE = 10240;
        String METHOD_NAME = GenericTestUtils.getMethodName();
        LOG.debug((Object)(METHOD_NAME + " Starting test"));
        Configuration conf = new Configuration();
        conf.setLong("dfs.block.report.load.balancing.max.blks.per.time.window", 10L);
        conf.setLong("dfs.block.report.load.balancing.time.window.size", 10000L);
        conf.setLong("dfs.block.report.load.balancing.db.var.update.threashold", 1L);
        conf.setLong("dfs.blocksize", 1024L);
        conf.setLong("dfs.blockreport.initialDelay", 0L);
        conf.setLong("dfs.blockreport.intervalMsec", 3000L);
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).format(true).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).numDataNodes(1).build();
        cluster.waitActive();
        LOG.debug((Object)(METHOD_NAME + " Cluster is up"));
        FileSystem fs = cluster.getNewFileSystemInstance(0);
        Path filePath = new Path("/" + METHOD_NAME + ".dat");
        DFSTestUtil.createFile(fs, filePath, 10240L, (short)1, 0L);
        LOG.debug((Object)(METHOD_NAME + " Files are created"));
        final ArrayList history = new ArrayList();
        GenericTestUtils.DelayAnswer responder = new GenericTestUtils.DelayAnswer(LOG){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object passThrough(InvocationOnMock invocation) throws Throwable {
                LOG.debug((Object)"Block report received");
                1 var2_2 = this;
                synchronized (var2_2) {
                    history.add(System.currentTimeMillis());
                }
                return super.passThrough(invocation);
            }
        };
        NameNode nn0 = cluster.getNameNode(0);
        NameNode nn1 = cluster.getNameNode(1);
        DataNode dn0 = cluster.getDataNodes().get(0);
        DatanodeProtocolClientSideTranslatorPB spy0 = DataNodeTestUtils.spyOnBposToNN(dn0, nn0);
        DatanodeProtocolClientSideTranslatorPB spy1 = DataNodeTestUtils.spyOnBposToNN(dn0, nn1);
        ((DatanodeProtocol)Mockito.doAnswer((Answer)responder).when((Object)spy0)).blockReport((DatanodeRegistration)Mockito.anyObject(), Mockito.anyString(), (StorageBlockReport[])Mockito.anyObject());
        ((DatanodeProtocol)Mockito.doAnswer((Answer)responder).when((Object)spy1)).blockReport((DatanodeRegistration)Mockito.anyObject(), Mockito.anyString(), (StorageBlockReport[])Mockito.anyObject());
        responder.waitForCall();
        responder.proceed();
        Thread.sleep(32000L);
        int counter = 0;
        LOG.debug((Object)("All No " + Arrays.toString(history.toArray())));
        long previousTime = (Long)history.remove(0);
        for (Long time : history) {
            long diff = time - previousTime;
            if (diff >= 10000L) {
                ++counter;
            }
            LOG.debug((Object)("Diff " + diff));
            previousTime = time;
        }
        Assert.assertTrue((String)("Expecting 3. Got " + counter), (counter == 3 ? 1 : 0) != 0);
    }

    private static ActiveNode assignWork(SortedActiveNodeList nnList, BRTrackingService service, long blks) {
        try {
            return service.assignWork(nnList, blks);
        }
        catch (Exception e) {
            return null;
        }
    }
}

