/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.common.IDsGeneratorFactory;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.leader_election.node.SortedActiveNodeListPBImpl;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DirectoryListingStartAfterNotFoundException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestINodeFile {
    public static final Log LOG = LogFactory.getLog(TestINodeFile.class);
    static final short BLOCKBITS = 48;
    static final long BLKSIZE_MAXVALUE = 0xFFFFFFFFFFFFL;
    private String userName = "Test";
    private static final PermissionStatus perm = new PermissionStatus("userName", null, FsPermission.getDefault());
    private short replication;
    private long preferredBlockSize;
    static int blkid = 0;

    @Before
    public void setup() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
    }

    INodeFile createINodeFile(short replication, long preferredBlockSize) throws IOException {
        return new INodeFile(0, perm, null, replication, 0L, 0L, preferredBlockSize, 0);
    }

    private static INodeFile createINodeFile(byte storagePolicyID) throws IOException {
        return new INodeFile(0, perm, null, 3, 0L, 0L, 1024L, storagePolicyID);
    }

    @Test
    public void testStoragePolicyID() throws IOException {
        for (byte i = 1; i < 16; i = (byte)(i + 1)) {
            INodeFile f = TestINodeFile.createINodeFile(i);
            Assert.assertEquals((long)i, (long)f.getStoragePolicyID());
        }
    }

    @Test
    public void testReplication() throws IOException {
        this.replication = (short)3;
        this.preferredBlockSize = 0x8000000L;
        INodeFile inf = this.createINodeFile(this.replication, this.preferredBlockSize);
        Assert.assertEquals((String)"True has to be returned in this case", (long)this.replication, (long)inf.getBlockReplication());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplicationBelowLowerBound() throws IllegalArgumentException, IOException {
        this.replication = (short)-1;
        this.preferredBlockSize = 0x8000000L;
        this.createINodeFile(this.replication, this.preferredBlockSize);
    }

    @Test
    public void testPreferredBlockSize() throws IOException {
        this.replication = (short)3;
        this.preferredBlockSize = 0x8000000L;
        INodeFile inf = this.createINodeFile(this.replication, this.preferredBlockSize);
        Assert.assertEquals((String)"True has to be returned in this case", (long)this.preferredBlockSize, (long)inf.getPreferredBlockSize());
    }

    @Test
    public void testPreferredBlockSizeUpperBound() throws IOException {
        this.replication = (short)3;
        this.preferredBlockSize = 0xFFFFFFFFFFFFL;
        INodeFile inf = this.createINodeFile(this.replication, this.preferredBlockSize);
        Assert.assertEquals((String)"True has to be returned in this case", (long)0xFFFFFFFFFFFFL, (long)inf.getPreferredBlockSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPreferredBlockSizeBelowLowerBound() throws IllegalArgumentException, IOException {
        this.replication = (short)3;
        this.preferredBlockSize = -1L;
        this.createINodeFile(this.replication, this.preferredBlockSize);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPreferredBlockSizeAboveUpperBound() throws IllegalArgumentException, IOException {
        this.replication = (short)3;
        this.preferredBlockSize = 0x1000000000000L;
        this.createINodeFile(this.replication, this.preferredBlockSize);
    }

    @Test
    @Ignore
    public void testGetFullPathName() throws IOException {
        PermissionStatus perms = new PermissionStatus(this.userName, null, FsPermission.getDefault());
        this.replication = (short)3;
        this.preferredBlockSize = 0x8000000L;
        INodeFile inf = this.createINodeFile(this.replication, this.preferredBlockSize);
        inf.setLocalName("f");
        INodeDirectory root = new INodeDirectory(1, "", perms);
        INodeDirectory dir = new INodeDirectory(IDsGeneratorFactory.getInstance().getUniqueINodeID(), "d", perms);
        Assert.assertEquals((Object)"f", (Object)inf.getFullPathName());
        Assert.assertEquals((Object)"", (Object)inf.getLocalParentDir());
        dir.addChild((INode)inf, false);
        Assert.assertEquals((Object)"d/f", (Object)inf.getFullPathName());
        Assert.assertEquals((Object)"d", (Object)inf.getLocalParentDir());
        root.addChild((INode)dir, false);
        Assert.assertEquals((Object)"/d/f", (Object)inf.getFullPathName());
        Assert.assertEquals((Object)"/d", (Object)dir.getFullPathName());
        Assert.assertEquals((Object)"/", (Object)root.getFullPathName());
        Assert.assertEquals((Object)"/", (Object)root.getLocalParentDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFullPathNameAfterSetQuota() throws Exception {
        long fileLen = 1024L;
        this.replication = (short)3;
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(this.replication).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            FSDirectory fsdir = fsn.getFSDirectory();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            Path file = new Path(dir, "file");
            DFSTestUtil.createFile((FileSystem)dfs, file, fileLen, this.replication, 0L);
            this.checkFullPathName(fsdir, file, cluster);
            dfs.setQuota(dir, 0x7FFFFFFFFFFFFFFEL, (long)this.replication * fileLen * 10L);
            Path newDir = new Path("/newdir");
            Path newFile = new Path(newDir, "file");
            dfs.rename(dir, newDir, new Options.Rename[]{Options.Rename.OVERWRITE});
            this.checkFullPathName(fsdir, newFile, cluster);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void checkFullPathName(final FSDirectory fsdir, final Path file, final MiniDFSCluster cluster) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, new String[]{file.toString()}).setNameNodeID(cluster.getNameNode().getId()).setActiveNameNodes((Collection)cluster.getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockLock());
            }

            public Object performTask() throws StorageException, IOException {
                INode fnode = fsdir.getINode(file.toString());
                Assert.assertEquals((Object)file.toString(), (Object)fnode.getFullPathName());
                return null;
            }
        }.handle();
    }

    @Test
    @Ignore
    public void testAppendBlocks() throws IOException {
        INodeFile origFile = this.createINodeFiles(1, "origfile")[0];
        Assert.assertEquals((String)"Number of blocks didn't match", (long)origFile.numBlocks(), (long)1L);
        INodeFile[] appendFiles = this.createINodeFiles(4, "appendfile");
        origFile.appendBlocks(appendFiles, this.getTotalBlocks(appendFiles));
        Assert.assertEquals((String)"Number of blocks didn't match", (long)origFile.numBlocks(), (long)5L);
    }

    private int getTotalBlocks(INodeFile[] files) throws StorageException, TransactionContextException {
        int nBlocks = 0;
        for (INodeFile file : files) {
            nBlocks += file.numBlocks();
        }
        return nBlocks;
    }

    private INodeFile[] createINodeFiles(int nCount, String fileNamePrefix) throws IOException {
        if (nCount <= 0) {
            return new INodeFile[1];
        }
        this.replication = (short)3;
        this.preferredBlockSize = 0x8000000L;
        INodeFile[] iNodes = new INodeFile[nCount];
        for (int i = 0; i < nCount; ++i) {
            PermissionStatus perms = new PermissionStatus(this.userName, null, FsPermission.getDefault());
            iNodes[i] = new INodeFile(IDsGeneratorFactory.getInstance().getUniqueINodeID(), perms, null, this.replication, 0L, 0L, this.preferredBlockSize, 0);
            iNodes[i].setLocalNameNoPersistance(fileNamePrefix + Integer.toString(i));
            BlockInfo newblock = new BlockInfo();
            newblock.setBlockId((long)blkid++);
            newblock.setINodeId(iNodes[i].getId());
            iNodes[i].addBlock(newblock);
        }
        return iNodes;
    }

    @Test
    public void testValueOf() throws IOException {
        String path = "/testValueOf";
        PermissionStatus perm = new PermissionStatus(this.userName, null, FsPermission.getDefault());
        int replication = 3;
        INodeFile from = null;
        try {
            INodeFile.valueOf(from, (String)"/testValueOf");
            Assert.fail();
        }
        catch (FileNotFoundException fnfe) {
            Assert.assertTrue((boolean)fnfe.getMessage().contains("File does not exist"));
        }
        try {
            INodeDirectory.valueOf(from, (Object)"/testValueOf");
            Assert.fail();
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Directory does not exist"));
        }
        from = new INodeFile(0, perm, null, 3, 0L, 0L, this.preferredBlockSize, 0);
        INodeFile f = INodeFile.valueOf((INode)from, (String)"/testValueOf");
        Assert.assertTrue((f == from ? 1 : 0) != 0);
        try {
            INodeDirectory.valueOf((INode)from, (Object)"/testValueOf");
            Assert.fail();
        }
        catch (PathIsNotDirectoryException pathIsNotDirectoryException) {
            // empty catch block
        }
        from = new INodeFile(0, perm, BlockInfo.EMPTY_ARRAY, 3, 0L, 0L, 0L, 0);
        f = INodeFile.valueOf((INode)from, (String)"/testValueOf");
        Assert.assertTrue((f == from ? 1 : 0) != 0);
        try {
            INodeDirectory.valueOf((INode)from, (Object)"/testValueOf");
            Assert.fail();
        }
        catch (PathIsNotDirectoryException pathIsNotDirectoryException) {
            // empty catch block
        }
        from = new INodeDirectory(0, perm, 0L);
        try {
            INodeFile.valueOf((INode)from, (String)"/testValueOf");
            Assert.fail();
        }
        catch (FileNotFoundException fnfe) {
            Assert.assertTrue((boolean)fnfe.getMessage().contains("Path is not a file"));
        }
        INodeDirectory d = INodeDirectory.valueOf((INode)from, (Object)"/testValueOf");
        Assert.assertTrue((d == from ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInodeId() throws IOException, Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.blocksize", 512);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            long expectedLastInodeId = IDsGeneratorFactory.getInstance().getUniqueINodeID();
            Assert.assertEquals((long)this.getRootDir(cluster).getId(), (long)1L);
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/test1");
            Assert.assertTrue((boolean)fs.mkdirs(path));
            Assert.assertEquals((long)(expectedLastInodeId += 2L), (long)IDsGeneratorFactory.getInstance().getUniqueINodeID());
            NamenodeProtocols nnrpc = cluster.getNameNodeRpc();
            DFSTestUtil.createFile((FileSystem)fs, new Path("/test1/file"), 1024L, (short)1, 0L);
            Assert.assertEquals((long)(expectedLastInodeId += 2L), (long)IDsGeneratorFactory.getInstance().getUniqueINodeID());
            HdfsFileStatus fileStatus = nnrpc.getFileInfo("/test1/file");
            Assert.assertEquals((long)(expectedLastInodeId - 1L), (long)fileStatus.getFileId());
            Path renamedPath = new Path("/test2");
            Assert.assertTrue((boolean)fs.rename(path, renamedPath));
            Assert.assertEquals((long)(++expectedLastInodeId), (long)IDsGeneratorFactory.getInstance().getUniqueINodeID());
            Assert.assertTrue((boolean)fs.delete(renamedPath, true));
            String file1 = "/test1/file1";
            String file2 = "/test1/file2";
            DFSTestUtil.createFile((FileSystem)fs, new Path(file1), 512L, (short)1, 0L);
            DFSTestUtil.createFile((FileSystem)fs, new Path(file2), 512L, (short)1, 0L);
            Assert.assertEquals((long)(expectedLastInodeId += 4L), (long)IDsGeneratorFactory.getInstance().getUniqueINodeID());
            nnrpc.concat(file2, new String[]{file1});
            Assert.assertEquals((long)(++expectedLastInodeId), (long)IDsGeneratorFactory.getInstance().getUniqueINodeID());
            Assert.assertTrue((boolean)fs.delete(new Path("/test1"), true));
            cluster.restartNameNode(new String[0]);
            cluster.waitActive();
            Assert.assertEquals((long)(++expectedLastInodeId), (long)IDsGeneratorFactory.getInstance().getUniqueINodeID());
            DFSTestUtil.createFile((FileSystem)fs, new Path("/test2/file2"), 1024L, (short)1, 0L);
            Assert.assertEquals((long)(expectedLastInodeId += 3L), (long)IDsGeneratorFactory.getInstance().getUniqueINodeID());
            FSDataOutputStream outStream = fs.create(new Path("/test3/file"));
            Assert.assertTrue((outStream != null ? 1 : 0) != 0);
            Assert.assertEquals((long)(expectedLastInodeId += 3L), (long)IDsGeneratorFactory.getInstance().getUniqueINodeID());
            cluster.restartNameNode(new String[0]);
            cluster.waitActive();
            Assert.assertEquals((long)(++expectedLastInodeId), (long)IDsGeneratorFactory.getInstance().getUniqueINodeID());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public INodeDirectory getRootDir(final MiniDFSCluster cluster) throws Exception {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, new String[]{"/"}).setNameNodeID(cluster.getNameNode().getId()).setActiveNameNodes((Collection)cluster.getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockLock());
            }

            public Object performTask() throws StorageException, IOException {
                return cluster.getNameNode().getNamesystem().getFSDirectory().getRootDir();
            }
        };
        return (INodeDirectory)handler.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteToRenamedFile() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("/test1");
        Assert.assertTrue((boolean)fs.mkdirs(path));
        int size = conf.getInt("dfs.bytes-per-checksum", 512);
        byte[] data = new byte[size];
        Path filePath = new Path("/test1/file");
        FSDataOutputStream fos = fs.create(filePath);
        Path renamedPath = new Path("/test2");
        fs.rename(path, renamedPath);
        fs.create(filePath, (short)1);
        try {
            fos.write(data, 0, data.length);
            fos.hflush();
            Assert.fail((String)"Write should fail after rename");
        }
        catch (Exception exception) {
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private Path getInodePath(long inodeId, String remainingPath) {
        StringBuilder b = new StringBuilder();
        b.append("/").append(".reserved").append("/").append(".inodes").append("/").append(inodeId).append("/").append(remainingPath);
        Path p = new Path(b.toString());
        LOG.info((Object)("Inode path is " + p));
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInodeIdBasedPaths() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.blocksize", 512);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            NamenodeProtocols nnRpc = cluster.getNameNodeRpc();
            Path baseDir = this.getInodePath(1L, "testInodeIdBasedPaths");
            Path baseDirRegPath = new Path("/testInodeIdBasedPaths");
            fs.mkdirs(baseDir);
            fs.exists(baseDir);
            long baseDirFileId = nnRpc.getFileInfo(baseDir.toString()).getFileId();
            Path testFileInodePath = this.getInodePath(baseDirFileId, "test1");
            Path testFileRegularPath = new Path(baseDir, "test1");
            int testFileBlockSize = 1024;
            FileSystemTestHelper.createFile((FileSystem)fs, (Path)testFileInodePath, (int)1, (int)1024);
            Assert.assertTrue((boolean)fs.exists(testFileInodePath));
            FsPermission perm = new FsPermission(438);
            fs.setPermission(testFileInodePath, perm);
            FileStatus fileStatus = fs.getFileStatus(testFileInodePath);
            Assert.assertEquals((Object)perm, (Object)fileStatus.getPermission());
            fs.setOwner(testFileInodePath, fileStatus.getOwner(), fileStatus.getGroup());
            fs.setTimes(testFileInodePath, 0L, 0L);
            fileStatus = fs.getFileStatus(testFileInodePath);
            Assert.assertEquals((long)0L, (long)fileStatus.getModificationTime());
            Assert.assertEquals((long)0L, (long)fileStatus.getAccessTime());
            fs.setReplication(testFileInodePath, (short)3);
            fileStatus = fs.getFileStatus(testFileInodePath);
            Assert.assertEquals((long)3L, (long)fileStatus.getReplication());
            fs.setReplication(testFileInodePath, (short)1);
            Assert.assertEquals((long)1024L, (long)nnRpc.getPreferredBlockSize(testFileInodePath.toString()));
            String invalidTarget = new Path(baseDir, "invalidTarget").toString();
            String link = new Path(baseDir, "link").toString();
            this.testInvalidSymlinkTarget(nnRpc, invalidTarget, link);
            String validTarget = "/validtarget";
            this.testValidSymlinkTarget(nnRpc, validTarget, link);
            fs.append(testFileInodePath);
            fs.recoverLease(testFileInodePath);
            LocatedBlocks l1 = nnRpc.getBlockLocations(testFileInodePath.toString(), 0L, Long.MAX_VALUE);
            LocatedBlocks l2 = nnRpc.getBlockLocations(testFileRegularPath.toString(), 0L, Long.MAX_VALUE);
            TestINodeFile.checkEquals(l1, l2);
            Path renameDst = this.getInodePath(baseDirFileId, "test2");
            fileStatus = fs.getFileStatus(testFileInodePath);
            fs.rename(testFileInodePath, renameDst);
            fs.rename(renameDst, testFileInodePath);
            Assert.assertEquals((Object)fileStatus, (Object)fs.getFileStatus(testFileInodePath));
            fs.rename(testFileInodePath, renameDst, new Options.Rename[]{Options.Rename.OVERWRITE});
            fs.rename(renameDst, testFileInodePath, new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertEquals((Object)fileStatus, (Object)fs.getFileStatus(testFileInodePath));
            Assert.assertEquals((Object)fs.getContentSummary(testFileRegularPath).toString(), (Object)fs.getContentSummary(testFileInodePath).toString());
            TestINodeFile.checkEquals((RemoteIterator<LocatedFileStatus>)fs.listFiles(baseDirRegPath, false), (RemoteIterator<LocatedFileStatus>)fs.listFiles(baseDir, false));
            fs.delete(testFileInodePath, true);
            Assert.assertFalse((boolean)fs.exists(testFileInodePath));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void testInvalidSymlinkTarget(NamenodeProtocols nnRpc, String invalidTarget, String link) throws IOException {
        try {
            FsPermission perm = FsPermission.createImmutable((short)493);
            nnRpc.createSymlink(invalidTarget, link, perm, false);
            Assert.fail((String)("Symbolic link creation of target " + invalidTarget + " should fail"));
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
    }

    private void testValidSymlinkTarget(NamenodeProtocols nnRpc, String target, String link) throws IOException {
        FsPermission perm = FsPermission.createImmutable((short)493);
        nnRpc.createSymlink(target, link, perm, false);
        Assert.assertEquals((Object)target, (Object)nnRpc.getLinkTarget(link));
    }

    private static void checkEquals(LocatedBlocks l1, LocatedBlocks l2) {
        List list1 = l1.getLocatedBlocks();
        List list2 = l2.getLocatedBlocks();
        Assert.assertEquals((long)list1.size(), (long)list2.size());
        for (int i = 0; i < list1.size(); ++i) {
            LocatedBlock b1 = (LocatedBlock)list1.get(i);
            LocatedBlock b2 = (LocatedBlock)list2.get(i);
            Assert.assertEquals((Object)b1.getBlock(), (Object)b2.getBlock());
            Assert.assertEquals((long)b1.getBlockSize(), (long)b2.getBlockSize());
        }
    }

    private static void checkEquals(RemoteIterator<LocatedFileStatus> i1, RemoteIterator<LocatedFileStatus> i2) throws IOException {
        while (i1.hasNext()) {
            Assert.assertTrue((boolean)i2.hasNext());
            LocatedFileStatus l1 = (LocatedFileStatus)i1.next();
            LocatedFileStatus l2 = (LocatedFileStatus)i2.next();
            Assert.assertEquals((long)l1.getAccessTime(), (long)l2.getAccessTime());
            Assert.assertEquals((long)l1.getBlockSize(), (long)l2.getBlockSize());
            Assert.assertEquals((Object)l1.getGroup(), (Object)l2.getGroup());
            Assert.assertEquals((long)l1.getLen(), (long)l2.getLen());
            Assert.assertEquals((long)l1.getModificationTime(), (long)l2.getModificationTime());
            Assert.assertEquals((Object)l1.getOwner(), (Object)l2.getOwner());
            Assert.assertEquals((Object)l1.getPermission(), (Object)l2.getPermission());
            Assert.assertEquals((long)l1.getReplication(), (long)l2.getReplication());
        }
        Assert.assertFalse((boolean)i2.hasNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testReservedFileNames() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            this.ensureReservedFileNamesCannotBeCreated((FileSystem)fs, "/.reserved", false);
            this.ensureReservedFileNamesCannotBeCreated((FileSystem)fs, "/.reserved", false);
            Path reservedPath = new Path("/.reserved");
            FSDirectory.CHECK_RESERVED_FILE_NAMES = false;
            fs.mkdirs(reservedPath);
            Assert.assertTrue((boolean)fs.isDirectory(reservedPath));
            this.ensureReservedFileNamesCannotBeLoaded(cluster);
            FSDirectory.CHECK_RESERVED_FILE_NAMES = false;
            this.ensureClusterRestartSucceeds(cluster);
            fs.delete(reservedPath, true);
            DFSTestUtil.createFile((FileSystem)fs, reservedPath, 10L, (short)1, 0L);
            Assert.assertTrue((!fs.isDirectory(reservedPath) ? 1 : 0) != 0);
            this.ensureReservedFileNamesCannotBeLoaded(cluster);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void ensureReservedFileNamesCannotBeCreated(FileSystem fs, String name, boolean isDir) {
        Path reservedPath = new Path(name);
        try {
            if (isDir) {
                fs.mkdirs(reservedPath);
            } else {
                DFSTestUtil.createFile(fs, reservedPath, 10L, (short)1, 0L);
            }
            Assert.fail((String)((isDir ? "mkdir" : "create file") + " should be disallowed"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ensureReservedFileNamesCannotBeLoaded(MiniDFSCluster cluster) throws IOException {
        FSDirectory.CHECK_RESERVED_FILE_NAMES = true;
        this.ensureClusterRestartFails(cluster);
        FSDirectory.CHECK_RESERVED_FILE_NAMES = false;
        this.ensureClusterRestartSucceeds(cluster);
        FSDirectory.CHECK_RESERVED_FILE_NAMES = true;
        this.ensureClusterRestartFails(cluster);
    }

    private void ensureClusterRestartFails(MiniDFSCluster cluster) throws IOException {
        try {
            cluster.restartNameNode(new String[0]);
            Assert.fail((String)"Cluster should not have successfully started");
        }
        catch (Exception expected) {
            LOG.info((Object)("Expected exception thrown " + expected));
        }
        Assert.assertFalse((boolean)cluster.isClusterUp());
    }

    private void ensureClusterRestartSucceeds(MiniDFSCluster cluster) throws IOException {
        cluster.restartNameNode(new String[0]);
        cluster.waitActive();
        Assert.assertTrue((boolean)cluster.isClusterUp());
    }

    private INode createTreeOfInodes(String path) throws IOException, Exception {
        byte[][] components = INode.getPathComponents((String)path);
        FsPermission perm = FsPermission.createImmutable((short)493);
        PermissionStatus permstatus = PermissionStatus.createImmutable((String)"", (String)"", (FsPermission)perm);
        DFSTestUtil.createRootFolder(permstatus);
        int id = 0;
        String prevPath = "";
        String dirPath = "";
        INodeDirectory prev = new INodeDirectory(++id, prevPath, permstatus);
        INodeDirectory dir = null;
        for (byte[] component : components) {
            if (component.length == 0) continue;
            prevPath = dirPath + "/";
            dirPath = prevPath + DFSUtil.bytes2String((byte[])component);
            System.out.println("Adding component " + DFSUtil.bytes2String((byte[])component));
            prev = dir = this.addChild(prevPath, dirPath, ++id, component, permstatus, prev.getId());
        }
        return dir;
    }

    private INodeDirectory addChild(final String prevPath, final String dirPath, final int id, final byte[] component, final PermissionStatus permstatus, final int prevId) throws Exception {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN, new String[]{prevPath, dirPath}).setNameNodeID(TestINodeFile.getMockNamesystem().getNameNode().getId()).setActiveNameNodes((Collection)TestINodeFile.getMockNamesystem().getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
            }

            public Object performTask() throws StorageException, IOException {
                INodeDirectory dir = new INodeDirectory(id, component, permstatus, 0L);
                INodeDirectory prev = (INodeDirectory)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{prevId});
                prev.addChild((INode)dir, false);
                return dir;
            }
        };
        return (INodeDirectory)handler.handle();
    }

    private static FSNamesystem getMockNamesystem() {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.createFsOwnerPermissions((FsPermission)Matchers.anyObject())).thenReturn((Object)new PermissionStatus("root", "wheel", FsPermission.getDefault()));
        NameNode nn = (NameNode)Mockito.mock(NameNode.class);
        Mockito.when((Object)nn.getActiveNameNodes()).thenReturn((Object)new SortedActiveNodeListPBImpl(Collections.EMPTY_LIST));
        Mockito.when((Object)fsn.getNameNode()).thenReturn((Object)nn);
        return fsn;
    }

    private static void checkEquals(byte[][] expected, byte[][] actual) {
        Assert.assertEquals((long)expected.length, (long)actual.length);
        int i = 0;
        for (byte[] e : expected) {
            Assert.assertTrue((boolean)Arrays.equals(e, actual[i++]));
        }
    }

    @Test
    public void testGetPathFromInode() throws IOException, Exception {
        String path = "/a/b/c";
        INode inode = this.createTreeOfInodes(path);
        byte[][] expected = INode.getPathComponents((String)path);
        byte[][] actual = FSDirectory.getPathComponents((INode)inode);
        TestINodeFile.checkEquals(expected, actual);
    }

    @Test
    public void testInodePath() throws FileNotFoundException, IOException, Exception {
        String path = "/a/b/c";
        INode inode = this.createTreeOfInodes(path);
        FSDirectory fsd = (FSDirectory)Mockito.mock(FSDirectory.class);
        ((FSDirectory)Mockito.doReturn((Object)inode.getFullPathName()).when((Object)fsd)).getFullPathName(Mockito.anyInt(), Mockito.anyString());
        Assert.assertEquals((Object)"/test", (Object)FSDirectory.resolvePath((String)"/test", (byte[][])null, (FSDirectory)fsd));
        byte[][] components = INode.getPathComponents((String)path);
        String resolvedPath = FSDirectory.resolvePath((String)path, (byte[][])components, (FSDirectory)fsd);
        Assert.assertEquals((Object)path, (Object)resolvedPath);
        components = INode.getPathComponents((String)"/.reserved/.inodes/2");
        resolvedPath = FSDirectory.resolvePath((String)path, (byte[][])components, (FSDirectory)fsd);
        Assert.assertEquals((Object)path, (Object)resolvedPath);
        components = INode.getPathComponents((String)"/.reserved/.inodes/2/");
        Assert.assertEquals((Object)path, (Object)resolvedPath);
        components = INode.getPathComponents((String)"/.reserved/.inodes/2/d/e/f");
        resolvedPath = FSDirectory.resolvePath((String)path, (byte[][])components, (FSDirectory)fsd);
        Assert.assertEquals((Object)"/a/b/c/d/e/f", (Object)resolvedPath);
        String testPath = "/.reserved/.inodes";
        components = INode.getPathComponents((String)testPath);
        resolvedPath = FSDirectory.resolvePath((String)testPath, (byte[][])components, (FSDirectory)fsd);
        Assert.assertEquals((Object)testPath, (Object)resolvedPath);
        testPath = "/.reserved/.inodes/1";
        components = INode.getPathComponents((String)testPath);
        resolvedPath = FSDirectory.resolvePath((String)testPath, (byte[][])components, (FSDirectory)fsd);
        Assert.assertEquals((Object)"/", (Object)resolvedPath);
        testPath = "/.invalid/.inodes/1";
        components = INode.getPathComponents((String)testPath);
        resolvedPath = FSDirectory.resolvePath((String)testPath, (byte[][])components, (FSDirectory)fsd);
        Assert.assertEquals((Object)testPath, (Object)resolvedPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInodeReplacement() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            FSDirectory fsdir = cluster.getNamesystem().getFSDirectory();
            Path dir = new Path("/dir");
            hdfs.mkdirs(dir);
            INode dirNode = this.getINode(dir.toString(), fsdir, cluster);
            INode dirNodeFromNode = fsdir.getInode(dirNode.getId());
            Assert.assertEquals((Object)dirNode, (Object)dirNodeFromNode);
            hdfs.setQuota(dir, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
            dirNode = this.getINode(dir.toString(), fsdir, cluster);
            Assert.assertTrue((boolean)(dirNode instanceof INodeDirectory));
            Assert.assertTrue((boolean)((INodeDirectory)dirNode).isWithQuota());
            dirNodeFromNode = fsdir.getInode(dirNode.getId());
            Assert.assertEquals((Object)dirNode, (Object)dirNodeFromNode);
            hdfs.setQuota(dir, -1L, -1L);
            dirNode = this.getINode(dir.toString(), fsdir, cluster);
            Assert.assertTrue((boolean)(dirNode instanceof INodeDirectory));
            dirNodeFromNode = fsdir.getInode(dirNode.getId());
            Assert.assertEquals((Object)dirNode, (Object)dirNodeFromNode);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDotdotInodePath() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        DFSClient client = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            FSDirectory fsdir = cluster.getNamesystem().getFSDirectory();
            Path dir = new Path("/dir");
            hdfs.mkdirs(dir);
            long dirId = this.getINode(dir.toString(), fsdir, cluster).getId();
            long parentId = this.getINode("/", fsdir, cluster).getId();
            String testPath = "/.reserved/.inodes/" + dirId + "/..";
            client = new DFSClient(NameNode.getAddress((Configuration)conf), conf);
            HdfsFileStatus status = client.getFileInfo(testPath);
            Assert.assertTrue((parentId == status.getFileId() ? 1 : 0) != 0);
            testPath = "/.reserved/.inodes/" + parentId + "/..";
            status = client.getFileInfo(testPath);
            Assert.assertTrue((parentId == status.getFileId() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{client});
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{client});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocationLimitInListingOps() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ls.limit", 9);
        MiniDFSCluster cluster = null;
        try {
            int i;
            DirectoryListing dl;
            int j;
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            ArrayList<String> source = new ArrayList<String>();
            hdfs.mkdirs(new Path("/tmp1"));
            hdfs.mkdirs(new Path("/tmp2"));
            source.add("f1");
            source.add("f2");
            int numEntries = source.size();
            for (int j2 = 0; j2 < numEntries; ++j2) {
                DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp1/" + (String)source.get(j2)), 4096, 2972L, 1024L, (short)3, 0L);
            }
            byte[] start = HdfsFileStatus.EMPTY_NAME;
            for (j = 0; j < numEntries; ++j) {
                dl = cluster.getNameNodeRpc().getListing("/tmp1", start, true);
                Assert.assertTrue((dl.getPartialListing().length == 1 ? 1 : 0) != 0);
                for (i = 0; i < dl.getPartialListing().length; ++i) {
                    source.remove(dl.getPartialListing()[i].getLocalName());
                }
                start = dl.getLastName();
            }
            Assert.assertTrue((source.size() == 0 ? 1 : 0) != 0);
            source.add("f1");
            source.add("f2");
            source.add("f3");
            source.add("f4");
            source.add("f5");
            source.add("f6");
            numEntries = source.size();
            for (j = 0; j < numEntries; ++j) {
                DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp2/" + (String)source.get(j)), 4096, 2972L, 1024L, (short)1, 0L);
            }
            start = HdfsFileStatus.EMPTY_NAME;
            for (j = 0; j < numEntries / 3; ++j) {
                dl = cluster.getNameNodeRpc().getListing("/tmp2", start, true);
                Assert.assertTrue((dl.getPartialListing().length == 3 ? 1 : 0) != 0);
                for (i = 0; i < dl.getPartialListing().length; ++i) {
                    source.remove(dl.getPartialListing()[i].getLocalName());
                }
                start = dl.getLastName();
            }
            Assert.assertTrue((source.size() == 0 ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilesInGetListingOps() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            FSDirectory fsdir = cluster.getNamesystem().getFSDirectory();
            hdfs.mkdirs(new Path("/tmp"));
            DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp/f1"), 0L, (short)1, 0L);
            DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp/f2"), 0L, (short)1, 0L);
            DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp/f3"), 0L, (short)1, 0L);
            DirectoryListing dl = cluster.getNameNodeRpc().getListing("/tmp", HdfsFileStatus.EMPTY_NAME, false);
            Assert.assertTrue((dl.getPartialListing().length == 3 ? 1 : 0) != 0);
            String f2 = new String("f2");
            dl = cluster.getNameNodeRpc().getListing("/tmp", f2.getBytes(), false);
            Assert.assertTrue((dl.getPartialListing().length == 1 ? 1 : 0) != 0);
            INode f2INode = this.getINode("/tmp/f2", fsdir, cluster);
            String f2InodePath = "/.reserved/.inodes/" + f2INode.getId();
            dl = cluster.getNameNodeRpc().getListing("/tmp", f2InodePath.getBytes(), false);
            Assert.assertTrue((dl.getPartialListing().length == 1 ? 1 : 0) != 0);
            hdfs.delete(new Path("/tmp/f2"), false);
            try {
                dl = cluster.getNameNodeRpc().getListing("/tmp", f2InodePath.getBytes(), false);
                Assert.fail((String)"Didn't get exception for the deleted startAfter token.");
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)(e instanceof DirectoryListingStartAfterNotFoundException));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public INode getINode(final String src, final FSDirectory fsdir, final MiniDFSCluster cluster) throws IOException {
        HopsTransactionalRequestHandler getInodeHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_INODE){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, new String[]{src}).setNameNodeID(cluster.getNameNode().getId()).setActiveNameNodes((Collection)cluster.getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                return fsdir.getINode(src);
            }
        };
        return (INode)getInodeHandler.handle();
    }

    @Test
    public void testFileUnderConstruction() throws IOException {
        this.replication = (short)3;
        final INodeFile file = new INodeFile(0, perm, null, this.replication, 0L, 0L, this.preferredBlockSize, 0);
        Assert.assertFalse((boolean)file.isUnderConstruction());
        String clientName = "client";
        String clientMachine = "machine";
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.ADD_INODE){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws IOException {
                file.setPartitionId(Integer.valueOf(1));
                DatanodeID dnID = new DatanodeID("127.0.0.1:1337");
                file.toUnderConstruction("client", "machine", dnID);
                return null;
            }
        };
        handler.handle();
        Assert.assertTrue((boolean)file.isUnderConstruction());
        FileUnderConstructionFeature uc = file.getFileUnderConstructionFeature();
        Assert.assertEquals((Object)"client", (Object)uc.getClientName());
        Assert.assertEquals((Object)"machine", (Object)uc.getClientMachine());
        Assert.assertNotNull((Object)uc.getClientNode());
        handler = new HopsTransactionalRequestHandler(HDFSOperationType.ADD_INODE){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws IOException {
                file.toCompleteFile(Time.now());
                return null;
            }
        };
        handler.handle();
        Assert.assertFalse((boolean)file.isUnderConstruction());
    }
}

