/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.TestSubtreeLock;
import org.junit.Test;

public class TestSubtreeConflicts
extends TestCase {
    static boolean fail = false;
    static String failMessage = "";

    @Test
    public void testWithOutHierarchialLock() throws IOException, InterruptedException {
        fail = false;
        failMessage = "";
        this.subtreeLocking1(false);
        int count = TestSubtreeLock.countAllSubTreeLocks();
        if (count != 2) {
            TestSubtreeConflicts.fail((String)("Expecting 2 STO locks without hierarchical locking mechanism. Found " + count));
        }
    }

    @Test
    public void testHierarchialLock() throws IOException, InterruptedException {
        fail = false;
        failMessage = "";
        this.subtreeLocking1(true);
        int count = TestSubtreeLock.countAllSubTreeLocks();
        if (count != 1) {
            TestSubtreeConflicts.fail((String)("Expecting 1 STO locks without hierarchical locking mechanism. Found " + count));
        }
        if (!fail) {
            TestSubtreeConflicts.fail((String)"Expecting one STO lock operation to fail. But it did not fail");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtreeLocking1(boolean hierarchicalLocking) throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setBoolean("dfs.namenode.subtree.hierarchical.locking", hierarchicalLocking);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            final FSNamesystem namesystem = cluster.getNamesystem();
            dfs.mkdir(new Path("/A"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/B"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/C"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/B/D"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/B/E"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/C/F"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/C/G"), FsPermission.getDefault());
            namesystem.setTestingSTO(true);
            Thread t1 = new Thread(){

                @Override
                public void run() {
                    try {
                        namesystem.setDelayBeforeSTOFlag(800L);
                        namesystem.setDelayAfterBuildingTree(2000L);
                        INodeIdentifier iNodeIdentifier = namesystem.lockSubtree("/A/C", SubTreeOperation.Type.NA);
                    }
                    catch (Exception e) {
                        fail = true;
                        failMessage = e.toString();
                    }
                }
            };
            Thread t2 = new Thread(){

                @Override
                public void run() {
                    try {
                        namesystem.setDelayBeforeSTOFlag(100L);
                        namesystem.setDelayAfterBuildingTree(2000L);
                        INodeIdentifier iNodeIdentifier = namesystem.lockSubtree("/A", SubTreeOperation.Type.NA);
                    }
                    catch (Exception e) {
                        fail = true;
                        failMessage = e.toString();
                    }
                }
            };
            t1.start();
            Thread.sleep(100L);
            t2.start();
            t1.join();
            t2.join();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testConcurrentSTOandInodeOps() throws IOException, InterruptedException {
        fail = false;
        failMessage = "";
        this.subtreeLocking2();
        TestSubtreeConflicts.assertFalse((String)failMessage, (boolean)fail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtreeLocking2() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.dir.delete.batch.size", 0);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).build();
            cluster.waitActive();
            final DistributedFileSystem dfs = cluster.getFileSystem();
            final FSNamesystem namesystem = cluster.getNamesystem();
            dfs.mkdir(new Path("/A"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/B"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/C"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/B/D"), FsPermission.getDefault());
            dfs.mkdir(new Path("/A/B/E"), FsPermission.getDefault());
            TestFileCreation.create(dfs, new Path("/A/C/F"), 1).close();
            namesystem.setTestingSTO(true);
            Thread t1 = new Thread(){

                @Override
                public void run() {
                    try {
                        namesystem.setDelayAfterBuildingTree(5000L);
                        if (!dfs.delete(new Path("/A"))) {
                            fail = true;
                            failMessage = "Deleting /A should not have failed";
                        }
                    }
                    catch (Exception e) {
                        fail = true;
                        failMessage = e.toString();
                    }
                }
            };
            t1.start();
            Thread.sleep(3000L);
            TestSubtreeConflicts.deleteINode("F");
            namesystem.setDelayAfterBuildingTree(0L);
            t1.join();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static void deleteINode(final String inodeName) throws IOException {
        LightWeightRequestHandler subTreeLockChecker = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                ida.deleteInode(inodeName);
                LOG.debug((Object)("Testing STO Deleted inode " + inodeName));
                return null;
            }
        };
        subTreeLockChecker.handle();
    }
}

