/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.TestUtil;
import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.OngoingSubTreeOpsDataAccess;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.server.namenode.AbstractFileTree;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.junit.Assert;
import org.junit.Test;

public class TestSubtreeLock
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubtreeLocking() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).build();
            cluster.waitActive();
            Path path0 = new Path("/folder0");
            Path path1 = new Path(path0.toUri().getPath(), "folder1");
            Path path2 = new Path(path1.toUri().getPath(), "folder2");
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdir(path0, FsPermission.getDefault());
            dfs.mkdir(path1, FsPermission.getDefault());
            dfs.mkdir(path2, FsPermission.getDefault());
            FSNamesystem namesystem = cluster.getNamesystem();
            namesystem.lockSubtree(path1.toUri().getPath(), SubTreeOperation.Type.NA);
            boolean exception = false;
            try {
                namesystem.lockSubtree(path1.toUri().getPath(), SubTreeOperation.Type.NA);
            }
            catch (RetriableException e) {
                exception = true;
            }
            TestSubtreeLock.assertTrue((String)"Succeeded to acquire lock on previously locked node", (boolean)exception);
            exception = false;
            try {
                namesystem.lockSubtree(path2.toUri().getPath(), SubTreeOperation.Type.NA);
            }
            catch (RetriableException e) {
                exception = true;
            }
            TestSubtreeLock.assertTrue((String)"Succeeded to acquire lock on previously locked subtree", (boolean)exception);
            namesystem.unlockSubtree(path1.toUri().getPath(), this.getSubTreeRootID(path1.toUri().getPath()));
            namesystem.lockSubtree(path2.toUri().getPath(), SubTreeOperation.Type.NA);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubtreeNestedLocking() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/A/B/C/D/E"), FsPermission.getDefault());
            FSNamesystem namesystem = cluster.getNamesystem();
            namesystem.lockSubtree("/A/B/C/D/E", SubTreeOperation.Type.NA);
            boolean exception = false;
            try {
                namesystem.lockSubtree("/A/B/C", SubTreeOperation.Type.NA);
            }
            catch (RetriableException e) {
                exception = true;
            }
            TestSubtreeLock.assertTrue((String)"Failed. Took a lock while sub tree was locked", (boolean)exception);
            namesystem.unlockSubtree("/A/B/C/D/E", this.getSubTreeRootID("/A/B/C/D/E"));
            TestSubtreeLock.assertFalse((String)"Not all subtree locsk are removed", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileTree() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            Path path0 = new Path("/folder0");
            Path path1 = new Path(path0.toUri().getPath(), "folder1");
            Path path2 = new Path(path1.toUri().getPath(), "folder2");
            Path file0 = new Path(path0.toUri().getPath(), "file0");
            Path file1 = new Path(path1.toUri().getPath(), "file1");
            Path file2 = new Path(path2.toUri().getPath(), "file2");
            Path file3 = new Path(path2.toUri().getPath(), "file3");
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdir(path0, FsPermission.getDefault());
            dfs.mkdir(path1, FsPermission.getDefault());
            dfs.mkdir(path2, FsPermission.getDefault());
            dfs.create(file0).close();
            dfs.create(file1).close();
            dfs.create(file2).close();
            dfs.create(file3).close();
            AbstractFileTree.FileTree fileTree = AbstractFileTree.createFileTreeFromPath((FSNamesystem)cluster.getNamesystem(), (String)path0.toUri().getPath());
            fileTree.buildUp();
            TestSubtreeLock.assertEquals((String)path0.getName(), (String)fileTree.getSubtreeRoot().getName());
            TestSubtreeLock.assertEquals((int)7, (int)fileTree.getAll().size());
            TestSubtreeLock.assertEquals((int)4, (int)fileTree.getHeight());
            TestSubtreeLock.assertEquals((String)file3.toUri().getPath(), (String)fileTree.createAbsolutePath(path0.toUri().getPath(), fileTree.getInodeById(TestUtil.getINodeId(cluster.getNameNode(), file3))));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountingFileTree() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            Path path0 = new Path("/folder0");
            Path path1 = new Path(path0.toUri().getPath(), "folder1");
            Path path2 = new Path(path1.toUri().getPath(), "folder2");
            Path file0 = new Path(path0.toUri().getPath(), "file0");
            Path file1 = new Path(path1.toUri().getPath(), "file1");
            Path file2 = new Path(path2.toUri().getPath(), "file2");
            Path file3 = new Path(path2.toUri().getPath(), "file3");
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdir(path0, FsPermission.getDefault());
            dfs.mkdir(path1, FsPermission.getDefault());
            dfs.mkdir(path2, FsPermission.getDefault());
            dfs.create(file0).close();
            int bytes0 = 123;
            FSDataOutputStream stm = dfs.create(file1);
            TestFileCreation.writeFile(stm, 123);
            stm.close();
            dfs.create(file2).close();
            int bytes1 = 253;
            stm = dfs.create(file3);
            TestFileCreation.writeFile(stm, 253);
            stm.close();
            AbstractFileTree.CountingFileTree fileTree = AbstractFileTree.createCountingFileTreeFromPath((FSNamesystem)cluster.getNamesystem(), (String)path0.toUri().getPath());
            fileTree.buildUp();
            TestSubtreeLock.assertEquals((long)7L, (long)fileTree.getNamespaceCount());
            TestSubtreeLock.assertEquals((long)376L, (long)fileTree.getDiskspaceCount());
            TestSubtreeLock.assertEquals((long)3L, (long)fileTree.getDirectoryCount());
            TestSubtreeLock.assertEquals((long)4L, (long)fileTree.getFileCount());
            TestSubtreeLock.assertEquals((long)fileTree.getDiskspaceCount(), (long)fileTree.getFileSizeSummary());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameNodeFailureLockAcquisition() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).format(true).numDataNodes(1).build();
            cluster.waitActive();
            Path path0 = new Path("/folder0");
            Path path1 = new Path(path0.toUri().getPath(), "folder1");
            Path path2 = new Path(path1.toUri().getPath(), "folder2");
            DistributedFileSystem dfs0 = cluster.getFileSystem(0);
            dfs0.mkdir(path0, FsPermission.getDefault());
            dfs0.mkdir(path1, FsPermission.getDefault());
            dfs0.mkdir(path2, FsPermission.getDefault());
            FSNamesystem namesystem0 = cluster.getNamesystem(0);
            FSNamesystem namesystem1 = cluster.getNamesystem(1);
            namesystem0.lockSubtree(path1.toUri().getPath(), SubTreeOperation.Type.NA);
            boolean exception = false;
            try {
                namesystem1.lockSubtree(path1.toUri().getPath(), SubTreeOperation.Type.NA);
            }
            catch (RetriableException e) {
                exception = true;
            }
            TestSubtreeLock.assertTrue((String)"Succeeded to acquire lock on previously locked node", (boolean)exception);
            cluster.shutdownNameNode(0);
            long delay = conf.getLong("dfs.leader.check.interval", 2000L) * (long)(conf.getInt("dfs.leader.missed.hb", 2) + 1);
            Thread.sleep(delay);
            namesystem1.lockSubtree(path1.toUri().getPath(), SubTreeOperation.Type.NA);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetry() throws IOException {
        MiniDFSCluster cluster = null;
        Thread lockKeeper = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            Path path0 = new Path("/folder0");
            final Path path1 = new Path(path0.toUri().getPath(), "folder1");
            Path path2 = new Path(path1.toUri().getPath(), "folder2");
            final FSNamesystem namesystem = cluster.getNamesystem();
            lockKeeper = new Thread(){

                @Override
                public void run() {
                    super.run();
                    try {
                        Thread.sleep(10000L);
                        namesystem.unlockSubtree(path1.toUri().getPath(), TestSubtreeLock.this.getSubTreeRootID(path1.toUri().getPath()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdir(path0, FsPermission.getDefault());
            dfs.mkdir(path1, FsPermission.getDefault());
            dfs.mkdir(path2, FsPermission.getDefault());
            namesystem.lockSubtree(path1.toUri().getPath(), SubTreeOperation.Type.NA);
            lockKeeper.start();
            TestSubtreeLock.assertTrue((boolean)dfs.delete(path1, true));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            try {
                if (lockKeeper != null) {
                    lockKeeper.join();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Test
    public void testDeleteRoot() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            TestSubtreeLock.assertFalse((boolean)cluster.getFileSystem().delete(new Path("/"), true));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testDeleteNonExisting() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            TestSubtreeLock.assertFalse((boolean)cluster.getFileSystem().delete(new Path("/foo/"), true));
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo"), FsPermission.getDefault()));
            TestFileCreation.createFile((FileSystem)fs, new Path("/foo/bar"), 1).close();
            TestSubtreeLock.assertTrue((boolean)fs.delete(new Path("/foo/bar"), false));
            TestSubtreeLock.assertFalse((boolean)fs.exists(new Path("/foo/bar")));
            TestFileCreation.createFile((FileSystem)fs, new Path("/foo/bar"), 1).close();
            TestSubtreeLock.assertTrue((boolean)fs.delete(new Path("/foo/bar"), true));
            TestSubtreeLock.assertFalse((boolean)fs.exists(new Path("/foo/bar")));
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo/bar"), FsPermission.getDefault()));
            TestFileCreation.createFile((FileSystem)fs, new Path("/foo/bar/foo"), 1).close();
            TestSubtreeLock.assertTrue((boolean)fs.delete(new Path("/foo"), true));
            TestSubtreeLock.assertFalse((boolean)fs.exists(new Path("/foo/bar/foo")));
            TestSubtreeLock.assertFalse((boolean)fs.exists(new Path("/foo/bar/foo")));
            TestSubtreeLock.assertFalse((boolean)fs.exists(new Path("/foo/bar")));
            TestSubtreeLock.assertFalse((boolean)fs.exists(new Path("/foo")));
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete2() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            int i;
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/a"), FsPermission.getDefault()));
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/a/b"), FsPermission.getDefault()));
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/a/c"), FsPermission.getDefault()));
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/a/d"), FsPermission.getDefault()));
            for (i = 0; i < 5; ++i) {
                TestFileCreation.createFile((FileSystem)fs, new Path("/a/b/a_b_file_" + i), 1).close();
            }
            for (i = 0; i < 5; ++i) {
                TestFileCreation.createFile((FileSystem)fs, new Path("/a/b/a_b_file_" + i), 1).close();
            }
            for (i = 0; i < 5; ++i) {
                TestFileCreation.createFile((FileSystem)fs, new Path("/a/c/a_c_file_" + i), 1).close();
            }
            for (i = 0; i < 10; ++i) {
                TestSubtreeLock.assertTrue((boolean)fs.mkdirs(new Path("/a/b/c/a_b_c_dir_" + i)));
            }
            for (i = 0; i < 3; ++i) {
                TestSubtreeLock.assertTrue((boolean)fs.mkdirs(new Path("/a/b/a_b_dir_" + i)));
            }
            for (i = 0; i < 3; ++i) {
                TestFileCreation.createFile((FileSystem)fs, new Path("/a/b/c/b/a_b_c_d_file_" + i), 1).close();
            }
            TestSubtreeLock.assertTrue((boolean)fs.delete(new Path("/a")));
            TestSubtreeLock.assertFalse((boolean)fs.exists(new Path("/a")));
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteUnclosed() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo"), FsPermission.getDefault()));
            TestFileCreation.createFile((FileSystem)fs, new Path("/foo/bar"), 1);
            TestSubtreeLock.assertTrue((boolean)fs.delete(new Path("/foo/bar"), true));
            TestSubtreeLock.assertFalse((boolean)fs.exists(new Path("/foo/bar")));
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteSimple() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo"), FsPermission.getDefault()));
            TestFileCreation.createFile((FileSystem)fs, new Path("/foo/bar"), 1).close();
            TestSubtreeLock.assertTrue((boolean)fs.delete(new Path("/foo"), true));
            TestSubtreeLock.assertFalse((boolean)fs.exists(new Path("/foo")));
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMove() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo"), FsPermission.getDefault()));
            TestFileCreation.createFile((FileSystem)fs, new Path("/foo/bar"), 1).close();
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo1"), FsPermission.getDefault()));
            TestFileCreation.createFile((FileSystem)fs, new Path("/foo1/bar1"), 1).close();
            fs.rename(new Path("/foo1/bar1"), new Path("/foo/bar1"), new Options.Rename[]{Options.Rename.OVERWRITE});
            TestSubtreeLock.assertTrue((boolean)fs.exists(new Path("/foo/bar1")));
            TestSubtreeLock.assertFalse((boolean)fs.exists(new Path("/foo1/bar1")));
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
            try {
                fs.rename(new Path("/foo1/bar"), new Path("/foo/bar1"), new Options.Rename[]{Options.Rename.OVERWRITE});
                TestSubtreeLock.fail();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDepricatedRenameMoveFiles() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestFileCreation.createFile((FileSystem)fs, new Path("/foo/file1.txt"), 1).close();
            TestFileCreation.createFile((FileSystem)fs, new Path("/bar/file1.txt"), 1).close();
            TestSubtreeLock.assertTrue((String)"Rename Failed", (boolean)fs.rename(new Path("/foo/file1.txt"), new Path("/bar/file2.txt")));
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDepricatedRenameDirs() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo1"), FsPermission.getDefault()));
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo2"), FsPermission.getDefault()));
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo1/dir1"), FsPermission.getDefault()));
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo2/dir2"), FsPermission.getDefault()));
            TestSubtreeLock.assertTrue((String)"Rename Failed", (boolean)fs.rename(new Path("/foo1/dir1"), new Path("/foo2/dir2")));
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameDirs() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo1"), FsPermission.getDefault()));
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo2"), FsPermission.getDefault()));
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo1/dir1"), FsPermission.getDefault()));
            TestSubtreeLock.assertTrue((boolean)fs.mkdir(new Path("/foo2/dir2"), FsPermission.getDefault()));
            boolean isException = false;
            Exception exception = null;
            try {
                fs.rename(new Path("/foo1/dir1"), new Path("/foo2/dir2/dir1"), new Options.Rename[]{Options.Rename.NONE});
            }
            catch (Exception e) {
                isException = true;
                exception = e;
            }
            TestSubtreeLock.assertFalse((String)("Rename failed. " + exception), (boolean)isException);
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
            try {
                fs.rename(new Path("/foo1"), new Path("/foo2/dir2"), new Options.Rename[]{Options.Rename.OVERWRITE});
            }
            catch (Exception e) {
                isException = true;
                exception = e;
            }
            TestSubtreeLock.assertTrue((String)("Rename failed. " + exception), (boolean)isException);
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameDirs2() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestSubtreeLock.assertTrue((boolean)fs.mkdirs(new Path("/foo1/foo2"), FsPermission.getDefault()));
            TestSubtreeLock.assertTrue((boolean)fs.mkdirs(new Path("/bar1/bar2"), FsPermission.getDefault()));
            boolean isException = false;
            Exception exception = null;
            try {
                fs.rename(new Path("/foo1/foo2"), new Path("/bar1/bar2/"), new Options.Rename[]{Options.Rename.OVERWRITE});
            }
            catch (Exception e) {
                isException = true;
                exception = e;
            }
            TestSubtreeLock.assertFalse((String)("Rename failed. " + exception), (boolean)isException);
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameMoveFiles() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestFileCreation.createFile((FileSystem)fs, new Path("/foo/file1.txt"), 1).close();
            TestFileCreation.createFile((FileSystem)fs, new Path("/bar/file1.txt"), 1).close();
            boolean isException = false;
            Exception exception = null;
            try {
                fs.rename(new Path("/foo/file1.txt"), new Path("/bar/file2.txt"), new Options.Rename[]{Options.Rename.NONE});
            }
            catch (Exception e) {
                isException = true;
                exception = e;
            }
            TestSubtreeLock.assertFalse((String)("Rename failed. " + exception), (boolean)isException);
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
            try {
                fs.rename(new Path("/bar/file1.txt"), new Path("/bar/file2.txt"), new Options.Rename[]{Options.Rename.OVERWRITE});
            }
            catch (Exception e) {
                isException = true;
                exception = e;
            }
            TestSubtreeLock.assertFalse((String)("Rename failed. " + exception), (boolean)isException);
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static boolean subTreeLocksExists() throws IOException {
        return TestSubtreeLock.countAllSubTreeLocks() > 0;
    }

    public static int countAllSubTreeLocks() throws IOException {
        LightWeightRequestHandler subTreeLockChecker = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST_SUBTREE_LOCK){

            public Object performTask() throws StorageException, IOException {
                int count = 0;
                INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                OngoingSubTreeOpsDataAccess oda = (OngoingSubTreeOpsDataAccess)HdfsStorageFactory.getDataAccess(OngoingSubTreeOpsDataAccess.class);
                List inodes = ida.allINodes();
                List ops = (List)oda.allOps();
                if (ops != null && !ops.isEmpty()) {
                    for (SubTreeOperation op : ops) {
                        LOG.debug((Object)("On going sub tree operations table contains: \" " + op.getPath() + "\" NameNode id: " + op.getNameNodeId() + " OpType: " + op.getOpType() + " count " + ++count));
                    }
                }
                if (inodes != null && !inodes.isEmpty()) {
                    for (INode inode : inodes) {
                        if (!inode.isSTOLocked()) continue;
                        LOG.error((Object)("INode lock flag is set. Name " + inode.getLocalName() + " id: " + inode.getId() + " pid: " + inode.getParentId() + " locked by " + inode.getSTOLockOwner()));
                    }
                }
                return count;
            }
        };
        return (Integer)subTreeLockChecker.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubtreeSetPermssion() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/A/B/C/D/E"), FsPermission.getDefault());
            boolean isException = false;
            Exception exception = null;
            try {
                dfs.setPermission(new Path("/A/B/C"), new FsPermission(511));
            }
            catch (Exception e) {
                isException = true;
                exception = e;
            }
            TestSubtreeLock.assertFalse((String)("Set Permission failed. " + exception), (boolean)isException);
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
            try {
                dfs.setPermission(new Path("/A"), new FsPermission(511));
            }
            catch (Exception e) {
                isException = true;
                exception = e;
            }
            TestSubtreeLock.assertFalse((String)("Set Permission failed. " + exception), (boolean)isException);
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubtreeSetOwner() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/A/B/C/D/E"), FsPermission.getDefault());
            boolean isException = false;
            Exception exception = null;
            try {
                dfs.setOwner(new Path("/A/B/C"), "test", "test");
            }
            catch (Exception e) {
                isException = true;
                exception = e;
            }
            TestSubtreeLock.assertFalse((String)("Set Permission failed. " + exception), (boolean)isException);
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
            isException = false;
            exception = null;
            try {
                dfs.setOwner(new Path("/A/z"), "test", "test");
            }
            catch (Exception e) {
                isException = true;
                exception = e;
            }
            TestSubtreeLock.assertTrue((String)("Set Permission was supposed to fail. " + exception), (boolean)isException);
            TestSubtreeLock.assertFalse((String)"Not All subtree locks were removed after operation ", (boolean)TestSubtreeLock.subTreeLocksExists());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubtreeIgnoreLockRequest() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/foo"));
            TestFileCreation.createFile((FileSystem)dfs, new Path("/foo/file1.txt"), 1).close();
            boolean isException = false;
            Object exception = null;
            INodeIdentifier inode = cluster.getNamesystem().lockSubtree("/foo/file1.txt", SubTreeOperation.Type.NA);
            if (inode != null) {
                TestSubtreeLock.fail((String)"nothing should have been locked");
            }
            if ((inode = cluster.getNamesystem().lockSubtree("/", SubTreeOperation.Type.NA)) != null) {
                TestSubtreeLock.fail((String)"root should not have been locked");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubtreeMove() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/Projects/test"));
            dfs.setMetaEnabled(new Path("/Projects"), true);
            try {
                dfs.listStatus(new Path("/Projects"));
                dfs.rename(new Path("/Projects/test"), new Path("/Projects/test1"));
                dfs.rename(new Path("/Projects/test1"), new Path("/Projects/test"));
            }
            catch (Exception e) {
                TestSubtreeLock.fail((String)"No exception should have been thrown ");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecursiveDeleteAsaProxyUser() throws Exception {
        int u;
        HdfsConfiguration conf = new HdfsConfiguration();
        int NumberOfFileSystems = 100;
        String UserPrefix = "testUser";
        String userName = UserGroupInformation.getCurrentUser().getShortUserName();
        conf.set(String.format("hadoop.proxyuser.%s.hosts", userName), "*");
        conf.set(String.format("hadoop.proxyuser.%s.users", userName), "*");
        conf.set(String.format("hadoop.proxyuser.%s.groups", userName), "*");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).build();
        cluster.waitActive();
        DistributedFileSystem superFS = cluster.getFileSystem();
        ArrayList<UserGroupInformation> ugis = new ArrayList<UserGroupInformation>();
        ArrayList<FileSystem> fss = new ArrayList<FileSystem>();
        for (u = 0; u < 100; ++u) {
            UserGroupInformation ugi = UserGroupInformation.createProxyUserForTesting((String)("testUser" + u), (UserGroupInformation)UserGroupInformation.getLoginUser(), (String[])new String[]{"testUser" + u});
            FileSystem fs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return cluster.getFileSystem();
                }
            });
            ugis.add(ugi);
            fss.add(fs);
        }
        try {
            FileSystem fs;
            superFS.mkdirs(new Path("/root"));
            superFS.setPermission(new Path("/root"), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
            for (u = 0; u < fss.size(); ++u) {
                fs = (FileSystem)fss.get(u);
                Path root = new Path(String.format("/root/a%d", u));
                fs.mkdirs(root);
                fs.setOwner(root, "testUser" + u, "testUser" + u);
                fs.mkdirs(new Path(root, "b" + u));
                fs.mkdirs(new Path(root, "c" + u));
                fs.create(new Path(root, "b" + u + "/f")).close();
                fs.create(new Path(root, "c" + u + "/f")).close();
            }
            for (u = 0; u < fss.size(); ++u) {
                fs = (FileSystem)fss.get(u);
                Assert.assertTrue((boolean)fs.delete(new Path(String.format("/root/a%d", u)), true));
                FileSystem.closeAllForUGI((UserGroupInformation)((UserGroupInformation)ugis.get(u)));
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    private int getSubTreeRootID(String path) throws IOException {
        LinkedList nodes = new LinkedList();
        INodeUtil.resolvePathWithNoTransaction((String)path, (boolean)false, nodes);
        return ((INode)nodes.getLast()).getId();
    }
}

