/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.namenode.TestHAFileCreation;
import org.apache.hadoop.io.IOUtils;

class Writer
extends Thread {
    FileSystem fs;
    final Path threadDir;
    final Path filepath;
    boolean running;
    FSDataOutputStream outputStream;
    long datawrote;
    boolean waitFileisClosed;
    long fileCloseWaitTile;

    Writer(FileSystem fs, String fileName, boolean writeInSameDir, Path baseDir, boolean waitFileisClosed, long fileCloseWaitTile) {
        block2: {
            super(Writer.class.getSimpleName() + ":" + fileName + "_dir/" + fileName);
            this.running = true;
            this.outputStream = null;
            this.datawrote = 0L;
            this.waitFileisClosed = true;
            this.fileCloseWaitTile = -1L;
            this.waitFileisClosed = waitFileisClosed;
            this.fileCloseWaitTile = fileCloseWaitTile;
            this.fs = fs;
            this.threadDir = writeInSameDir ? baseDir : new Path(baseDir, fileName + "_dir");
            this.filepath = new Path(this.threadDir, fileName);
            try {
                fs.mkdirs(this.threadDir);
                this.outputStream = this.fs.create(this.filepath);
            }
            catch (Exception ex) {
                TestHAFileCreation.LOG.info((Object)(this.getName() + " unable to create file [" + this.filepath + "]" + ex), (Throwable)ex);
                if (this.outputStream == null) break block2;
                IOUtils.closeStream((Closeable)this.outputStream);
                this.outputStream = null;
            }
        }
    }

    @Override
    public void run() {
        int i = 0;
        if (this.outputStream != null) {
            try {
                while (this.running) {
                    this.outputStream.writeInt(i);
                    this.outputStream.flush();
                    ++this.datawrote;
                    Writer.sleep(10L);
                    ++i;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                Assert.fail((String)(this.getName() + " dies: e=" + e));
                TestHAFileCreation.LOG.info((Object)(this.getName() + " dies: e=" + e), (Throwable)e);
            }
            finally {
                IOUtils.closeStream((Closeable)this.outputStream);
                if (!this.checkFileClosed()) {
                    TestHAFileCreation.LOG.debug((Object)("File " + this.filepath + " close FAILED"));
                    Assert.fail((String)("File " + this.filepath + " close FAILED"));
                }
                TestHAFileCreation.LOG.debug((Object)("File " + this.filepath + " closed"));
            }
        } else {
            TestHAFileCreation.LOG.info((Object)(this.getName() + " outstream was null for file  [" + this.filepath + "]"));
        }
    }

    private boolean checkFileClosed() {
        if (!this.waitFileisClosed) {
            return true;
        }
        int timePassed = 50;
        do {
            try {
                long len = this.fs.getFileStatus(this.filepath).getLen();
                if (len == this.datawrote * 4L) {
                    return true;
                }
            }
            catch (IOException ex) {
                return false;
            }
        } while ((long)(timePassed *= 2) <= this.fileCloseWaitTile);
        return false;
    }

    public Path getFilePath() {
        return this.filepath;
    }

    static void startWriters(Writer[] writers) {
        for (Writer writer : writers) {
            writer.start();
        }
    }

    static void stopWriters(Writer[] writers) throws InterruptedException {
        for (Writer writer1 : writers) {
            if (writer1 == null) continue;
            writer1.running = false;
            writer1.interrupt();
        }
        for (Writer writer : writers) {
            if (writer == null) continue;
            writer.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void verifyFile(Writer[] writers, FileSystem fs) throws IOException {
        TestHAFileCreation.LOG.info((Object)"Verify the file");
        for (Writer writer : writers) {
            FSDataInputStream in;
            block8: {
                TestHAFileCreation.LOG.info((Object)(writer.filepath + ": length=" + fs.getFileStatus(writer.filepath).getLen()));
                in = null;
                try {
                    in = fs.open(writer.filepath);
                    boolean eof = false;
                    int j = 0;
                    int x = 0;
                    long dataRead = 0L;
                    while (!eof) {
                        try {
                            x = in.readInt();
                            ++dataRead;
                            Assert.assertEquals((int)j, (int)x);
                            ++j;
                        }
                        catch (EOFException ex) {
                            eof = true;
                        }
                    }
                    if (writer.datawrote == dataRead) break block8;
                    TestHAFileCreation.LOG.debug((Object)("File length read lenght is not consistant. wrote " + writer.datawrote + " data read " + dataRead + " file path " + writer.filepath));
                    Assert.fail((String)("File length read lenght is not consistant. wrote " + writer.datawrote + " data read " + dataRead + " file path " + writer.filepath));
                }
                catch (Exception ex) {
                    try {
                        Assert.fail((String)("File varification failed for file: " + writer.filepath + " exception " + ex));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeStream(in);
                        throw throwable;
                    }
                    IOUtils.closeStream((Closeable)in);
                    continue;
                }
            }
            IOUtils.closeStream((Closeable)in);
        }
    }

    public static void waitReplication(FileSystem fs, Writer[] writers, short replicationFactor, long timeout) throws IOException, TimeoutException {
        for (Writer writer : writers) {
            try {
                long expectedRetyTime = 20000L;
                DFSTestUtil.waitReplicationWithTimeout(fs, writer.getFilePath(), replicationFactor, timeout += expectedRetyTime);
            }
            catch (ConnectException ex) {
                TestHAFileCreation.LOG.warn((Object)"Received Connect Exception (expected due to failure of NN)");
                ex.printStackTrace();
            }
        }
    }
}

