/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.tools.FakeRenewer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestDelegationTokenFetcher {
    private DistributedFileSystem dfs;
    private Configuration conf;
    private URI uri;
    private static final String SERVICE_VALUE = "localhost:2005";
    private static String tokenFile = "file.dta";

    @Before
    public void init() throws URISyntaxException, IOException {
        this.dfs = (DistributedFileSystem)Mockito.mock(DistributedFileSystem.class);
        this.conf = new Configuration();
        this.uri = new URI("hdfs://localhost:2005");
        FileSystemTestHelper.addFileSystemForTesting((URI)this.uri, (Configuration)this.conf, (FileSystem)this.dfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void expectedTokenIsRetrievedFromDFS() throws Exception {
        byte[] ident = new DelegationTokenIdentifier(new Text("owner"), new Text("renewer"), new Text("realuser")).getBytes();
        byte[] pw = new byte[]{42};
        final Text service = new Text(this.uri.toString());
        final Token t = new Token(ident, pw, FakeRenewer.KIND, service);
        Mockito.when((Object)this.dfs.addDelegationTokens((String)Matchers.eq((Object)null), (Credentials)Matchers.any(Credentials.class))).thenAnswer((Answer)new Answer<Token<?>[]>(){

            public Token<?>[] answer(InvocationOnMock invocation) {
                Credentials creds = (Credentials)invocation.getArguments()[1];
                creds.addToken(service, t);
                return new Token[]{t};
            }
        });
        Mockito.when((Object)this.dfs.getUri()).thenReturn((Object)this.uri);
        FakeRenewer.reset();
        LocalFileSystem fileSys = FileSystem.getLocal((Configuration)this.conf);
        try {
            DelegationTokenFetcher.main((String[])new String[]{"-fs", this.uri.toString(), tokenFile});
            Path p = new Path(fileSys.getWorkingDirectory(), tokenFile);
            Credentials creds = Credentials.readTokenStorageFile((Path)p, (Configuration)this.conf);
            Iterator itr = creds.getAllTokens().iterator();
            Assert.assertTrue((boolean)itr.hasNext());
            Assert.assertEquals((Object)t, itr.next());
            Assert.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
            DelegationTokenFetcher.main((String[])new String[]{"--print", tokenFile});
            DelegationTokenFetcher.main((String[])new String[]{"--renew", tokenFile});
            Assert.assertEquals((Object)t, FakeRenewer.lastRenewed);
            FakeRenewer.reset();
            DelegationTokenFetcher.main((String[])new String[]{"--cancel", tokenFile});
            Assert.assertEquals((Object)t, FakeRenewer.lastCanceled);
        }
        finally {
            fileSys.delete(new Path(tokenFile), true);
        }
    }
}

