/*
 * Decompiled with CFR 0.152.
 */
package io.hops.common;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import java.util.NoSuchElementException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class INodeResolver {
    private final byte[][] components;
    private final boolean resolveLink;
    private final boolean transactional;
    private INode currentInode;
    private int count = 0;
    private int depth = 0;

    public INodeResolver(byte[][] components, INode baseINode, boolean resolveLink, boolean transactional) {
        this.components = components;
        this.currentInode = baseINode;
        this.resolveLink = resolveLink;
        this.transactional = transactional;
    }

    public INodeResolver(byte[][] components, INode baseINode, boolean resolveLink, boolean transactional, int initialCount) {
        this(components, baseINode, resolveLink, transactional);
        this.count = initialCount;
        this.depth = 0 + initialCount;
    }

    public boolean hasNext() {
        if (this.currentInode == null) {
            return false;
        }
        if (this.currentInode.isFile()) {
            return false;
        }
        return this.count + 1 < this.components.length;
    }

    public INode next() throws UnresolvedPathException, StorageException, TransactionContextException {
        boolean lastComp;
        boolean bl = lastComp = this.count == this.components.length - 1;
        if (this.currentInode.isSymlink() && (!lastComp || lastComp && this.resolveLink)) {
            String symPath = INodeUtil.constructPath(this.components, 0, this.components.length);
            String preceding = INodeUtil.constructPath(this.components, 0, this.count);
            String remainder = INodeUtil.constructPath(this.components, this.count + 1, this.components.length);
            String link = DFSUtil.bytes2String(this.components[this.count]);
            String target = ((INodeSymlink)this.currentInode).getSymlinkString();
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("UnresolvedPathException  path: " + symPath + " preceding: " + preceding + " count: " + this.count + " link: " + link + " target: " + target + " remainder: " + remainder));
            }
            throw new UnresolvedPathException(symPath, preceding, remainder, target);
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("Trying to read more components than available");
        }
        ++this.depth;
        ++this.count;
        int partitionId = INode.calculatePartitionId(this.currentInode.getId(), DFSUtil.bytes2String(this.components[this.count]), (short)this.depth);
        this.currentInode = INodeUtil.getNode(this.components[this.count], this.currentInode.getId(), partitionId, this.transactional);
        return this.currentInode;
    }

    public int getCount() {
        return this.count;
    }
}

