/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata;

import com.google.common.annotations.VisibleForTesting;
import io.hops.DalDriver;
import io.hops.DalStorageFactory;
import io.hops.StorageConnector;
import io.hops.common.IDsMonitor;
import io.hops.exception.StorageException;
import io.hops.exception.StorageInitializtionException;
import io.hops.log.NDCWrapper;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.adaptor.BlockInfoDALAdaptor;
import io.hops.metadata.adaptor.CacheDirectiveDALAdaptor;
import io.hops.metadata.adaptor.CachePoolDALAdaptor;
import io.hops.metadata.adaptor.INodeAttributeDALAdaptor;
import io.hops.metadata.adaptor.INodeDALAdaptor;
import io.hops.metadata.adaptor.LeaseDALAdaptor;
import io.hops.metadata.adaptor.PendingBlockInfoDALAdaptor;
import io.hops.metadata.adaptor.ReplicaUnderConstructionDALAdaptor;
import io.hops.metadata.common.EntityDataAccess;
import io.hops.metadata.common.entity.ArrayVariable;
import io.hops.metadata.common.entity.ByteArrayVariable;
import io.hops.metadata.common.entity.IntVariable;
import io.hops.metadata.common.entity.LongVariable;
import io.hops.metadata.common.entity.StringVariable;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.election.dal.HdfsLeDescriptorDataAccess;
import io.hops.metadata.election.dal.LeDescriptorDataAccess;
import io.hops.metadata.election.entity.LeDescriptor;
import io.hops.metadata.hdfs.dal.AceDataAccess;
import io.hops.metadata.hdfs.dal.BlockChecksumDataAccess;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.dal.CacheDirectiveDataAccess;
import io.hops.metadata.hdfs.dal.CachePoolDataAccess;
import io.hops.metadata.hdfs.dal.CachedBlockDataAccess;
import io.hops.metadata.hdfs.dal.CorruptReplicaDataAccess;
import io.hops.metadata.hdfs.dal.EncodingStatusDataAccess;
import io.hops.metadata.hdfs.dal.ExcessReplicaDataAccess;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.dal.HashBucketDataAccess;
import io.hops.metadata.hdfs.dal.INodeAttributesDataAccess;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.InvalidateBlockDataAccess;
import io.hops.metadata.hdfs.dal.LeaseDataAccess;
import io.hops.metadata.hdfs.dal.LeasePathDataAccess;
import io.hops.metadata.hdfs.dal.MetadataLogDataAccess;
import io.hops.metadata.hdfs.dal.OngoingSubTreeOpsDataAccess;
import io.hops.metadata.hdfs.dal.PendingBlockDataAccess;
import io.hops.metadata.hdfs.dal.QuotaUpdateDataAccess;
import io.hops.metadata.hdfs.dal.ReplicaDataAccess;
import io.hops.metadata.hdfs.dal.ReplicaUnderConstructionDataAccess;
import io.hops.metadata.hdfs.dal.RetryCacheEntryDataAccess;
import io.hops.metadata.hdfs.dal.UnderReplicatedBlockDataAccess;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.metadata.hdfs.dal.UserGroupDataAccess;
import io.hops.metadata.hdfs.dal.VariableDataAccess;
import io.hops.metadata.hdfs.entity.Ace;
import io.hops.metadata.hdfs.entity.BlockChecksum;
import io.hops.metadata.hdfs.entity.BlockInfo;
import io.hops.metadata.hdfs.entity.CacheDirective;
import io.hops.metadata.hdfs.entity.CachePool;
import io.hops.metadata.hdfs.entity.CachedBlock;
import io.hops.metadata.hdfs.entity.CorruptReplica;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.metadata.hdfs.entity.ExcessReplica;
import io.hops.metadata.hdfs.entity.HashBucket;
import io.hops.metadata.hdfs.entity.INode;
import io.hops.metadata.hdfs.entity.INodeAttributes;
import io.hops.metadata.hdfs.entity.InvalidatedBlock;
import io.hops.metadata.hdfs.entity.Lease;
import io.hops.metadata.hdfs.entity.LeasePath;
import io.hops.metadata.hdfs.entity.MetadataLogEntry;
import io.hops.metadata.hdfs.entity.PendingBlockInfo;
import io.hops.metadata.hdfs.entity.QuotaUpdate;
import io.hops.metadata.hdfs.entity.Replica;
import io.hops.metadata.hdfs.entity.ReplicaUnderConstruction;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.metadata.hdfs.entity.UnderReplicatedBlock;
import io.hops.resolvingcache.Cache;
import io.hops.security.Users;
import io.hops.security.UsersGroups;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.AcesContext;
import io.hops.transaction.context.BlockChecksumContext;
import io.hops.transaction.context.BlockInfoContext;
import io.hops.transaction.context.CacheDirectiveContext;
import io.hops.transaction.context.CachePoolContext;
import io.hops.transaction.context.CachedBlockContext;
import io.hops.transaction.context.ContextInitializer;
import io.hops.transaction.context.CorruptReplicaContext;
import io.hops.transaction.context.EncodingStatusContext;
import io.hops.transaction.context.EntityContext;
import io.hops.transaction.context.ExcessReplicaContext;
import io.hops.transaction.context.HashBucketContext;
import io.hops.transaction.context.INodeAttributesContext;
import io.hops.transaction.context.INodeContext;
import io.hops.transaction.context.InvalidatedBlockContext;
import io.hops.transaction.context.LeSnapshot;
import io.hops.transaction.context.LeaseContext;
import io.hops.transaction.context.LeasePathContext;
import io.hops.transaction.context.MetadataLogContext;
import io.hops.transaction.context.PendingBlockContext;
import io.hops.transaction.context.QuotaUpdateContext;
import io.hops.transaction.context.ReplicaContext;
import io.hops.transaction.context.ReplicaUnderConstructionContext;
import io.hops.transaction.context.RetryCacheEntryContext;
import io.hops.transaction.context.SubTreeOperationsContext;
import io.hops.transaction.context.TransactionsStats;
import io.hops.transaction.context.UnderReplicatedBlockContext;
import io.hops.transaction.context.VariableContext;
import io.hops.transaction.lock.LockFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;

public class HdfsStorageFactory {
    private static boolean isDALInitialized = false;
    private static DalStorageFactory dStorageFactory;
    private static Map<Class, EntityDataAccess> dataAccessAdaptors;

    public static StorageConnector getConnector() {
        return dStorageFactory.getConnector();
    }

    @VisibleForTesting
    public static void resetDALInitialized() {
        isDALInitialized = false;
    }

    public static void setConfiguration(Configuration conf) throws IOException {
        IDsMonitor.getInstance().setConfiguration(conf);
        Cache.getInstance(conf);
        LockFactory.getInstance().setConfiguration(conf);
        NDCWrapper.enableNDC((boolean)conf.getBoolean("dfs.ndc.enable", false));
        TransactionsStats.getInstance().setConfiguration(conf.getBoolean("dfs.transaction.stats.enabled", false), conf.get("dfs.transaction.stats.dir", "/tmp/hopsstats"), conf.getInt("dfs.transaction.stats.writerround", 120), conf.getBoolean("dfs.transaction.stats.detailed.enabled", false));
        if (!isDALInitialized) {
            HdfsVariables.registerDefaultValues(conf);
            HdfsStorageFactory.addToClassPath(conf.get("dfs.storage.driver.jarFile", ""));
            dStorageFactory = DalDriver.load((String)conf.get("dfs.storage.driver.class", "io.hops.metadata.ndb.NdbStorageFactory"));
            dStorageFactory.setConfiguration(HdfsStorageFactory.getMetadataClusterConfiguration(conf));
            HdfsStorageFactory.initDataAccessWrappers();
            EntityManager.addContextInitializer((ContextInitializer)HdfsStorageFactory.getContextInitializer());
            if (conf.getBoolean("hops.groups.updater.round", true)) {
                UsersGroups.init((UserDataAccess)((UserDataAccess)HdfsStorageFactory.getDataAccess(UserDataAccess.class)), (UserGroupDataAccess)((UserGroupDataAccess)HdfsStorageFactory.getDataAccess(UserGroupDataAccess.class)), (GroupDataAccess)((GroupDataAccess)HdfsStorageFactory.getDataAccess(GroupDataAccess.class)), (int)conf.getInt("hops.groups.updater.round", 120), (int)conf.getInt("hops.users.lru.threshold", 10000));
            }
            isDALInitialized = true;
        }
    }

    public static Properties getMetadataClusterConfiguration(Configuration conf) throws IOException {
        String configFile = conf.get("dfs.storage.driver.configfile", "ndb-config.properties");
        Properties clusterConf = new Properties();
        InputStream inStream = StorageConnector.class.getClassLoader().getResourceAsStream(configFile);
        clusterConf.load(inStream);
        if (inStream == null) {
            throw new FileNotFoundException("Unable to load database configuration file");
        }
        return clusterConf;
    }

    private static void addToClassPath(String s) throws StorageInitializtionException {
        try {
            File f = new File(s);
            URL u = f.toURI().toURL();
            URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> urlClass = URLClassLoader.class;
            Method method = urlClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, u);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
    }

    private static void initDataAccessWrappers() {
        dataAccessAdaptors.clear();
        dataAccessAdaptors.put(BlockInfoDataAccess.class, (EntityDataAccess)new BlockInfoDALAdaptor((BlockInfoDataAccess<BlockInfo>)((BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class))));
        dataAccessAdaptors.put(ReplicaUnderConstructionDataAccess.class, (EntityDataAccess)new ReplicaUnderConstructionDALAdaptor((ReplicaUnderConstructionDataAccess<ReplicaUnderConstruction>)((ReplicaUnderConstructionDataAccess)HdfsStorageFactory.getDataAccess(ReplicaUnderConstructionDataAccess.class))));
        dataAccessAdaptors.put(LeaseDataAccess.class, (EntityDataAccess)new LeaseDALAdaptor((LeaseDataAccess<Lease>)((LeaseDataAccess)HdfsStorageFactory.getDataAccess(LeaseDataAccess.class))));
        dataAccessAdaptors.put(PendingBlockDataAccess.class, (EntityDataAccess)new PendingBlockInfoDALAdaptor((PendingBlockDataAccess<PendingBlockInfo>)((PendingBlockDataAccess)HdfsStorageFactory.getDataAccess(PendingBlockDataAccess.class))));
        dataAccessAdaptors.put(INodeDataAccess.class, (EntityDataAccess)new INodeDALAdaptor((INodeDataAccess<INode>)((INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class))));
        dataAccessAdaptors.put(INodeAttributesDataAccess.class, (EntityDataAccess)new INodeAttributeDALAdaptor((INodeAttributesDataAccess<INodeAttributes>)((INodeAttributesDataAccess)HdfsStorageFactory.getDataAccess(INodeAttributesDataAccess.class))));
        dataAccessAdaptors.put(CacheDirectiveDataAccess.class, (EntityDataAccess)new CacheDirectiveDALAdaptor((CacheDirectiveDataAccess<CacheDirective>)((CacheDirectiveDataAccess)HdfsStorageFactory.getDataAccess(CacheDirectiveDataAccess.class))));
        dataAccessAdaptors.put(CachePoolDataAccess.class, (EntityDataAccess)new CachePoolDALAdaptor((CachePoolDataAccess<CachePool>)((CachePoolDataAccess)HdfsStorageFactory.getDataAccess(CachePoolDataAccess.class))));
    }

    private static ContextInitializer getContextInitializer() {
        return new ContextInitializer(){

            public Map<Class, EntityContext> createEntityContexts() {
                HashMap<Class, EntityContext> entityContexts = new HashMap<Class, EntityContext>();
                BlockInfoContext bic = new BlockInfoContext((BlockInfoDataAccess<org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo>)((BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class)));
                entityContexts.put(org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo.class, (EntityContext)bic);
                entityContexts.put(BlockInfoUnderConstruction.class, (EntityContext)bic);
                entityContexts.put(org.apache.hadoop.hdfs.server.blockmanagement.ReplicaUnderConstruction.class, (EntityContext)new ReplicaUnderConstructionContext((ReplicaUnderConstructionDataAccess)HdfsStorageFactory.getDataAccess(ReplicaUnderConstructionDataAccess.class)));
                entityContexts.put(Replica.class, (EntityContext)new ReplicaContext((ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class)));
                entityContexts.put(ExcessReplica.class, (EntityContext)new ExcessReplicaContext((ExcessReplicaDataAccess)HdfsStorageFactory.getDataAccess(ExcessReplicaDataAccess.class)));
                entityContexts.put(InvalidatedBlock.class, (EntityContext)new InvalidatedBlockContext((InvalidateBlockDataAccess)HdfsStorageFactory.getDataAccess(InvalidateBlockDataAccess.class)));
                entityContexts.put(org.apache.hadoop.hdfs.server.namenode.Lease.class, (EntityContext)new LeaseContext((LeaseDataAccess<org.apache.hadoop.hdfs.server.namenode.Lease>)((LeaseDataAccess)HdfsStorageFactory.getDataAccess(LeaseDataAccess.class))));
                entityContexts.put(LeasePath.class, (EntityContext)new LeasePathContext((LeasePathDataAccess<LeasePath>)((LeasePathDataAccess)HdfsStorageFactory.getDataAccess(LeasePathDataAccess.class))));
                entityContexts.put(org.apache.hadoop.hdfs.server.blockmanagement.PendingBlockInfo.class, (EntityContext)new PendingBlockContext((PendingBlockDataAccess)HdfsStorageFactory.getDataAccess(PendingBlockDataAccess.class)));
                INodeContext inodeContext = new INodeContext((INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class));
                entityContexts.put(org.apache.hadoop.hdfs.server.namenode.INode.class, (EntityContext)inodeContext);
                entityContexts.put(INodeDirectory.class, (EntityContext)inodeContext);
                entityContexts.put(INodeFile.class, (EntityContext)inodeContext);
                entityContexts.put(INodeSymlink.class, (EntityContext)inodeContext);
                entityContexts.put(CorruptReplica.class, (EntityContext)new CorruptReplicaContext((CorruptReplicaDataAccess)HdfsStorageFactory.getDataAccess(CorruptReplicaDataAccess.class)));
                entityContexts.put(UnderReplicatedBlock.class, (EntityContext)new UnderReplicatedBlockContext((UnderReplicatedBlockDataAccess)HdfsStorageFactory.getDataAccess(UnderReplicatedBlockDataAccess.class)));
                VariableContext variableContext = new VariableContext((VariableDataAccess)HdfsStorageFactory.getDataAccess(VariableDataAccess.class));
                entityContexts.put(Variable.class, (EntityContext)variableContext);
                entityContexts.put(IntVariable.class, (EntityContext)variableContext);
                entityContexts.put(LongVariable.class, (EntityContext)variableContext);
                entityContexts.put(ByteArrayVariable.class, (EntityContext)variableContext);
                entityContexts.put(StringVariable.class, (EntityContext)variableContext);
                entityContexts.put(ArrayVariable.class, (EntityContext)variableContext);
                entityContexts.put(LeDescriptor.HdfsLeDescriptor.class, (EntityContext)new LeSnapshot.HdfsLESnapshot((LeDescriptorDataAccess)HdfsStorageFactory.getDataAccess(HdfsLeDescriptorDataAccess.class)));
                entityContexts.put(org.apache.hadoop.hdfs.server.namenode.INodeAttributes.class, (EntityContext)new INodeAttributesContext((INodeAttributesDataAccess<org.apache.hadoop.hdfs.server.namenode.INodeAttributes>)((INodeAttributesDataAccess)HdfsStorageFactory.getDataAccess(INodeAttributesDataAccess.class))));
                entityContexts.put(EncodingStatus.class, (EntityContext)new EncodingStatusContext((EncodingStatusDataAccess<EncodingStatus>)((EncodingStatusDataAccess)HdfsStorageFactory.getDataAccess(EncodingStatusDataAccess.class))));
                entityContexts.put(BlockChecksum.class, (EntityContext)new BlockChecksumContext((BlockChecksumDataAccess<BlockChecksum>)((BlockChecksumDataAccess)HdfsStorageFactory.getDataAccess(BlockChecksumDataAccess.class))));
                entityContexts.put(QuotaUpdate.class, (EntityContext)new QuotaUpdateContext((QuotaUpdateDataAccess<QuotaUpdate>)((QuotaUpdateDataAccess)HdfsStorageFactory.getDataAccess(QuotaUpdateDataAccess.class))));
                entityContexts.put(MetadataLogEntry.class, (EntityContext)new MetadataLogContext((MetadataLogDataAccess)HdfsStorageFactory.getDataAccess(MetadataLogDataAccess.class)));
                entityContexts.put(SubTreeOperation.class, (EntityContext)new SubTreeOperationsContext((OngoingSubTreeOpsDataAccess<SubTreeOperation>)((OngoingSubTreeOpsDataAccess)HdfsStorageFactory.getDataAccess(OngoingSubTreeOpsDataAccess.class))));
                entityContexts.put(HashBucket.class, (EntityContext)new HashBucketContext((HashBucketDataAccess)HdfsStorageFactory.getDataAccess(HashBucketDataAccess.class)));
                entityContexts.put(Ace.class, (EntityContext)new AcesContext((AceDataAccess<Ace>)((AceDataAccess)HdfsStorageFactory.getDataAccess(AceDataAccess.class))));
                entityContexts.put(RetryCacheEntry.class, (EntityContext)new RetryCacheEntryContext((RetryCacheEntryDataAccess)HdfsStorageFactory.getDataAccess(RetryCacheEntryDataAccess.class)));
                entityContexts.put(org.apache.hadoop.hdfs.protocol.CacheDirective.class, (EntityContext)new CacheDirectiveContext((CacheDirectiveDataAccess)HdfsStorageFactory.getDataAccess(CacheDirectiveDataAccess.class)));
                entityContexts.put(org.apache.hadoop.hdfs.server.namenode.CachePool.class, (EntityContext)new CachePoolContext((CachePoolDataAccess)HdfsStorageFactory.getDataAccess(CachePoolDataAccess.class)));
                entityContexts.put(CachedBlock.class, (EntityContext)new CachedBlockContext((CachedBlockDataAccess)HdfsStorageFactory.getDataAccess(CachedBlockDataAccess.class)));
                return entityContexts;
            }

            public StorageConnector getConnector() {
                return dStorageFactory.getConnector();
            }
        };
    }

    public static EntityDataAccess getDataAccess(Class type) {
        if (dataAccessAdaptors.containsKey(type)) {
            return dataAccessAdaptors.get(type);
        }
        return dStorageFactory.getDataAccess(type);
    }

    public static boolean formatStorage() throws StorageException {
        Cache.getInstance().flush();
        Users.flushCache();
        return dStorageFactory.getConnector().formatStorage();
    }

    public static boolean formatHdfsStorage() throws StorageException {
        Cache.getInstance().flush();
        return dStorageFactory.getConnector().formatHDFSStorage();
    }

    public static boolean formatHdfsStorageNonTransactional() throws StorageException {
        Cache.getInstance().flush();
        return dStorageFactory.getConnector().formatHDFSStorageNonTransactional();
    }

    public static boolean formatAllStorageNonTransactional() throws StorageException {
        Cache.getInstance().flush();
        return dStorageFactory.getConnector().formatAllStorageNonTransactional();
    }

    public static boolean formatStorage(Class<? extends EntityDataAccess> ... das) throws StorageException {
        Cache.getInstance().flush();
        return dStorageFactory.getConnector().formatStorage((Class[])das);
    }

    static {
        dataAccessAdaptors = new HashMap<Class, EntityDataAccess>();
    }
}

