/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.adaptor;

import io.hops.exception.StorageException;
import io.hops.metadata.DalAdaptor;
import io.hops.metadata.hdfs.dal.INodeAttributesDataAccess;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.Quota;

public class INodeAttributeDALAdaptor
extends DalAdaptor<INodeAttributes, io.hops.metadata.hdfs.entity.INodeAttributes>
implements INodeAttributesDataAccess<INodeAttributes> {
    private INodeAttributesDataAccess<io.hops.metadata.hdfs.entity.INodeAttributes> dataAccess;

    public INodeAttributeDALAdaptor(INodeAttributesDataAccess<io.hops.metadata.hdfs.entity.INodeAttributes> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public INodeAttributes findAttributesByPk(Integer inodeId) throws StorageException {
        return this.convertDALtoHDFS((io.hops.metadata.hdfs.entity.INodeAttributes)this.dataAccess.findAttributesByPk(inodeId));
    }

    public void prepare(Collection<INodeAttributes> modified, Collection<INodeAttributes> removed) throws StorageException {
        this.dataAccess.prepare(this.convertHDFStoDAL(modified), this.convertHDFStoDAL(removed));
    }

    public io.hops.metadata.hdfs.entity.INodeAttributes convertHDFStoDAL(INodeAttributes attribute) throws StorageException {
        if (attribute != null) {
            io.hops.metadata.hdfs.entity.INodeAttributes hia = new io.hops.metadata.hdfs.entity.INodeAttributes(attribute.getInodeId(), Long.valueOf(attribute.getQuotaCounts().get(Quota.NAMESPACE)), attribute.getNsCount(), Long.valueOf(attribute.getQuotaCounts().get(Quota.DISKSPACE)), attribute.getDiskspace());
            return hia;
        }
        return null;
    }

    public INodeAttributes convertDALtoHDFS(io.hops.metadata.hdfs.entity.INodeAttributes hia) throws StorageException {
        if (hia != null) {
            INodeAttributes iNodeAttributes = new INodeAttributes(hia.getInodeId(), hia.getNsQuota(), hia.getNsCount(), hia.getDsQuota(), hia.getDiskspace());
            return iNodeAttributes;
        }
        return null;
    }

    public Collection<INodeAttributes> findAttributesByPkList(List<INodeCandidatePrimaryKey> inodePks) throws StorageException {
        return this.convertDALtoHDFS(this.dataAccess.findAttributesByPkList(inodePks));
    }
}

