/*
 * Decompiled with CFR 0.152.
 */
package io.hops.resolvingcache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import io.hops.resolvingcache.Cache;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.INode;

public class InMemoryCache
extends Cache {
    private ConcurrentLinkedHashMap<String, Integer> cache;
    private int CACHE_MAXIMUM_SIZE;

    @Override
    protected void setConfiguration(Configuration conf) throws IOException {
        this.CACHE_MAXIMUM_SIZE = conf.getInt("dfs.resolvingcache.inmemory.maxsize", 100000);
        super.setConfiguration(conf);
    }

    @Override
    protected void startInternal() throws IOException {
        this.cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)this.CACHE_MAXIMUM_SIZE).build();
    }

    @Override
    protected void stopInternal() {
    }

    @Override
    protected void setInternal(String path, List<INode> inodes) {
        for (INode iNode : inodes) {
            if (iNode == null) continue;
            this.cache.put((Object)iNode.nameParentKey(), (Object)iNode.getId());
        }
    }

    @Override
    protected int[] getInternal(String path) throws IOException {
        int index;
        String[] pathComponents = INode.getPathNames(path);
        int[] inodeIds = new int[pathComponents.length];
        int parentId = 0;
        for (index = 0; index < pathComponents.length; ++index) {
            String cmp = pathComponents[index];
            Integer inodeId = (Integer)this.cache.get((Object)INode.nameParentKey(parentId, cmp));
            if (inodeId == null) break;
            parentId = inodeId;
            inodeIds[index] = inodeId;
        }
        if (index <= 1) {
            return null;
        }
        return Arrays.copyOf(inodeIds, index);
    }

    @Override
    protected void setInternal(INode inode) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void deleteInternal(String path) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void deleteInternal(INode inode) {
        this.cache.remove((Object)inode.nameParentKey());
    }

    @Override
    protected void flushInternal() {
        this.cache.clear();
    }

    @Override
    protected int getRoundTrips(String path) {
        return INode.getPathNames(path).length;
    }

    @Override
    protected int getRoundTrips(List<INode> inodes) {
        return inodes.size();
    }
}

