/*
 * Decompiled with CFR 0.152.
 */
package io.hops.resolvingcache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;

public class MemcachedClientPool {
    private final List<MemcachedClient> clients = new ArrayList<MemcachedClient>();
    private int index = 0;

    public MemcachedClientPool(int poolSize, String server) throws IOException {
        for (int i = 0; i < poolSize; ++i) {
            this.clients.add(new MemcachedClient((ConnectionFactory)new BinaryConnectionFactory(), AddrUtil.getAddresses((String)server.trim())));
        }
    }

    public MemcachedClient poll() {
        MemcachedClient client;
        if (!(client = this.clients.get(this.index++ % this.clients.size())).getAvailableServers().isEmpty()) {
            return client;
        }
        return null;
    }

    public void shutdown() {
        for (MemcachedClient client : this.clients) {
            client.shutdown();
        }
    }
}

