/*
 * Decompiled with CFR 0.152.
 */
package io.hops.resolvingcache;

import io.hops.resolvingcache.Cache;
import io.hops.resolvingcache.Memcache;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.internal.OperationCompletionListener;
import net.spy.memcached.internal.OperationFuture;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hdfs.server.namenode.INode;

public class PathMemcache
extends Memcache {
    @Override
    protected void setInternal(MemcachedClient mc, final String path, List<INode> inodes) {
        if (INode.getPathNames(path).length != inodes.size()) {
            return;
        }
        final String key = this.getKey(path);
        final int[] inodeIds = this.getINodeIds(inodes);
        final long startTime = System.currentTimeMillis();
        mc.set(key, this.keyExpiry, (Object)new CacheEntry(inodeIds)).addListener(new OperationCompletionListener(){

            public void onComplete(OperationFuture<?> f) throws Exception {
                long elapsed = System.currentTimeMillis() - startTime;
                Cache.LOG.debug((Object)("SET for path (" + path + ")  " + key + "=" + Arrays.toString(inodeIds) + " in " + elapsed + " msec"));
            }
        });
    }

    @Override
    protected void setInternal(MemcachedClient mc, INode inode) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int[] getInternal(MemcachedClient mc, String path) throws IOException {
        Object ce = null;
        GetFuture f = mc.asyncGet(this.getKey(path));
        try {
            ce = f.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            f.cancel(true);
        }
        if (ce != null && ce instanceof CacheEntry) {
            return ((CacheEntry)ce).getInodeIds();
        }
        return null;
    }

    @Override
    protected void deleteInternal(MemcachedClient mc, final String path) {
        final String key = this.getKey(path);
        mc.delete(key).addListener(new OperationCompletionListener(){

            public void onComplete(OperationFuture<?> f) throws Exception {
                Cache.LOG.debug((Object)("DELETE for path (" + path + ")  " + key));
            }
        });
    }

    @Override
    protected void deleteInternal(MemcachedClient mc, INode inode) {
        throw new UnsupportedOperationException();
    }

    private String getKey(String path) {
        return this.keyPrefix + DigestUtils.sha256Hex((String)path);
    }

    private int[] getINodeIds(List<INode> inodes) {
        int[] inodeIds = new int[inodes.size()];
        for (int i = 0; i < inodes.size(); ++i) {
            inodeIds[i] = inodes.get(i).getId();
        }
        return inodeIds;
    }

    @Override
    protected int getRoundTrips(String path) {
        return 1;
    }

    @Override
    protected int getRoundTrips(List<INode> inodes) {
        return 1;
    }

    public static class CacheEntry
    implements Serializable {
        private int[] inodeIds;

        public CacheEntry(int[] inodeIds) {
            this.inodeIds = inodeIds;
        }

        public int[] getInodeIds() {
            return this.inodeIds;
        }

        public String toString() {
            return "CacheEntry{inodeIds=" + Arrays.toString(this.inodeIds) + '}';
        }
    }
}

