/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.AceDataAccess;
import io.hops.metadata.hdfs.entity.Ace;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AcesContext
extends BaseEntityContext<Ace.PrimaryKey, Ace> {
    private AceDataAccess<Ace> dataAccess;
    private Map<Integer, List<Ace>> inodeAces = new HashMap<Integer, List<Ace>>();

    public AcesContext(AceDataAccess<Ace> aceDataAccess) {
        this.dataAccess = aceDataAccess;
    }

    public Collection<Ace> findList(FinderType<Ace> finder, Object ... params) throws TransactionContextException, StorageException {
        Ace.Finder aceFinder = (Ace.Finder)finder;
        switch (aceFinder) {
            case ByInodeIdAndIndices: {
                return this.findByPKBatched(aceFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    private Collection<Ace> findByPKBatched(Ace.Finder aceFinder, Object[] params) throws StorageException, StorageCallPreventedException {
        List result;
        int inodeId = (Integer)params[0];
        int[] aceIds = (int[])params[1];
        if (this.inodeAces.containsKey(inodeId)) {
            result = this.inodeAces.get(inodeId);
            this.hit((FinderType)aceFinder, result, new Object[]{"inodeId", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)aceFinder, params);
            result = this.dataAccess.getAcesByPKBatched(inodeId, aceIds);
            this.inodeAces.put(inodeId, result);
            this.gotFromDB(result);
            this.miss((FinderType)aceFinder, result, new Object[]{"inodeId", inodeId});
        }
        return result;
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    Ace.PrimaryKey getKey(Ace ace) {
        return new Ace.PrimaryKey(ace.getInodeId(), ace.getIndex());
    }
}

