/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.BlockChecksumDataAccess;
import io.hops.metadata.hdfs.entity.BlockChecksum;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BlockChecksumContext
extends BaseEntityContext<BlockChecksumDataAccess.KeyTuple, BlockChecksum> {
    private final BlockChecksumDataAccess<BlockChecksum> dataAccess;
    private final Map<Integer, Collection<BlockChecksum>> inodeToBlockChecksums = new HashMap<Integer, Collection<BlockChecksum>>();

    public BlockChecksumContext(BlockChecksumDataAccess<BlockChecksum> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void update(BlockChecksum blockChecksum) throws TransactionContextException {
        super.update((Object)blockChecksum);
    }

    public void remove(BlockChecksum blockChecksum) throws TransactionContextException {
        super.remove((Object)blockChecksum);
    }

    public BlockChecksum find(FinderType<BlockChecksum> finder, Object ... params) throws TransactionContextException, StorageException {
        BlockChecksum.Finder eFinder = (BlockChecksum.Finder)finder;
        switch (eFinder) {
            case ByKeyTuple: {
                return this.findByKeyTuple(eFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<BlockChecksum> findList(FinderType<BlockChecksum> finder, Object ... params) throws TransactionContextException, StorageException {
        BlockChecksum.Finder eFinder = (BlockChecksum.Finder)finder;
        switch (eFinder) {
            case ByInodeId: {
                return this.findByINodeId(eFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        for (BlockChecksum blockChecksum : this.getAdded()) {
            this.dataAccess.add((Object)blockChecksum);
        }
        for (BlockChecksum blockChecksum : this.getModified()) {
            this.dataAccess.update((Object)blockChecksum);
        }
        for (BlockChecksum blockChecksum : this.getRemoved()) {
            this.dataAccess.delete((Object)blockChecksum);
        }
    }

    public void clear() throws TransactionContextException {
        super.clear();
        this.inodeToBlockChecksums.clear();
    }

    BlockChecksumDataAccess.KeyTuple getKey(BlockChecksum blockChecksum) {
        return new BlockChecksumDataAccess.KeyTuple(blockChecksum.getInodeId(), blockChecksum.getBlockIndex());
    }

    private BlockChecksum findByKeyTuple(BlockChecksum.Finder eFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        BlockChecksumDataAccess.KeyTuple key = (BlockChecksumDataAccess.KeyTuple)params[0];
        if (key == null) {
            return null;
        }
        BlockChecksum result = null;
        if (this.contains(key)) {
            result = (BlockChecksum)this.get(key);
            this.hit((FinderType)eFinder, result, new Object[]{"KeyTuple", key});
        } else {
            this.aboutToAccessStorage((FinderType)eFinder, params);
            result = (BlockChecksum)this.dataAccess.find(key.getInodeId(), key.getBlockIndex());
            this.gotFromDB(key, result);
            this.miss((FinderType)eFinder, result, new Object[]{"KeyTuple", key});
        }
        return result;
    }

    private Collection<BlockChecksum> findByINodeId(BlockChecksum.Finder eFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        int inodeId = (Integer)params[0];
        Collection result = null;
        if (this.inodeToBlockChecksums.containsKey(inodeId)) {
            result = this.inodeToBlockChecksums.get(inodeId);
            this.hit((FinderType)eFinder, result, new Object[]{"inodeId", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)eFinder, params);
            result = this.dataAccess.findAll(((Integer)params[0]).intValue());
            this.gotFromDB(result);
            this.inodeToBlockChecksums.put(inodeId, result);
            this.miss((FinderType)eFinder, result, new Object[]{"inodeId", inodeId});
        }
        return result;
    }
}

