/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.lock.BlockLock;
import io.hops.transaction.lock.LastTwoBlocksLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.SqlBatchedBlocksLock;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.INode;

public class BlockInfoContext
extends BaseEntityContext<Long, BlockInfo> {
    private static final int DEFAULT_NUM_BLOCKS_PER_INODE = 10;
    private final Map<Integer, List<BlockInfo>> inodeBlocks = new HashMap<Integer, List<BlockInfo>>();
    private final List<BlockInfo> concatRemovedBlks = new ArrayList<BlockInfo>();
    private final BlockInfoDataAccess<BlockInfo> dataAccess;
    private boolean foundByInode = false;

    public BlockInfoContext(BlockInfoDataAccess<BlockInfo> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void clear() throws TransactionContextException {
        super.clear();
        this.inodeBlocks.clear();
        this.concatRemovedBlks.clear();
    }

    public void update(BlockInfo blockInfo) throws TransactionContextException {
        super.update((Object)blockInfo);
        this.updateInodeBlocks(blockInfo);
        if (this.isLogDebugEnabled()) {
            this.log("updated-blockinfo", new Object[]{"bid", blockInfo.getBlockId(), "inodeId", blockInfo.getInodeId(), "blk index", blockInfo.getBlockIndex()});
        }
    }

    public void remove(BlockInfo blockInfo) throws TransactionContextException {
        super.remove((Object)blockInfo);
        this.removeBlockFromInodeBlocks(blockInfo);
        if (this.isLogDebugEnabled()) {
            this.log("removed-blockinfo", new Object[]{"bid", blockInfo.getBlockId()});
        }
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        if (this.foundByInode && !(tlm.getLock(Lock.Type.Block) instanceof BlockLock) && !(tlm.getLock(Lock.Type.Block) instanceof LastTwoBlocksLock) && !(tlm.getLock(Lock.Type.Block) instanceof SqlBatchedBlocksLock)) {
            throw new TransactionContextException("You can't call find ByINodeId(s) when taking the lock only on one block");
        }
        ArrayList<BlockInfo> removed = new ArrayList<BlockInfo>(this.getRemoved());
        removed.addAll(this.concatRemovedBlks);
        this.dataAccess.prepare(removed, this.getAdded(), this.getModified());
    }

    public BlockInfo find(FinderType<BlockInfo> finder, Object ... params) throws TransactionContextException, StorageException {
        BlockInfo.Finder bFinder = (BlockInfo.Finder)finder;
        switch (bFinder) {
            case ByBlockIdAndINodeId: {
                return this.findById(bFinder, params);
            }
            case ByMaxBlockIndexForINode: {
                return this.findMaxBlk(bFinder, params);
            }
            case ByINodeIdAndIndex: {
                return this.findByInodeIdAndIndex(bFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<BlockInfo> findList(FinderType<BlockInfo> finder, Object ... params) throws TransactionContextException, StorageException {
        BlockInfo.Finder bFinder = (BlockInfo.Finder)finder;
        switch (bFinder) {
            case ByINodeId: {
                this.foundByInode = true;
                return this.findByInodeId(bFinder, params);
            }
            case ByBlockIdsAndINodeIds: {
                return this.findBatch(bFinder, params);
            }
            case ByINodeIds: {
                this.foundByInode = true;
                return this.findByInodeIds(bFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void snapshotMaintenance(TransactionContextMaintenanceCmds cmds, Object ... params) throws TransactionContextException {
        HdfsTransactionContextMaintenanceCmds hopCmds = (HdfsTransactionContextMaintenanceCmds)cmds;
        switch (hopCmds) {
            case INodePKChanged: {
                INode inodeBeforeChange = (INode)params[0];
                INode inodeAfterChange = (INode)params[1];
                break;
            }
            case Concat: {
                INodeCandidatePrimaryKey trg_param = (INodeCandidatePrimaryKey)params[0];
                List srcs_param = (List)params[1];
                List oldBlks = (List)params[2];
                this.deleteBlocksForConcat(trg_param, srcs_param, oldBlks);
                break;
            }
            case EmptyFile: {
                Integer inodeId = (Integer)params[0];
                List<BlockInfo> result = Collections.emptyList();
                this.inodeBlocks.put(inodeId, this.syncBlockInfoInstances(result));
            }
        }
    }

    Long getKey(BlockInfo blockInfo) {
        return blockInfo.getBlockId();
    }

    private List<BlockInfo> findByInodeId(BlockInfo.Finder bFinder, Object[] params) throws TransactionContextException, StorageException {
        List result = null;
        Integer inodeId = (Integer)params[0];
        if (this.inodeBlocks.containsKey(inodeId)) {
            result = this.inodeBlocks.get(inodeId);
            this.hit(bFinder, result, new Object[]{"inodeid", inodeId});
        } else {
            this.aboutToAccessStorage(bFinder, params);
            result = this.dataAccess.findByInodeId(inodeId.intValue());
            this.inodeBlocks.put(inodeId, this.syncBlockInfoInstances(result));
            this.miss(bFinder, result, new Object[]{"inodeid", inodeId});
        }
        return result;
    }

    private List<BlockInfo> findBatch(BlockInfo.Finder bFinder, Object[] params) throws TransactionContextException, StorageException {
        List result = null;
        long[] blockIds = (long[])params[0];
        int[] inodeIds = (int[])params[1];
        this.aboutToAccessStorage(bFinder, params);
        result = this.dataAccess.findByIds(blockIds, inodeIds);
        this.miss(bFinder, result, new Object[]{"BlockIds", Arrays.toString(blockIds), "InodeIds", Arrays.toString(inodeIds)});
        return this.syncBlockInfoInstances((List<BlockInfo>)result, blockIds);
    }

    private List<BlockInfo> findByInodeIds(BlockInfo.Finder bFinder, Object[] params) throws TransactionContextException, StorageException {
        List result = null;
        int[] ids = (int[])params[0];
        this.aboutToAccessStorage(bFinder, params);
        result = this.dataAccess.findByInodeIds(ids);
        for (int id : ids) {
            this.inodeBlocks.put(id, null);
        }
        this.miss(bFinder, result, new Object[]{"InodeIds", Arrays.toString(ids)});
        return this.syncBlockInfoInstances((List<BlockInfo>)result, true);
    }

    private BlockInfo findByInodeIdAndIndex(BlockInfo.Finder bFinder, Object[] params) throws TransactionContextException, StorageException {
        List<BlockInfo> blocks = null;
        BlockInfo result = null;
        Integer inodeId = (Integer)params[0];
        Integer index = (Integer)params[1];
        if (this.inodeBlocks.containsKey(inodeId)) {
            blocks = this.inodeBlocks.get(inodeId);
            for (BlockInfo bi : blocks) {
                if (bi.getBlockIndex() != index.intValue()) continue;
                result = bi;
                break;
            }
        } else {
            throw new TransactionContextException("this function can't be called without owning a lock on the block");
        }
        this.hit(bFinder, result, new Object[]{"inodeid", inodeId});
        return result;
    }

    private BlockInfo findById(BlockInfo.Finder bFinder, Object[] params) throws TransactionContextException, StorageException {
        BlockInfo result = null;
        long blockId = (Long)params[0];
        Integer inodeId = null;
        if (params.length > 1 && params[1] != null) {
            inodeId = (Integer)params[1];
        }
        if (this.contains(blockId)) {
            result = (BlockInfo)this.get(blockId);
            this.hit(bFinder, result, new Object[]{"bid", blockId, "inodeId", inodeId != null ? Integer.toString(inodeId) : "NULL"});
        } else {
            if (inodeId == null) {
                throw new IllegalArgumentException(Thread.currentThread().getId() + " InodeId is not set for block " + blockId);
            }
            this.aboutToAccessStorage(bFinder, params);
            result = (BlockInfo)this.dataAccess.findById(blockId, inodeId.intValue());
            this.gotFromDB(blockId, result);
            this.updateInodeBlocks(result);
            this.miss(bFinder, result, new Object[]{"bid", blockId, "inodeId", inodeId});
        }
        return result;
    }

    private BlockInfo findMaxBlk(BlockInfo.Finder bFinder, Object[] params) {
        final int inodeId = (Integer)params[0];
        Collection notRemovedBlks = Collections2.filter((Collection)this.filterValuesNotOnState(BaseEntityContext.State.REMOVED), (Predicate)new Predicate<BlockInfo>(){

            public boolean apply(BlockInfo input) {
                return input.getInodeId() == inodeId;
            }
        });
        BlockInfo result = Collections.max(notRemovedBlks, BlockInfo.Order.ByBlockIndex);
        this.hit(bFinder, result, new Object[]{"inodeId", inodeId});
        return result;
    }

    private List<BlockInfo> syncBlockInfoInstances(List<BlockInfo> newBlocks, long[] blockIds) {
        List<BlockInfo> result = this.syncBlockInfoInstances(newBlocks);
        for (long blockId : blockIds) {
            if (this.contains(blockId)) continue;
            this.gotFromDB(blockId, null);
        }
        return result;
    }

    private List<BlockInfo> syncBlockInfoInstances(List<BlockInfo> newBlocks) {
        return this.syncBlockInfoInstances(newBlocks, false);
    }

    private List<BlockInfo> syncBlockInfoInstances(List<BlockInfo> newBlocks, boolean syncInodeBlocks) {
        ArrayList<BlockInfo> finalList = new ArrayList<BlockInfo>();
        for (BlockInfo blockInfo : newBlocks) {
            if (this.isRemoved(blockInfo.getBlockId())) continue;
            this.gotFromDB(blockInfo);
            finalList.add(blockInfo);
            if (!syncInodeBlocks) continue;
            List<BlockInfo> blockList = this.inodeBlocks.get(blockInfo.getInodeId());
            if (blockList == null) {
                blockList = new ArrayList<BlockInfo>();
                this.inodeBlocks.put(blockInfo.getInodeId(), blockList);
            }
            blockList.add(blockInfo);
        }
        return finalList;
    }

    private void updateInodeBlocks(BlockInfo newBlock) {
        if (newBlock == null) {
            return;
        }
        List<BlockInfo> blockList = this.inodeBlocks.get(newBlock.getInodeId());
        if (blockList != null) {
            int idx = blockList.indexOf(newBlock);
            if (idx != -1) {
                blockList.set(idx, newBlock);
            } else {
                blockList.add(newBlock);
            }
        } else {
            ArrayList<BlockInfo> list = new ArrayList<BlockInfo>(10);
            list.add(newBlock);
            this.inodeBlocks.put(newBlock.getInodeId(), list);
        }
    }

    private void removeBlockFromInodeBlocks(BlockInfo block) throws TransactionContextException {
        List<BlockInfo> blockList = this.inodeBlocks.get(block.getInodeId());
        if (blockList != null && !blockList.remove(block)) {
            throw new TransactionContextException("Trying to remove a block that does not exist");
        }
    }

    private void checkForSnapshotChange() {
        if (!this.getAdded().isEmpty() || !this.getModified().isEmpty()) {
            throw new IllegalStateException("Renaming a file(s) whose blocks are changed. During rename and move no block blocks should have been changed.");
        }
    }

    private void deleteBlocksForConcat(INodeCandidatePrimaryKey trg_param, List<INodeCandidatePrimaryKey> deleteINodes, List<BlockInfo> oldBlks) throws TransactionContextException {
        if (!this.getRemoved().isEmpty()) {
            throw new IllegalStateException("Concat file(s) whose blocks are changed. During rename and move no block blocks should have been changed.");
        }
        for (BlockInfo bInfo : oldBlks) {
            INodeCandidatePrimaryKey pk = new INodeCandidatePrimaryKey(bInfo.getInodeId());
            if (!deleteINodes.contains(pk)) continue;
            this.concatRemovedBlks.add(bInfo);
            if (!this.isLogDebugEnabled()) continue;
            this.log("snapshot-maintenance-removed-blockinfo", new Object[]{"bid", bInfo.getBlockId(), "inodeId", bInfo.getInodeId()});
        }
    }
}

