/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.CachedBlockDataAccess;
import io.hops.metadata.hdfs.entity.CachedBlock;
import io.hops.transaction.context.BaseReplicaContext;
import io.hops.transaction.context.BlockPK;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.namenode.CachedBlock;

public class CachedBlockContext
extends BaseReplicaContext<BlockPK.CachedBlockPK, CachedBlock> {
    private CachedBlockDataAccess<CachedBlock> dataAccess;
    Map<Long, Map<BlockPK.CachedBlockPK, CachedBlock>> blocksToReplicas = new HashMap<Long, Map<BlockPK.CachedBlockPK, CachedBlock>>();
    Map<Integer, Map<BlockPK.CachedBlockPK, CachedBlock>> inodesToReplicas = new HashMap<Integer, Map<BlockPK.CachedBlockPK, CachedBlock>>();
    Map<String, Map<BlockPK.CachedBlockPK, CachedBlock>> datanodeToReplicas = new HashMap<String, Map<BlockPK.CachedBlockPK, CachedBlock>>();
    boolean hasAll = false;

    public CachedBlockContext(CachedBlockDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public CachedBlock find(FinderType<CachedBlock> finder, Object ... params) throws TransactionContextException, StorageException {
        CachedBlock.Finder iFinder = (CachedBlock.Finder)finder;
        switch (iFinder) {
            case ByBlockIdInodeIdAndDatanodeId: {
                return this.findByPK(iFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<CachedBlock> findList(FinderType<CachedBlock> finder, Object ... params) throws TransactionContextException, StorageException {
        CachedBlock.Finder iFinder = (CachedBlock.Finder)finder;
        switch (iFinder) {
            case ByBlockIdAndInodeId: {
                return this.findByBlockIdAndInodeId(iFinder, params);
            }
            case ByInodeId: {
                return this.findByINodeId(iFinder, params);
            }
            case ByInodeIds: {
                return this.findByINodeIds(iFinder, params);
            }
            case ByBlockIdsAndINodeIds: {
                return this.findBatch(iFinder, params);
            }
            case ByDatanodeId: {
                return this.findByDatanodeId(iFinder, params);
            }
            case All: {
                return this.findAll(iFinder, params);
            }
            case ByDatanodeAndTypes: {
                return this.findByDatanodeAndTypes(iFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    BlockPK.CachedBlockPK getKey(CachedBlock cachedBlock) {
        return new BlockPK.CachedBlockPK(cachedBlock.getBlockId(), cachedBlock.getInodeId(), cachedBlock.getDatanodeId());
    }

    private CachedBlock findByPK(CachedBlock.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        BlockPK.CachedBlockPK pk = (BlockPK.CachedBlockPK)params[0];
        CachedBlock result = null;
        if (this.contains(pk)) {
            result = (CachedBlock)this.get(pk);
            this.hit((FinderType)iFinder, result, new Object[]{"id", pk});
        } else {
            this.aboutToAccessStorage((FinderType)iFinder, params);
            result = (CachedBlock)this.dataAccess.find(pk.getBlockId(), pk.getInodeId(), pk.getDatanodeId());
            this.gotFromDB(pk, result);
            this.miss((FinderType)iFinder, result, new Object[]{"Id", pk});
        }
        return result;
    }

    private List<CachedBlock> findByBlockIdAndInodeId(CachedBlock.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long blockId = (Long)params[0];
        int inodeId = (Integer)params[1];
        List results = null;
        if (this.containsByBlock(blockId) || this.containsByINode(inodeId)) {
            results = this.getByBlock(blockId);
            this.hit((FinderType)iFinder, results, new Object[]{"bid", blockId});
        } else {
            this.aboutToAccessStorage((FinderType)iFinder, params);
            results = this.dataAccess.findCachedBlockById(blockId);
            this.gotFromDB(new BlockPK.CachedBlockPK(blockId, inodeId), results);
            this.miss((FinderType)iFinder, results, new Object[]{"bid", blockId});
        }
        return results;
    }

    private List<CachedBlock> findByINodeId(CachedBlock.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        int inodeId = (Integer)params[0];
        List results = null;
        if (this.containsByINode(inodeId)) {
            results = this.getByINode(inodeId);
            this.hit((FinderType)iFinder, results, new Object[]{"inodeid", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)iFinder, params);
            results = this.dataAccess.findCachedBlockByINodeId(inodeId);
            this.gotFromDB(new BlockPK.CachedBlockPK(inodeId), results);
            this.miss((FinderType)iFinder, results, new Object[]{"inodeid", inodeId});
        }
        return results;
    }

    private List<CachedBlock> findByINodeIds(CachedBlock.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        int[] ids = (int[])params[0];
        this.aboutToAccessStorage((FinderType)iFinder, params);
        List results = this.dataAccess.findCachedBlockByINodeIds(ids);
        this.gotFromDB(BlockPK.CachedBlockPK.getKeys(ids), results);
        this.miss((FinderType)iFinder, results, new Object[]{"inodeIds", Arrays.toString(ids)});
        return results;
    }

    private List<CachedBlock> findBatch(CachedBlock.Finder bFinder, Object[] params) throws TransactionContextException, StorageException {
        List result = null;
        long[] blockIds = (long[])params[0];
        int[] inodeIds = (int[])params[1];
        DatanodeID datanodeId = (DatanodeID)params[2];
        this.aboutToAccessStorage((FinderType)bFinder, params);
        result = this.dataAccess.findByIds(blockIds, inodeIds, datanodeId.getDatanodeUuid());
        this.miss((FinderType)bFinder, result, new Object[]{"BlockIds", Arrays.toString(blockIds), "InodeIds", Arrays.toString(inodeIds), "datanodeId", datanodeId});
        for (CachedBlock block : result) {
            this.gotFromDB(block);
        }
        for (int i = 0; i < blockIds.length; ++i) {
            BlockPK.CachedBlockPK pk = new BlockPK.CachedBlockPK(blockIds[i], inodeIds[i], datanodeId.getDatanodeUuid());
            if (this.contains(pk)) continue;
            this.gotFromDB(pk, (CachedBlock)null);
        }
        return result;
    }

    private List<CachedBlock> findByDatanodeId(CachedBlock.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        DatanodeID datanodeId = (DatanodeID)params[0];
        List results = null;
        if (this.containsByDatanode(datanodeId.getDatanodeUuid())) {
            results = this.getByDatanode(datanodeId.getDatanodeUuid());
            this.hit((FinderType)iFinder, results, new Object[]{"datanodeId", datanodeId});
        } else {
            this.aboutToAccessStorage((FinderType)iFinder, params);
            results = this.dataAccess.findCachedBlockByDatanodeId(datanodeId.getDatanodeUuid());
            this.gotFromDB(new BlockPK.CachedBlockPK(datanodeId.getDatanodeUuid()), results);
            this.miss((FinderType)iFinder, results, new Object[]{"datanodeId", datanodeId});
        }
        return results;
    }

    private Collection<CachedBlock> findAll(CachedBlock.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        Collection results = null;
        if (this.hasAll) {
            results = this.getAll();
            this.hit((FinderType)iFinder, results, new Object[]{"all"});
        } else {
            this.aboutToAccessStorage((FinderType)iFinder, params);
            results = this.dataAccess.findAll();
            this.hasAll = true;
            this.gotFromDB(results);
            this.miss((FinderType)iFinder, results, new Object[]{"all"});
        }
        return results;
    }

    private List<CachedBlock> findByDatanodeAndTypes(CachedBlock.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        String datanodeId = (String)params[0];
        CachedBlock.Type type = (CachedBlock.Type)((Object)params[1]);
        List<CachedBlock> results = null;
        if (!this.preventStorageCalls()) {
            throw new StorageCallPreventedException("[" + iFinder + "] Trying to access storage while it should allways be called after a more general lock");
        }
        results = this.getByDatanodeAndType(datanodeId, type.toString());
        this.hit((FinderType)iFinder, results, new Object[]{"datanodeId", datanodeId, "type", type.toString()});
        return results;
    }

    @Override
    public void remove(CachedBlock entity) throws TransactionContextException {
        super.remove(entity);
        BlockPK.CachedBlockPK key = this.getKey(entity);
        Map<BlockPK.CachedBlockPK, CachedBlock> entityMap = this.datanodeToReplicas.get(key.getDatanodeId());
        if (entityMap != null) {
            entityMap.remove(key);
        }
    }

    @Override
    public void clear() throws TransactionContextException {
        super.clear();
        this.datanodeToReplicas.clear();
    }

    @Override
    protected void addInternal(BlockPK.CachedBlockPK key, CachedBlock entity) {
        super.addInternal(key, entity);
        if (key.hasDatanodeId()) {
            Map<BlockPK.CachedBlockPK, CachedBlock> entityMap = this.datanodeToReplicas.get(key.getDatanodeId());
            if (entityMap == null) {
                entityMap = new HashMap<BlockPK.CachedBlockPK, CachedBlock>();
                this.datanodeToReplicas.put(key.getDatanodeId(), entityMap);
            }
            entityMap.put(key, entity);
        }
    }

    @Override
    final void gotFromDB(BlockPK.CachedBlockPK key, List<CachedBlock> entities) {
        Map<BlockPK.CachedBlockPK, CachedBlock> entityMap;
        super.gotFromDB(key, entities);
        if (key.hasDatanodeId() && (entityMap = this.datanodeToReplicas.get(key.getDatanodeId())) == null) {
            this.datanodeToReplicas.put(key.getDatanodeId(), null);
        }
    }

    final boolean containsByDatanode(String datanodeId) {
        return this.datanodeToReplicas.containsKey(datanodeId);
    }

    final List<CachedBlock> getByDatanode(String datanodeId) {
        Map<BlockPK.CachedBlockPK, CachedBlock> entityMap = this.datanodeToReplicas.get(datanodeId);
        if (entityMap == null) {
            return null;
        }
        return new ArrayList<CachedBlock>(entityMap.values());
    }

    final List<CachedBlock> getByDatanodeAndType(String datanodeId, String type) {
        Map<BlockPK.CachedBlockPK, CachedBlock> entityMap = this.datanodeToReplicas.get(datanodeId);
        if (entityMap == null) {
            return null;
        }
        ArrayList<CachedBlock> result = new ArrayList<CachedBlock>();
        for (CachedBlock block : entityMap.values()) {
            if (!block.getStatus().equals(type)) continue;
            result.add(block);
        }
        return result;
    }

    @Override
    CachedBlock cloneEntity(CachedBlock cachedBlock) {
        return this.cloneEntity(cachedBlock, cachedBlock.getInodeId());
    }

    @Override
    CachedBlock cloneEntity(CachedBlock cachedBlock, int inodeId) {
        return new CachedBlock(cachedBlock.getBlockId(), inodeId, cachedBlock.getDatanodeId(), cachedBlock.getStatus(), cachedBlock.getReplicationAndMark());
    }
}

