/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.CounterType;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.LeaseDataAccess;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdfs.server.namenode.Lease;

public class LeaseContext
extends BaseEntityContext<String, Lease> {
    private final LeaseDataAccess<Lease> dataAccess;
    private final Map<Integer, Lease> idToLease = new HashMap<Integer, Lease>();

    public LeaseContext(LeaseDataAccess<Lease> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void update(Lease lease) throws TransactionContextException {
        super.update((Object)lease);
        this.idToLease.put(lease.getHolderID(), lease);
        if (this.isLogDebugEnabled()) {
            this.log("added-lease", new Object[]{"holder", lease.getHolder(), "hid", lease.getHolderID()});
        }
    }

    public int count(CounterType<Lease> counter, Object ... params) throws TransactionContextException, StorageException {
        Lease.Counter lCounter = (Lease.Counter)counter;
        switch (lCounter) {
            case All: {
                if (this.isLogDebugEnabled()) {
                    this.log("count-all-leases", new Object[0]);
                }
                return this.dataAccess.countAll();
            }
        }
        throw new RuntimeException(UNSUPPORTED_COUNTER);
    }

    public Lease find(FinderType<Lease> finder, Object ... params) throws TransactionContextException, StorageException {
        Lease.Finder lFinder = (Lease.Finder)finder;
        switch (lFinder) {
            case ByHolder: {
                return this.findByHolder(lFinder, params);
            }
            case ByHolderId: {
                return this.findByHolderId(lFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<Lease> findList(FinderType<Lease> finder, Object ... params) throws TransactionContextException, StorageException {
        Lease.Finder lFinder = (Lease.Finder)finder;
        switch (lFinder) {
            case All: {
                return this.findAll(lFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void remove(Lease lease) throws TransactionContextException {
        super.remove((Object)lease);
        this.idToLease.remove(lease.getHolderID());
        if (this.isLogDebugEnabled()) {
            this.log("removed-lease", new Object[]{"holder", lease.getHolder()});
        }
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    public void clear() throws TransactionContextException {
        super.clear();
        this.idToLease.clear();
    }

    String getKey(Lease lease) {
        return lease.getHolder();
    }

    private Lease findByHolder(Lease.Finder lFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        String holder = (String)params[0];
        int holderId = (Integer)params[1];
        Lease result = null;
        if (this.contains(holder)) {
            result = (Lease)this.get(holder);
            this.hit(lFinder, result, new Object[]{"holder", holder, "holderId", holderId});
        } else {
            this.aboutToAccessStorage(lFinder, params);
            result = (Lease)this.dataAccess.findByPKey(holder, holderId);
            this.gotFromDB(holder, result);
            if (result != null) {
                this.idToLease.put(result.getHolderID(), result);
            }
            this.miss(lFinder, result, new Object[]{"holder", holder, "holderId", holderId});
        }
        return result;
    }

    private Lease findByHolderId(Lease.Finder lFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        int holderId = (Integer)params[0];
        Lease result = null;
        if (this.idToLease.containsKey(holderId)) {
            result = this.idToLease.get(holderId);
            this.hit(lFinder, result, new Object[]{"hid", holderId});
        } else {
            this.aboutToAccessStorage(lFinder, params);
            result = (Lease)this.dataAccess.findByHolderId(holderId);
            this.gotFromDB(result);
            this.idToLease.put(holderId, result);
            this.miss(lFinder, result, new Object[]{"hid", holderId});
        }
        return result;
    }

    private Collection<Lease> findAll(Lease.Finder lFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        Collection result = null;
        this.aboutToAccessStorage(lFinder, params);
        result = this.dataAccess.findAll();
        this.gotFromDB(result);
        for (Lease lease : result) {
            this.idToLease.put(lease.getHolderID(), lease);
        }
        this.miss(lFinder, result, new Object[0]);
        return result;
    }
}

