/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.PendingBlockDataAccess;
import io.hops.transaction.context.BaseReplicaContext;
import io.hops.transaction.context.BlockPK;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingBlockInfo;

public class PendingBlockContext
extends BaseReplicaContext<BlockPK, PendingBlockInfo> {
    private final PendingBlockDataAccess<PendingBlockInfo> dataAccess;
    private boolean allPendingRead = false;

    public PendingBlockContext(PendingBlockDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    @Override
    public void update(PendingBlockInfo pendingBlockInfo) throws TransactionContextException {
        super.update(pendingBlockInfo);
        if (this.isLogDebugEnabled()) {
            this.log("added-pending", new Object[]{"bid", pendingBlockInfo.getBlockId(), "numInProgress", pendingBlockInfo.getNumReplicas()});
        }
    }

    @Override
    public void remove(PendingBlockInfo pendingBlockInfo) throws TransactionContextException {
        super.remove(pendingBlockInfo);
        if (this.isLogDebugEnabled()) {
            this.log("removed-pending", new Object[]{"bid", pendingBlockInfo.getBlockId()});
        }
    }

    public PendingBlockInfo find(FinderType<PendingBlockInfo> finder, Object ... params) throws TransactionContextException, StorageException {
        PendingBlockInfo.Finder pFinder = (PendingBlockInfo.Finder)finder;
        switch (pFinder) {
            case ByBlockIdAndINodeId: {
                return this.findByBlockId(pFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<PendingBlockInfo> findList(FinderType<PendingBlockInfo> finder, Object ... params) throws TransactionContextException, StorageException {
        PendingBlockInfo.Finder pFinder = (PendingBlockInfo.Finder)finder;
        switch (pFinder) {
            case All: {
                return this.findAll(pFinder);
            }
            case ByINodeId: {
                return this.findByINodeId(pFinder, params);
            }
            case ByINodeIds: {
                return this.findByINodeIds(pFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    @Override
    public void clear() throws TransactionContextException {
        super.clear();
        this.allPendingRead = false;
    }

    @Override
    PendingBlockInfo cloneEntity(PendingBlockInfo pendingBlockInfo) {
        return this.cloneEntity(pendingBlockInfo, pendingBlockInfo.getInodeId());
    }

    @Override
    PendingBlockInfo cloneEntity(PendingBlockInfo pendingBlockInfo, int inodeId) {
        return new PendingBlockInfo(pendingBlockInfo.getBlockId(), inodeId, pendingBlockInfo.getTimeStamp(), pendingBlockInfo.getTargets());
    }

    BlockPK getKey(PendingBlockInfo pendingBlockInfo) {
        return new BlockPK(pendingBlockInfo.getBlockId(), pendingBlockInfo.getInodeId());
    }

    private PendingBlockInfo findByBlockId(PendingBlockInfo.Finder pFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long blockId = (Long)params[0];
        int inodeId = (Integer)params[1];
        PendingBlockInfo result = null;
        if (this.containsByBlock(blockId) || this.containsByINode(inodeId)) {
            List pblks = this.getByBlock(blockId);
            if (pblks != null) {
                if (pblks.size() > 1) {
                    throw new IllegalStateException("you should have only one PendingBlockInfo per block");
                }
                if (!pblks.isEmpty()) {
                    result = (PendingBlockInfo)pblks.get(0);
                }
            }
            this.hit(pFinder, result, new Object[]{"bid", blockId, "inodeid", inodeId});
        } else {
            this.aboutToAccessStorage(pFinder, params);
            result = (PendingBlockInfo)this.dataAccess.findByBlockAndInodeIds(blockId, inodeId);
            this.gotFromDB(new BlockPK(blockId, inodeId), result);
            this.miss(pFinder, result, new Object[]{"bid", blockId, "inodeid", inodeId});
        }
        return result;
    }

    private List<PendingBlockInfo> findAll(PendingBlockInfo.Finder pFinder) throws StorageCallPreventedException, StorageException {
        ArrayList<PendingBlockInfo> result = null;
        if (this.allPendingRead) {
            result = new ArrayList(this.getAll());
            this.hit(pFinder, result, new Object[0]);
        } else {
            this.aboutToAccessStorage(pFinder);
            result = this.dataAccess.findAll();
            this.gotFromDB(result);
            this.allPendingRead = true;
            this.miss(pFinder, result, new Object[0]);
        }
        return result;
    }

    private List<PendingBlockInfo> findByINodeId(PendingBlockInfo.Finder pFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        int inodeId = (Integer)params[0];
        List result = null;
        if (this.containsByINode(inodeId)) {
            result = this.getByINode(inodeId);
            this.hit(pFinder, result, new Object[]{"inodeid", inodeId});
        } else {
            this.aboutToAccessStorage(pFinder, params);
            result = this.dataAccess.findByINodeId(inodeId);
            this.gotFromDB(new BlockPK(inodeId), result);
            this.miss(pFinder, result, new Object[]{"inodeid", inodeId});
        }
        return result;
    }

    private List<PendingBlockInfo> findByINodeIds(PendingBlockInfo.Finder pFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        int[] inodeIds = (int[])params[0];
        List result = null;
        this.aboutToAccessStorage(pFinder, params);
        result = this.dataAccess.findByINodeIds(inodeIds);
        this.gotFromDB(BlockPK.getBlockKeys(inodeIds), result);
        this.miss(pFinder, result, new Object[]{"inodeids", Arrays.toString(inodeIds)});
        return result;
    }
}

