/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.ReplicaDataAccess;
import io.hops.metadata.hdfs.entity.Replica;
import io.hops.transaction.context.BaseReplicaContext;
import io.hops.transaction.context.BlockPK;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ReplicaContext
extends BaseReplicaContext<BlockPK.ReplicaPK, Replica> {
    private ReplicaDataAccess dataAccess;

    public ReplicaContext(ReplicaDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    @Override
    public void update(Replica replica) throws TransactionContextException {
        super.update(replica);
        if (this.isLogDebugEnabled()) {
            this.log("updated-replica", new Object[]{"bid", replica.getBlockId(), "sid", replica.getStorageId()});
        }
    }

    @Override
    public void remove(Replica replica) throws TransactionContextException {
        super.remove(replica);
        if (this.isLogDebugEnabled()) {
            this.log("removed-replica", new Object[]{"bid", replica.getBlockId(), "sid", replica.getStorageId()});
        }
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    public Collection<Replica> findList(FinderType<Replica> finder, Object ... params) throws TransactionContextException, StorageException {
        Replica.Finder iFinder = (Replica.Finder)finder;
        switch (iFinder) {
            case ByBlockIdAndINodeId: {
                return this.findByBlockId(iFinder, params);
            }
            case ByINodeId: {
                return this.findByINodeId(iFinder, params);
            }
            case ByINodeIds: {
                return this.findyByINodeIds(iFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Replica find(FinderType<Replica> finder, Object ... params) throws TransactionContextException, StorageException {
        Replica.Finder iFinder = (Replica.Finder)finder;
        switch (iFinder) {
            case ByBlockIdAndStorageId: {
                return this.findByPK(iFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    BlockPK.ReplicaPK getKey(Replica hopReplica) {
        return new BlockPK.ReplicaPK(hopReplica.getBlockId(), hopReplica.getInodeId(), hopReplica.getStorageId());
    }

    @Override
    Replica cloneEntity(Replica hopReplica) {
        return this.cloneEntity(hopReplica, hopReplica.getInodeId());
    }

    @Override
    Replica cloneEntity(Replica hopReplica, int inodeId) {
        return new Replica(hopReplica.getStorageId(), hopReplica.getBlockId(), inodeId, hopReplica.getBucketId());
    }

    @Override
    protected boolean snapshotChanged() {
        return !this.getAdded().isEmpty() || !this.getModified().isEmpty();
    }

    private Replica findByPK(Replica.Finder iFinder, Object[] params) {
        long blockId = (Long)params[0];
        int storageId = (Integer)params[1];
        Replica result = null;
        List replicas = this.getByBlock(blockId);
        if (replicas != null) {
            for (Replica replica : replicas) {
                if (replica == null || replica.getStorageId() != storageId) continue;
                result = replica;
                break;
            }
        }
        this.hit((FinderType)iFinder, result, new Object[]{"bid", blockId, "sid", storageId});
        return result;
    }

    private List<Replica> findByBlockId(Replica.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long blockId = (Long)params[0];
        int inodeId = (Integer)params[1];
        List results = null;
        if (this.containsByBlock(blockId) || this.containsByINode(inodeId) && this.storageCallPrevented) {
            results = this.getByBlock(blockId);
            this.hit((FinderType)iFinder, results, new Object[]{"bid", blockId});
        } else {
            this.aboutToAccessStorage((FinderType)iFinder, params);
            results = this.dataAccess.findReplicasById(blockId, inodeId);
            this.gotFromDB(new BlockPK(blockId), results);
            this.miss((FinderType)iFinder, results, new Object[]{"bid", blockId});
        }
        return results;
    }

    private List<Replica> findByINodeId(Replica.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        int inodeId = (Integer)params[0];
        List results = null;
        if (this.containsByINode(inodeId)) {
            results = this.getByINode(inodeId);
            this.hit((FinderType)iFinder, results, new Object[]{"inodeid", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)iFinder, params);
            results = this.dataAccess.findReplicasByINodeId(inodeId);
            this.gotFromDB(new BlockPK(inodeId), results);
            this.miss((FinderType)iFinder, results, new Object[]{"inodeid", inodeId});
        }
        return results;
    }

    private List<Replica> findyByINodeIds(Replica.Finder iFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        int[] ids = (int[])params[0];
        this.aboutToAccessStorage((FinderType)iFinder, params);
        List results = this.dataAccess.findReplicasByINodeIds(ids);
        this.gotFromDB(BlockPK.ReplicaPK.getKeys(ids), results);
        this.miss((FinderType)iFinder, results, new Object[]{"inodeIds", Arrays.toString(ids)});
        return results;
    }
}

