/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.UnderReplicatedBlockDataAccess;
import io.hops.metadata.hdfs.entity.UnderReplicatedBlock;
import io.hops.transaction.context.BaseReplicaContext;
import io.hops.transaction.context.BlockPK;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class UnderReplicatedBlockContext
extends BaseReplicaContext<BlockPK, UnderReplicatedBlock> {
    private final UnderReplicatedBlockDataAccess<UnderReplicatedBlock> dataAccess;

    public UnderReplicatedBlockContext(UnderReplicatedBlockDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    @Override
    public void update(UnderReplicatedBlock hopUnderReplicatedBlock) throws TransactionContextException {
        super.update(hopUnderReplicatedBlock);
        if (this.isLogDebugEnabled()) {
            this.log("added-urblock", new Object[]{"bid", hopUnderReplicatedBlock.getBlockId(), "level", hopUnderReplicatedBlock.getLevel(), "inodeId", hopUnderReplicatedBlock.getInodeId()});
        }
    }

    @Override
    public void remove(UnderReplicatedBlock hopUnderReplicatedBlock) throws TransactionContextException {
        super.remove(hopUnderReplicatedBlock);
        if (this.isLogDebugEnabled()) {
            this.log("removed-urblock", new Object[]{"bid", hopUnderReplicatedBlock.getBlockId(), "level", hopUnderReplicatedBlock.getLevel()});
        }
    }

    public UnderReplicatedBlock find(FinderType<UnderReplicatedBlock> finder, Object ... params) throws TransactionContextException, StorageException {
        UnderReplicatedBlock.Finder urFinder = (UnderReplicatedBlock.Finder)finder;
        switch (urFinder) {
            case ByBlockIdAndINodeId: {
                return this.findByBlockId(urFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<UnderReplicatedBlock> findList(FinderType<UnderReplicatedBlock> finder, Object ... params) throws TransactionContextException, StorageException {
        UnderReplicatedBlock.Finder urFinder = (UnderReplicatedBlock.Finder)finder;
        switch (urFinder) {
            case ByINodeId: {
                return this.findByINodeId(urFinder, params);
            }
            case ByINodeIds: {
                return this.findByINodeIds(urFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    @Override
    UnderReplicatedBlock cloneEntity(UnderReplicatedBlock hopUnderReplicatedBlock) {
        return this.cloneEntity(hopUnderReplicatedBlock, hopUnderReplicatedBlock.getInodeId());
    }

    @Override
    UnderReplicatedBlock cloneEntity(UnderReplicatedBlock hopUnderReplicatedBlock, int inodeId) {
        return new UnderReplicatedBlock(hopUnderReplicatedBlock.getLevel(), hopUnderReplicatedBlock.getBlockId(), inodeId);
    }

    BlockPK getKey(UnderReplicatedBlock hopUnderReplicatedBlock) {
        return new BlockPK(hopUnderReplicatedBlock.getBlockId(), hopUnderReplicatedBlock.getInodeId());
    }

    private UnderReplicatedBlock findByBlockId(UnderReplicatedBlock.Finder urFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long blockId = (Long)params[0];
        int inodeId = (Integer)params[1];
        UnderReplicatedBlock result = null;
        if (this.containsByBlock(blockId) || this.containsByINode(inodeId)) {
            List urblks = this.getByBlock(blockId);
            if (urblks != null) {
                if (urblks.size() > 1) {
                    throw new IllegalStateException("you should have only one UnderReplicatedBlock per block");
                }
                if (!urblks.isEmpty()) {
                    result = (UnderReplicatedBlock)urblks.get(0);
                }
            }
            this.hit((FinderType)urFinder, result, new Object[]{"bid", blockId, "inodeid", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)urFinder, params);
            result = (UnderReplicatedBlock)this.dataAccess.findByPk(blockId, inodeId);
            this.gotFromDB(new BlockPK(blockId, inodeId), result);
            this.miss((FinderType)urFinder, result, new Object[]{"bid", blockId, "inodeid", inodeId});
        }
        return result;
    }

    private List<UnderReplicatedBlock> findByINodeId(UnderReplicatedBlock.Finder urFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        int inodeId = (Integer)params[0];
        List result = null;
        if (this.containsByINode(inodeId)) {
            result = this.getByINode(inodeId);
            this.hit((FinderType)urFinder, result, new Object[]{"inodeid", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)urFinder, params);
            result = this.dataAccess.findByINodeId(inodeId);
            this.gotFromDB(new BlockPK(inodeId), result);
            this.miss((FinderType)urFinder, result, new Object[]{"inodeid", inodeId});
        }
        return result;
    }

    private List<UnderReplicatedBlock> findByINodeIds(UnderReplicatedBlock.Finder urFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        int[] inodeIds = (int[])params[0];
        List result = null;
        this.aboutToAccessStorage((FinderType)urFinder, params);
        result = this.dataAccess.findByINodeIds(inodeIds);
        this.gotFromDB(BlockPK.getBlockKeys(inodeIds), result);
        this.miss((FinderType)urFinder, result, new Object[]{"inodeids", Arrays.toString(inodeIds)});
        return result;
    }
}

