/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdfs.server.namenode.INode;

abstract class BaseEncodingStatusLock
extends Lock {
    private final TransactionLockTypes.LockType lockType;

    protected BaseEncodingStatusLock(TransactionLockTypes.LockType lockType) {
        this.lockType = lockType;
    }

    public TransactionLockTypes.LockType getLockType() {
        return this.lockType;
    }

    protected final Lock.Type getType() {
        return Lock.Type.EncodingStatus;
    }

    static final class BatchedEncodingStatusLock
    extends BaseEncodingStatusLock {
        private final Set<Integer> inodeIds = new HashSet<Integer>();

        BatchedEncodingStatusLock(TransactionLockTypes.LockType lockType, List<INodeIdentifier> inodeIdentifiers) {
            super(lockType);
            for (INodeIdentifier identifier : inodeIdentifiers) {
                this.inodeIds.add(identifier.getInodeId());
            }
        }

        protected void acquire(TransactionLocks locks) throws IOException {
            Collection status = this.acquireLockList(this.getLockType(), (FinderType)EncodingStatus.Finder.ByInodeIds, new Object[]{this.inodeIds});
            for (EncodingStatus s : status) {
                this.inodeIds.remove(s.getInodeId());
            }
            if (this.inodeIds.isEmpty()) {
                return;
            }
            this.acquireLockList(this.getLockType(), (FinderType)EncodingStatus.Finder.ByParityInodeIds, new Object[]{this.inodeIds});
        }
    }

    static final class IndividualEncodingStatusLock
    extends BaseEncodingStatusLock {
        private final int inodeId;

        IndividualEncodingStatusLock(TransactionLockTypes.LockType lockType, int inodeId) {
            super(lockType);
            this.inodeId = inodeId;
        }

        protected void acquire(TransactionLocks locks) throws IOException {
            EncodingStatus status = (EncodingStatus)this.acquireLock(this.getLockType(), (FinderType)EncodingStatus.Finder.ByInodeId, new Object[]{this.inodeId});
            if (status != null) {
                return;
            }
            this.acquireLock(this.getLockType(), (FinderType)EncodingStatus.Finder.ByParityInodeId, new Object[]{this.inodeId});
        }
    }

    static final class EncodingStatusLock
    extends BaseEncodingStatusLock {
        private final String[] targets;
        private final boolean includeChildren;

        EncodingStatusLock(TransactionLockTypes.LockType lockType, String ... targets) {
            super(lockType);
            this.targets = targets;
            this.includeChildren = false;
        }

        EncodingStatusLock(boolean includeChildren, TransactionLockTypes.LockType lockType, String ... targets) {
            super(lockType);
            this.targets = targets;
            this.includeChildren = includeChildren;
        }

        protected void acquire(TransactionLocks locks) throws IOException {
            BaseINodeLock iNodeLock = (BaseINodeLock)locks.getLock(Lock.Type.INode);
            Arrays.sort(this.targets);
            for (String target : this.targets) {
                INode iNode = iNodeLock.getTargetINode(target);
                if (!BaseINodeLock.isStoredInDB(iNode)) {
                    List<INode> children;
                    this.acquireLocks(iNode);
                    if (!this.includeChildren || (children = iNodeLock.getChildINodes(target)) == null) continue;
                    for (INode child : children) {
                        this.acquireLocks(child);
                    }
                    continue;
                }
                LOG.debug((Object)("Stuffed Inode:  BaseEncodingStatusLock. Skipping acquring locks on the inode named: " + iNode.getLocalName() + " as the file is stored in the database"));
            }
        }

        private void acquireLocks(INode iNode) throws TransactionContextException, StorageException {
            EncodingStatus status = (EncodingStatus)this.acquireLock(this.getLockType(), (FinderType)EncodingStatus.Finder.ByInodeId, new Object[]{iNode.getId()});
            if (status != null) {
                return;
            }
            this.acquireLock(this.getLockType(), (FinderType)EncodingStatus.Finder.ByParityInodeId, new Object[]{iNode.getId()});
        }
    }
}

