/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.common.INodeUtil;
import io.hops.common.Pair;
import io.hops.transaction.lock.BaseIndividualBlockLock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;

final class BatchedBlockLock
extends BaseIndividualBlockLock {
    private long[] blockIds;
    private int[] inodeIds;
    private final long[] unresolvedBlockIds;

    public BatchedBlockLock(long[] blockIds, int[] inodeIds, long[] unresolvedBlockIds) {
        this.blockIds = blockIds;
        this.inodeIds = inodeIds;
        this.unresolvedBlockIds = unresolvedBlockIds;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        if (this.unresolvedBlockIds != null && this.unresolvedBlockIds.length != 0) {
            int[] inodeIdsForURBlks = INodeUtil.resolveINodesFromBlockIds(this.unresolvedBlockIds);
            this.blockIds = ArrayUtils.addAll((long[])this.blockIds, (long[])this.unresolvedBlockIds);
            this.inodeIds = ArrayUtils.addAll((int[])this.inodeIds, (int[])inodeIdsForURBlks);
        }
        this.blocks.addAll(this.acquireLockList(DEFAULT_LOCK_TYPE, BlockInfo.Finder.ByBlockIdsAndINodeIds, new Object[]{this.blockIds, this.inodeIds}));
    }

    Pair<int[], long[]> getINodeBlockIds() {
        return new Pair<int[], long[]>(this.inodeIds, this.blockIds);
    }
}

