/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INode;

public class BatchedINodeLock
extends BaseINodeLock {
    private final List<INodeIdentifier> inodeIdentifiers;
    private int[] inodeIds;

    public BatchedINodeLock(List<INodeIdentifier> inodeIdentifiers) {
        this.inodeIdentifiers = inodeIdentifiers;
        this.inodeIds = new int[inodeIdentifiers.size()];
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        List<INode> inodes;
        if (this.inodeIdentifiers != null && !this.inodeIdentifiers.isEmpty()) {
            String[] names = new String[this.inodeIdentifiers.size()];
            int[] parentIds = new int[this.inodeIdentifiers.size()];
            int[] partitionIds = new int[this.inodeIdentifiers.size()];
            for (int i = 0; i < this.inodeIdentifiers.size(); ++i) {
                INodeIdentifier inodeIdentifier = this.inodeIdentifiers.get(i);
                names[i] = inodeIdentifier.getName();
                parentIds[i] = inodeIdentifier.getPid();
                partitionIds[i] = inodeIdentifier.getPartitionId();
                this.inodeIds[i] = inodeIdentifier.getInodeId();
            }
            inodes = this.find(this.getDefaultInodeLockType(), names, parentIds, partitionIds, false);
            for (INode inode : inodes) {
                if (inode == null) continue;
                List<INode> pathInodes = this.readUpInodes(inode);
                this.addPathINodesAndUpdateResolvingCache(INodeUtil.constructPath(pathInodes), pathInodes);
            }
        } else {
            throw new StorageException("INodeIdentifier object is not properly initialized ");
        }
        this.addIndividualINodes(inodes);
    }

    int[] getINodeIds() {
        return this.inodeIds;
    }

    public String toString() {
        if (this.inodeIdentifiers != null) {
            return "Batch INode Lock = { " + this.inodeIdentifiers.size() + " inodes locked  }";
        }
        return "No inodes selected for batch locking";
    }
}

