/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Longs;
import io.hops.common.INodeUtil;
import io.hops.metadata.hdfs.entity.CachedBlock;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.lock.AllCachedBlockLock;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.IndividualBlockLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;

public final class BlockLock
extends IndividualBlockLock {
    private final List<INodeFile> files = new ArrayList<INodeFile>();

    BlockLock() {
    }

    BlockLock(long blockId, INodeIdentifier inode) {
        super(blockId, inode);
    }

    @Override
    protected void acquire(TransactionLocks locks) throws IOException {
        boolean individualBlockAlreadyRead = false;
        if (locks.containsLock(Lock.Type.INode)) {
            BaseINodeLock inodeLock = (BaseINodeLock)locks.getLock(Lock.Type.INode);
            Iterable blks = Collections.EMPTY_LIST;
            for (INode inode : inodeLock.getAllResolvedINodes()) {
                if (BaseINodeLock.isStoredInDB(inode)) {
                    LOG.debug((Object)("Stuffed Inode:  BlockLock. Skipping acquring locks on the inode named: " + inode.getLocalName() + " as the file is stored in the database"));
                    this.announceEmptyFile(inode.getId());
                    continue;
                }
                if (!(inode instanceof INodeFile)) continue;
                Collection inodeBlocks = Collections.EMPTY_LIST;
                if (((INodeFile)inode).hasBlocks()) {
                    inodeBlocks = this.acquireLockList(DEFAULT_LOCK_TYPE, BlockInfo.Finder.ByINodeId, new Object[]{inode.getId()});
                }
                if (!individualBlockAlreadyRead) {
                    boolean bl = individualBlockAlreadyRead = inode.getId() == this.inodeId;
                }
                if (inodeBlocks == null || inodeBlocks.isEmpty()) {
                    this.announceEmptyFile(inode.getId());
                }
                blks = Iterables.concat((Iterable)blks, (Iterable)inodeBlocks);
                this.files.add((INodeFile)inode);
            }
        } else if (locks.containsLock(Lock.Type.AllCachedBlock)) {
            AllCachedBlockLock cachedBlockLock = (AllCachedBlockLock)locks.getLock(Lock.Type.AllCachedBlock);
            Collection<CachedBlock> cBlocks = cachedBlockLock.getAllResolvedCachedBlock();
            HashSet<Long> blockIdSet = new HashSet<Long>();
            for (CachedBlock cBlock : cBlocks) {
                blockIdSet.add(cBlock.getBlockId());
            }
            long[] blockIds = Longs.toArray(blockIdSet);
            int[] inodeIds = INodeUtil.resolveINodesFromBlockIds(blockIds);
            this.blocks.addAll(this.acquireLockList(DEFAULT_LOCK_TYPE, BlockInfo.Finder.ByBlockIdsAndINodeIds, new Object[]{blockIds, inodeIds}));
        } else {
            throw new TransactionLocks.LockNotAddedException("BlockLock must come either after an InodeLock of a AllCachedBlockLock");
        }
        if (!individualBlockAlreadyRead) {
            super.acquire(locks);
        }
    }

    Collection<INodeFile> getFiles() {
        return this.files;
    }
}

