/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.HashBucket;
import io.hops.transaction.EntityManager;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;

public class IndividualHashBucketLock
extends Lock {
    private final int storageId;
    private final int bucketId;

    IndividualHashBucketLock(int storageId, int bucketId) {
        this.storageId = storageId;
        this.bucketId = bucketId;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        IndividualHashBucketLock.setLockMode((TransactionLockTypes.LockType)TransactionLockTypes.LockType.WRITE);
        if (EntityManager.find((FinderType)HashBucket.Finder.ByStorageIdAndBucketId, (Object[])new Object[]{this.storageId, this.bucketId}) == null) {
            EntityManager.update((Object)new HashBucket(this.storageId, this.bucketId, 0L));
            LOG.warn((Object)"The accessed bucket had not been initialized. There might be a misconfiguration.");
        }
    }

    protected Lock.Type getType() {
        return Lock.Type.HashBucket;
    }
}

