/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.hdfs.entity.LeasePath;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.IndividualBlockLock;
import io.hops.transaction.lock.LeasePathLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hdfs.server.namenode.INode;

public final class LastTwoBlocksLock
extends IndividualBlockLock {
    private final String path;

    public LastTwoBlocksLock(String src) {
        this.path = src;
    }

    @Override
    protected void acquire(TransactionLocks locks) throws IOException {
        INodeLock iNodeLock = (INodeLock)locks.getLock(Lock.Type.INode);
        LeasePathLock leasePathLock = (LeasePathLock)locks.getLock(Lock.Type.LeasePath);
        Collection<LeasePath> lps = leasePathLock.getLeasePaths();
        for (LeasePath lp : lps) {
            if (!lp.getPath().equals(this.path)) continue;
            INode targetInode = iNodeLock.getTargetINode(this.path);
            this.readBlock(lp.getLastBlockId(), targetInode.getId());
            this.readBlock(lp.getPenultimateBlockId(), targetInode.getId());
            if (this.getBlocks() != null && !this.getBlocks().isEmpty()) break;
            this.announceEmptyFile(targetInode.getId());
            break;
        }
    }
}

