/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.Lease;

public final class LeaseLock
extends Lock {
    private final TransactionLockTypes.LockType lockType;
    private final String leaseHolder;
    private final List<Lease> leases;

    LeaseLock(TransactionLockTypes.LockType lockType, String leaseHolder) {
        this.lockType = lockType;
        this.leaseHolder = leaseHolder;
        this.leases = new ArrayList<Lease>();
    }

    LeaseLock(TransactionLockTypes.LockType lockType) {
        this(lockType, null);
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        Collection leases;
        HashSet<String> hldrs = new HashSet<String>();
        if (this.leaseHolder != null) {
            hldrs.add(this.leaseHolder);
        }
        if (locks.containsLock(Lock.Type.INode)) {
            BaseINodeLock inodeLock = (BaseINodeLock)locks.getLock(Lock.Type.INode);
            for (INode f : inodeLock.getAllResolvedINodes()) {
                if (!(f instanceof INodeFile) || !f.isUnderConstruction()) continue;
                hldrs.add(((INodeFile)f).getFileUnderConstructionFeature().getClientName());
            }
        }
        LeaseLock.setLockMode((TransactionLockTypes.LockType)this.lockType);
        ArrayList holders = new ArrayList(hldrs);
        Collections.sort(holders);
        if (holders.isEmpty() && !locks.containsLock(Lock.Type.INode) && (leases = this.acquireLockList(this.lockType, Lease.Finder.All, new Object[0])) != null) {
            leases.addAll(leases);
        }
        for (String h : holders) {
            Lease lease = (Lease)this.acquireLock(this.lockType, Lease.Finder.ByHolder, new Object[]{h, Lease.getHolderId(h)});
            if (lease == null) continue;
            this.leases.add(lease);
        }
    }

    Collection<Lease> getLeases() {
        return this.leases;
    }

    public TransactionLockTypes.LockType getLockType() {
        return this.lockType;
    }

    protected final Lock.Type getType() {
        return Lock.Type.Lease;
    }
}

