/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.lock.AcesLock;
import io.hops.transaction.lock.AllCachedBlockLock;
import io.hops.transaction.lock.BaseEncodingStatusLock;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.BatchedBlockLock;
import io.hops.transaction.lock.BatchedINodeLock;
import io.hops.transaction.lock.BlockChecksumLock;
import io.hops.transaction.lock.BlockLock;
import io.hops.transaction.lock.BlockRelatedLock;
import io.hops.transaction.lock.CacheDirectiveLock;
import io.hops.transaction.lock.CachePoolLock;
import io.hops.transaction.lock.CachedBlockLock;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.IndividualBlockLock;
import io.hops.transaction.lock.IndividualHashBucketLock;
import io.hops.transaction.lock.IndividualINodeLock;
import io.hops.transaction.lock.LastBlockReplicasHashBucketLock;
import io.hops.transaction.lock.LastTwoBlocksLock;
import io.hops.transaction.lock.LeaseLock;
import io.hops.transaction.lock.LeasePathLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.NameNodeLeaseLock;
import io.hops.transaction.lock.QuotaUpdateLock;
import io.hops.transaction.lock.RenameINodeLock;
import io.hops.transaction.lock.RetryCacheEntryLock;
import io.hops.transaction.lock.SqlBatchedBlocksLock;
import io.hops.transaction.lock.SqlBatchedBlocksRelatedLock;
import io.hops.transaction.lock.SubTreeOpLock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.VariablesLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.ipc.RetryCache;

public class LockFactory {
    private static final LockFactory instance = new LockFactory();

    private LockFactory() {
    }

    public static LockFactory getInstance() {
        return instance;
    }

    public Lock getBlockChecksumLock(String target, int blockIndex) {
        return new BlockChecksumLock(target, blockIndex);
    }

    public Lock getBlockLock() {
        return new BlockLock();
    }

    public Lock getBlockLock(long blockId, INodeIdentifier inode) {
        return new BlockLock(blockId, inode);
    }

    public Lock getReplicaLock() {
        return new BlockRelatedLock(Lock.Type.Replica);
    }

    public Lock getCorruptReplicaLock() {
        return new BlockRelatedLock(Lock.Type.CorruptReplica);
    }

    public Lock getExcessReplicaLock() {
        return new BlockRelatedLock(Lock.Type.ExcessReplica);
    }

    public Lock getReplicatUnderConstructionLock() {
        return new BlockRelatedLock(Lock.Type.ReplicaUnderConstruction);
    }

    public Lock getInvalidatedBlockLock() {
        return new BlockRelatedLock(Lock.Type.InvalidatedBlock);
    }

    public Lock getUnderReplicatedBlockLock() {
        return new BlockRelatedLock(Lock.Type.UnderReplicatedBlock);
    }

    public Lock getPendingBlockLock() {
        return new BlockRelatedLock(Lock.Type.PendingBlock);
    }

    public Lock getCachedBlockLock() {
        return new BlockRelatedLock(Lock.Type.CachedBlock);
    }

    public Lock getSqlBatchedBlocksLock() {
        return new SqlBatchedBlocksLock();
    }

    public Lock getSqlBatchedReplicasLock() {
        return new SqlBatchedBlocksRelatedLock(Lock.Type.Replica);
    }

    public Lock getSqlBatchedCorruptReplicasLock() {
        return new SqlBatchedBlocksRelatedLock(Lock.Type.CorruptReplica);
    }

    public Lock getSqlBatchedExcessReplicasLock() {
        return new SqlBatchedBlocksRelatedLock(Lock.Type.ExcessReplica);
    }

    public Lock getSqlBatchedReplicasUnderConstructionLock() {
        return new SqlBatchedBlocksRelatedLock(Lock.Type.ReplicaUnderConstruction);
    }

    public Lock getSqlBatchedInvalidatedBlocksLock() {
        return new SqlBatchedBlocksRelatedLock(Lock.Type.InvalidatedBlock);
    }

    public Lock getSqlBatchedUnderReplicatedBlocksLock() {
        return new SqlBatchedBlocksRelatedLock(Lock.Type.UnderReplicatedBlock);
    }

    public Lock getSqlBatchedPendingBlocksLock() {
        return new SqlBatchedBlocksRelatedLock(Lock.Type.PendingBlock);
    }

    public Lock getSqlBatchedCachedBlockLock() {
        return new SqlBatchedBlocksRelatedLock(Lock.Type.CachedBlock);
    }

    public Lock getIndividualBlockLock(long blockId, INodeIdentifier inode) {
        return new IndividualBlockLock(blockId, inode);
    }

    public Lock getBatchedINodesLock(List<INodeIdentifier> inodeIdentifiers) {
        return new BatchedINodeLock(inodeIdentifiers);
    }

    public Lock getIndividualINodeLock(TransactionLockTypes.INodeLockType lockType, INodeIdentifier inodeIdentifier, boolean readUpPathInodes) {
        return new IndividualINodeLock(lockType, inodeIdentifier, readUpPathInodes);
    }

    public Lock getIndividualINodeLock(TransactionLockTypes.INodeLockType lockType, INodeIdentifier inodeIdentifier) {
        return new IndividualINodeLock(lockType, inodeIdentifier);
    }

    public INodeLock getINodeLock(TransactionLockTypes.INodeLockType lockType, TransactionLockTypes.INodeResolveType resolveType, String ... paths) {
        return new INodeLock(lockType, resolveType, paths);
    }

    public INodeLock getRenameINodeLock(TransactionLockTypes.INodeLockType lockType, TransactionLockTypes.INodeResolveType resolveType, String src, String dst) {
        return new RenameINodeLock(lockType, resolveType, src, dst);
    }

    public INodeLock getLegacyRenameINodeLock(TransactionLockTypes.INodeLockType lockType, TransactionLockTypes.INodeResolveType resolveType, String src, String dst) {
        return new RenameINodeLock(lockType, resolveType, src, dst, true);
    }

    public Lock getLeaseLock(TransactionLockTypes.LockType lockType, String leaseHolder) {
        return new LeaseLock(lockType, leaseHolder);
    }

    public Lock getLeaseLock(TransactionLockTypes.LockType lockType) {
        return new LeaseLock(lockType);
    }

    public Lock getLeasePathLock(TransactionLockTypes.LockType lockType, int expectedCount) {
        return new LeasePathLock(lockType, expectedCount);
    }

    public Lock getLeasePathLock(TransactionLockTypes.LockType lockType) {
        return new LeasePathLock(lockType);
    }

    public Lock getLeasePathLock(TransactionLockTypes.LockType lockType, String src) {
        return new LeasePathLock(lockType, src);
    }

    public Lock getNameNodeLeaseLock(TransactionLockTypes.LockType lockType) {
        return new NameNodeLeaseLock(lockType);
    }

    public Lock getQuotaUpdateLock(boolean includeChildren, String ... targets) {
        return new QuotaUpdateLock(includeChildren, targets);
    }

    public Lock getQuotaUpdateLock(String ... targets) {
        return new QuotaUpdateLock(targets);
    }

    public Lock getVariableLock(Variable.Finder[] finders, TransactionLockTypes.LockType[] lockTypes) {
        assert (finders.length == lockTypes.length);
        VariablesLock lock = new VariablesLock();
        for (int i = 0; i < finders.length; ++i) {
            lock.addVariable(finders[i], lockTypes[i]);
        }
        return lock;
    }

    public Lock getVariableLock(Variable.Finder finder, TransactionLockTypes.LockType lockType) {
        VariablesLock lock = new VariablesLock();
        lock.addVariable(finder, lockType);
        return lock;
    }

    public List<Lock> getBlockReportingLocks(long[] blockIds, int[] inodeIds, long[] unresolvedBlks, int storageId) {
        ArrayList<Lock> list = new ArrayList<Lock>(3);
        list.add(new BatchedBlockLock(blockIds, inodeIds, unresolvedBlks));
        return list;
    }

    public Lock getEncodingStatusLock(TransactionLockTypes.LockType lockType, String ... targets) {
        return new BaseEncodingStatusLock.EncodingStatusLock(lockType, targets);
    }

    public Lock getEncodingStatusLock(boolean includeChildren, TransactionLockTypes.LockType lockType, String ... targets) {
        return new BaseEncodingStatusLock.EncodingStatusLock(includeChildren, lockType, targets);
    }

    public Lock getIndivdualEncodingStatusLock(TransactionLockTypes.LockType lockType, int inodeId) {
        return new BaseEncodingStatusLock.IndividualEncodingStatusLock(lockType, inodeId);
    }

    public Lock getBatchedEncodingStatusLock(TransactionLockTypes.LockType lockType, List<INodeIdentifier> inodeIds) {
        return new BaseEncodingStatusLock.BatchedEncodingStatusLock(lockType, inodeIds);
    }

    public Lock getSubTreeOpsLock(TransactionLockTypes.LockType lockType, String pathPrefix) {
        return new SubTreeOpLock(lockType, pathPrefix);
    }

    public Lock getIndividualHashBucketLock(int storageId, int bucketId) {
        return new IndividualHashBucketLock(storageId, bucketId);
    }

    public Lock getLastBlockHashBucketsLock() {
        return new LastBlockReplicasHashBucketLock();
    }

    public Lock getRetryCacheEntryLock(byte[] clientId, int callId) {
        return new RetryCacheEntryLock(clientId, callId);
    }

    public Lock getRetryCacheEntryLock(List<RetryCache.CacheEntry> entries) {
        return new RetryCacheEntryLock(entries);
    }

    public Collection<Lock> getBlockRelated(BLK ... relatedBlks) {
        ArrayList<Lock> list = new ArrayList<Lock>();
        block10: for (BLK b : relatedBlks) {
            switch (b) {
                case RE: {
                    list.add(this.getReplicaLock());
                    continue block10;
                }
                case CR: {
                    list.add(this.getCorruptReplicaLock());
                    continue block10;
                }
                case IV: {
                    list.add(this.getInvalidatedBlockLock());
                    continue block10;
                }
                case PE: {
                    list.add(this.getPendingBlockLock());
                    continue block10;
                }
                case UC: {
                    list.add(this.getReplicatUnderConstructionLock());
                    continue block10;
                }
                case UR: {
                    list.add(this.getUnderReplicatedBlockLock());
                    continue block10;
                }
                case ER: {
                    list.add(this.getExcessReplicaLock());
                    continue block10;
                }
                case CA: {
                    list.add(this.getCachedBlockLock());
                }
            }
        }
        return list;
    }

    public Collection<Lock> getSqlBatchedBlocksRelated(BLK ... relatedBlks) {
        ArrayList<Lock> list = new ArrayList<Lock>();
        block10: for (BLK b : relatedBlks) {
            switch (b) {
                case RE: {
                    list.add(this.getSqlBatchedReplicasLock());
                    continue block10;
                }
                case CR: {
                    list.add(this.getSqlBatchedCorruptReplicasLock());
                    continue block10;
                }
                case IV: {
                    list.add(this.getSqlBatchedInvalidatedBlocksLock());
                    continue block10;
                }
                case PE: {
                    list.add(this.getSqlBatchedInvalidatedBlocksLock());
                    continue block10;
                }
                case UC: {
                    list.add(this.getSqlBatchedReplicasUnderConstructionLock());
                    continue block10;
                }
                case UR: {
                    list.add(this.getUnderReplicatedBlockLock());
                    continue block10;
                }
                case ER: {
                    list.add(this.getSqlBatchedExcessReplicasLock());
                    continue block10;
                }
                case CA: {
                    list.add(this.getSqlBatchedCachedBlockLock());
                }
            }
        }
        return list;
    }

    public Lock getLastTwoBlocksLock(String src) {
        return new LastTwoBlocksLock(src);
    }

    public Lock getAcesLock() {
        return new AcesLock();
    }

    public void setConfiguration(Configuration conf) {
        BaseINodeLock.enableSetPartitionKey(conf.getBoolean("dfs.ndb.setpartitionkey.enabled", true));
        BaseINodeLock.enableSetRandomPartitionKey(conf.getBoolean("dfs.ndb.setrandompartitionkey.enabled", true));
    }

    public Lock getCacheDirectiveLock(long id) {
        return new CacheDirectiveLock(id);
    }

    public Lock getCacheDirectiveLock(String poolName) {
        return new CacheDirectiveLock(poolName);
    }

    public Lock getCacheDirectiveLock(long id, String path, String pool, int maxNumResults) {
        return new CacheDirectiveLock(id, path, pool, maxNumResults);
    }

    public Lock getCachePoolLock(String poolName) {
        return new CachePoolLock(poolName);
    }

    public Lock getCachePoolsLock(List<String> poolNames) {
        return new CachePoolLock(poolNames);
    }

    public Lock getCachePoolLock(TransactionLockTypes.LockType lockType) {
        return new CachePoolLock(lockType);
    }

    public Lock getCachedBlockReportingLocks(List<Long> blockIds, DatanodeID datanodeId) {
        return new CachedBlockLock(blockIds, datanodeId);
    }

    public Lock getDatanodeCachedBlockLocks(DatanodeID datanodeId) {
        return new CachedBlockLock(datanodeId);
    }

    public Lock getAllCachedBlockLocks() {
        return new AllCachedBlockLock();
    }

    public static enum BLK {
        RE,
        CR,
        ER,
        UR,
        UC,
        IV,
        PE,
        CA;

    }
}

