/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.token.Token;

public class HAUtil {
    private static final Log LOG = LogFactory.getLog(HAUtil.class);
    private static final DelegationTokenSelector tokenSelector = new DelegationTokenSelector();

    private HAUtil() {
    }

    public static boolean isHAEnabled(Configuration conf, String nsId) {
        Map<String, Map<String, InetSocketAddress>> addresses = DFSUtil.getHaNnRpcAddresses(conf);
        if (addresses == null) {
            return false;
        }
        Map<String, InetSocketAddress> nnMap = addresses.get(nsId);
        return nnMap != null && nnMap.size() > 1;
    }

    public static String getNameNodeIdFromAddress(Configuration conf, InetSocketAddress address, String ... keys) {
        String[] ids = DFSUtil.getSuffixIDs(conf, address, keys);
        if (ids != null && ids.length > 1) {
            return ids[1];
        }
        return null;
    }

    public static boolean shouldAllowStandbyReads(Configuration conf) {
        return conf.getBoolean("dfs.ha.allow.stale.reads", false);
    }

    public static void setAllowStandbyReads(Configuration conf, boolean val) {
        conf.setBoolean("dfs.ha.allow.stale.reads", val);
    }

    public static boolean isLogicalUri(Configuration conf, URI nameNodeUri) {
        String host = nameNodeUri.getHost();
        String configKey = "dfs.client.failover.proxy.provider." + host;
        return conf.get(configKey) != null;
    }

    public static URI getServiceUriFromToken(Token<DelegationTokenIdentifier> token) throws IOException {
        String tokStr = token.getService().toString();
        if (tokStr.startsWith("ha-hdfs:")) {
            tokStr = tokStr.replaceFirst("ha-hdfs:", "");
        }
        try {
            return new URI("hdfs://" + tokStr);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid token contents: '" + tokStr + "'");
        }
    }

    public static Text buildTokenServiceForLogicalUri(URI uri) {
        return new Text("ha-hdfs:" + uri.getHost());
    }

    public static boolean isTokenForLogicalUri(Token<DelegationTokenIdentifier> token) {
        return token.getService().toString().startsWith("ha-hdfs:");
    }

    public static InetSocketAddress getAddressOfActive(FileSystem fs) throws IOException {
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("FileSystem " + fs + " is not a DFS.");
        }
        fs.exists(new Path("/"));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        DFSClient dfsClient = dfs.getClient();
        return RPC.getServerAddress((Object)dfsClient.getNamenode());
    }
}

