/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.HdfsVariables;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.datanode.BRLoadBalancingException;

public class BRTrackingService {
    private List workHistory = new LinkedList();
    public static final Log LOG = LogFactory.getLog(BRTrackingService.class);
    private final long DB_VAR_UPDATE_THRESHOLD;
    private final long BR_LB_TIME_WINDOW_SIZE;
    private int rrIndex = 0;
    private long lastChecked = 0L;
    private long cachedBrLbMaxBlkPerTW = -1L;

    public BRTrackingService(long DB_VAR_UPDATE_THRESHOLD, long BR_LB_TIME_WINDOW_SIZE) {
        this.DB_VAR_UPDATE_THRESHOLD = DB_VAR_UPDATE_THRESHOLD;
        this.BR_LB_TIME_WINDOW_SIZE = BR_LB_TIME_WINDOW_SIZE;
    }

    private int getRRIndex(SortedActiveNodeList nnList) {
        if (this.rrIndex < 0 || this.rrIndex >= nnList.size()) {
            this.rrIndex = 0;
        }
        return this.rrIndex++ % nnList.size();
    }

    private boolean canProcessMoreBR(long noOfBlks) throws IOException {
        long timePoint = System.currentTimeMillis() - this.BR_LB_TIME_WINDOW_SIZE;
        if (this.workHistory.size() > 0) {
            for (int i = this.workHistory.size() - 1; i >= 0; --i) {
                Work work = (Work)this.workHistory.get(i);
                if (work.getStartTime() > timePoint) continue;
                this.workHistory.remove(i);
                LOG.debug((Object)("Removing (" + work.getNoOfBlks() + " blks) from history. It was assigned to NN: " + work.getNNId()));
            }
        }
        long ongoingWork = 0L;
        if (this.workHistory.size() > 0) {
            for (int i = this.workHistory.size() - 1; i >= 0; --i) {
                Work work = (Work)this.workHistory.get(i);
                ongoingWork += work.getNoOfBlks();
            }
        }
        LOG.debug((Object)("Currently processing at " + ongoingWork + " blks /" + (double)this.BR_LB_TIME_WINDOW_SIZE / 1000.0 + " sec"));
        if (ongoingWork + noOfBlks > this.getBrLbMaxBlkPerTW(this.DB_VAR_UPDATE_THRESHOLD)) {
            LOG.info((Object)("Work (" + noOfBlks + " blks) can not be assigned, ongoing work: " + ongoingWork));
            return false;
        }
        return true;
    }

    private long getBrLbMaxBlkPerTW(long DB_VAR_UPDATE_THRESHOLD) throws IOException {
        if (System.currentTimeMillis() - this.lastChecked > DB_VAR_UPDATE_THRESHOLD) {
            long newValue = HdfsVariables.getBrLbMaxBlkPerTW();
            if (newValue != this.cachedBrLbMaxBlkPerTW) {
                this.cachedBrLbMaxBlkPerTW = newValue;
                LOG.info((Object)("BRTrackingService. Processing " + this.cachedBrLbMaxBlkPerTW + " per time window"));
            }
            this.lastChecked = System.currentTimeMillis();
        }
        return this.cachedBrLbMaxBlkPerTW;
    }

    public synchronized ActiveNode assignWork(SortedActiveNodeList nnList, long noOfBlks) throws IOException {
        int index;
        if (this.canProcessMoreBR(noOfBlks) && (index = this.getRRIndex(nnList)) >= 0 && index < nnList.size()) {
            ActiveNode an = (ActiveNode)nnList.getSortedActiveNodes().get(index);
            Work work = new Work(System.currentTimeMillis(), noOfBlks, an.getId());
            this.workHistory.add(work);
            LOG.info((Object)("Work (" + noOfBlks + " blks)  assigned to NN: " + an.getId()));
            return an;
        }
        throw new BRLoadBalancingException("Work (" + noOfBlks + " blks) could not be assigned. System is fully loaded now. At most " + this.getBrLbMaxBlkPerTW(this.DB_VAR_UPDATE_THRESHOLD) + " blocks can be processed per " + this.BR_LB_TIME_WINDOW_SIZE);
    }

    private class Work {
        private final long startTime;
        private final long noOfBlks;
        private final long nnId;

        public Work(long startTime, long noOfBlks, long nnId) {
            this.startTime = startTime;
            this.noOfBlks = noOfBlks;
            this.nnId = nnId;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getNoOfBlks() {
            return this.noOfBlks;
        }

        public long getNNId() {
            return this.nnId;
        }
    }
}

