/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.CorruptReplicaDataAccess;
import io.hops.metadata.hdfs.entity.CorruptReplica;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.Server;

@InterfaceAudience.Private
public class CorruptReplicasMap {
    private final DatanodeManager datanodeMgr;
    private static final Log LOG = LogFactory.getLog(CorruptReplicasMap.class);

    public CorruptReplicasMap(DatanodeManager datanodeMgr) {
        this.datanodeMgr = datanodeMgr;
    }

    public void addToCorruptReplicasMap(BlockInfo blk, DatanodeStorageInfo storage, String reason) throws StorageException, TransactionContextException {
        this.addToCorruptReplicasMap(blk, storage, reason, Reason.NONE);
    }

    public void addToCorruptReplicasMap(BlockInfo blk, DatanodeStorageInfo storage, String reason, Reason reasonCode) throws StorageException, TransactionContextException {
        Map<DatanodeDescriptor, Reason> nodes = this.getNodesMap(blk);
        String reasonText = reason != null ? " because " + reason : "";
        if (storage == null) {
            LOG.warn((Object)("Attempted to set block " + blk.getBlockId() + " as corrupt on non-existing storage (null)" + reason));
            return;
        }
        if (!nodes.keySet().contains(storage.getDatanodeDescriptor())) {
            NameNode.blockStateChangeLog.info((Object)("BLOCK NameSystem.addToCorruptReplicasMap: " + blk.getBlockName() + " added as corrupt on " + storage + " by " + Server.getRemoteIp() + reasonText));
        } else {
            NameNode.blockStateChangeLog.info((Object)("BLOCK NameSystem.addToCorruptReplicasMap: duplicate requested for " + blk.getBlockName() + " to add as corrupt on " + storage + " by " + Server.getRemoteIp() + reasonText));
        }
        this.addCorruptReplicaToDB(new CorruptReplica(storage.getSid(), blk.getBlockId(), blk.getInodeId(), reasonCode.name()));
    }

    void removeFromCorruptReplicasMap(BlockInfo blk) throws StorageException, TransactionContextException {
        Collection<CorruptReplica> corruptReplicas = this.getCorruptReplicas(blk);
        if (corruptReplicas != null) {
            for (CorruptReplica cr : corruptReplicas) {
                this.removeCorruptReplicaFromDB(cr);
            }
        }
    }

    boolean removeFromCorruptReplicasMap(BlockInfo blk, DatanodeDescriptor datanode) throws IOException {
        return this.removeFromCorruptReplicasMap(blk, datanode, Reason.ANY);
    }

    boolean removeFromCorruptReplicasMap(BlockInfo blk, DatanodeDescriptor datanode, Reason reason) throws StorageException, TransactionContextException {
        Collection<CorruptReplica> corruptReplicas = this.getCorruptReplicas(blk);
        Map<DatanodeDescriptor, Reason> datanodes = this.getNodesMap(corruptReplicas);
        if (datanodes == null) {
            return false;
        }
        Reason storedReason = datanodes.get(datanode);
        if (reason != Reason.ANY && storedReason != null && reason != storedReason) {
            return false;
        }
        if (datanodes.containsKey(datanode)) {
            HashSet<Integer> sids = new HashSet<Integer>();
            for (DatanodeStorageInfo storage : datanode.getStorageInfos()) {
                sids.add(storage.getSid());
            }
            for (CorruptReplica c : corruptReplicas) {
                if (!sids.contains(c.getStorageId())) continue;
                this.removeCorruptReplicaFromDB(new CorruptReplica(c.getStorageId(), blk.getBlockId(), blk.getInodeId(), c.getReason()));
            }
            return true;
        }
        return false;
    }

    void forceRemoveFromCorruptReplicasMap(BlockInfo blk, int sid) throws StorageException, TransactionContextException {
        Collection<CorruptReplica> corruptReplicas = this.getCorruptReplicas(blk);
        if (corruptReplicas == null) {
            return;
        }
        for (CorruptReplica c : corruptReplicas) {
            if (c.getStorageId() != sid) continue;
            this.removeCorruptReplicaFromDB(new CorruptReplica(c.getStorageId(), blk.getBlockId(), blk.getInodeId(), c.getReason()));
        }
    }

    Collection<DatanodeDescriptor> getNodes(BlockInfo blk) throws StorageException, TransactionContextException {
        if (this.datanodeMgr == null) {
            return new ArrayList<DatanodeDescriptor>();
        }
        Collection<CorruptReplica> corruptReplicas = this.getCorruptReplicas(blk);
        TreeSet<DatanodeDescriptor> dnds = new TreeSet<DatanodeDescriptor>();
        if (corruptReplicas != null) {
            for (CorruptReplica cr : corruptReplicas) {
                DatanodeDescriptor dn = this.datanodeMgr.getDatanodeBySid(cr.getStorageId());
                if (dn == null) continue;
                dnds.add(dn);
            }
        }
        return dnds;
    }

    Map<DatanodeDescriptor, Reason> getNodesMap(BlockInfo blk) throws StorageException, TransactionContextException {
        if (this.datanodeMgr == null) {
            return new TreeMap<DatanodeDescriptor, Reason>();
        }
        Collection<CorruptReplica> corruptReplicas = this.getCorruptReplicas(blk);
        return this.getNodesMap(corruptReplicas);
    }

    Map<DatanodeDescriptor, Reason> getNodesMap(Collection<CorruptReplica> corruptReplicas) throws StorageException, TransactionContextException {
        if (this.datanodeMgr == null) {
            return new TreeMap<DatanodeDescriptor, Reason>();
        }
        TreeMap<DatanodeDescriptor, Reason> dnds = new TreeMap<DatanodeDescriptor, Reason>();
        if (corruptReplicas != null) {
            for (CorruptReplica cr : corruptReplicas) {
                DatanodeDescriptor dn = this.datanodeMgr.getDatanodeBySid(cr.getStorageId());
                if (dn == null) continue;
                dnds.put(dn, Reason.valueOf(cr.getReason()));
            }
        }
        return dnds;
    }

    boolean isReplicaCorrupt(BlockInfo blk, DatanodeDescriptor node) throws StorageException, TransactionContextException {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        return nodes != null && nodes.contains(node);
    }

    public int numCorruptReplicas(BlockInfo blk) throws StorageException, TransactionContextException {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        return nodes == null ? 0 : nodes.size();
    }

    public int size() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.COUNT_CORRUPT_REPLICAS){

            public Object performTask() throws IOException {
                CorruptReplicaDataAccess da = (CorruptReplicaDataAccess)HdfsStorageFactory.getDataAccess(CorruptReplicaDataAccess.class);
                return da.countAllUniqueBlk();
            }
        }.handle();
    }

    long[] getCorruptReplicaBlockIds(int numExpectedBlocks, Long startingBlockId) throws IOException {
        if (numExpectedBlocks < 0 || numExpectedBlocks > 100) {
            return null;
        }
        ArrayList<Long> sortedIds = new ArrayList<Long>();
        Collection<CorruptReplica> corruptReplicas = this.getAllCorruptReplicas();
        if (corruptReplicas != null) {
            for (CorruptReplica replica : corruptReplicas) {
                sortedIds.add(replica.getBlockId());
            }
        }
        Iterator blockIt = sortedIds.iterator();
        if (startingBlockId != null) {
            boolean isBlockFound = false;
            while (blockIt.hasNext()) {
                Long bid = (Long)blockIt.next();
                if (bid != startingBlockId) continue;
                isBlockFound = true;
                break;
            }
            if (!isBlockFound) {
                return null;
            }
        }
        ArrayList corruptReplicaBlockIds = new ArrayList();
        for (int i = 0; i < numExpectedBlocks && blockIt.hasNext(); ++i) {
            corruptReplicaBlockIds.add(blockIt.next());
        }
        long[] ret = new long[corruptReplicaBlockIds.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Long)corruptReplicaBlockIds.get(i);
        }
        return ret;
    }

    private Collection<CorruptReplica> getCorruptReplicas(BlockInfo blk) throws StorageException, TransactionContextException {
        return EntityManager.findList((FinderType)CorruptReplica.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{blk.getBlockId(), blk.getInodeId()});
    }

    private Collection<CorruptReplica> getAllCorruptReplicas() throws IOException {
        return (Collection)new LightWeightRequestHandler(HDFSOperationType.GET_ALL_CORRUPT_REPLICAS){

            public Object performTask() throws IOException {
                CorruptReplicaDataAccess crDa = (CorruptReplicaDataAccess)HdfsStorageFactory.getDataAccess(CorruptReplicaDataAccess.class);
                return crDa.findAll();
            }
        }.handle();
    }

    private void addCorruptReplicaToDB(CorruptReplica cr) throws StorageException, TransactionContextException {
        EntityManager.add((Object)cr);
    }

    private void removeCorruptReplicaFromDB(CorruptReplica cr) throws StorageException, TransactionContextException {
        EntityManager.remove((Object)cr);
    }

    public static enum Reason {
        NONE,
        ANY,
        GENSTAMP_MISMATCH,
        SIZE_MISMATCH,
        INVALID_STATE,
        CORRUPTION_REPORTED;

    }
}

