/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.dal.InvalidateBlockDataAccess;
import io.hops.metadata.hdfs.dal.ReplicaDataAccess;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;

public class DatanodeStorageInfo {
    public static final DatanodeStorageInfo[] EMPTY_ARRAY = new DatanodeStorageInfo[0];
    private final DatanodeDescriptor dn;
    private final String storageID;
    private StorageType storageType;
    private DatanodeStorage.State state;
    private long capacity;
    private long dfsUsed;
    private volatile long remaining;
    private long blockPoolUsed;
    private int sid = -1;
    private int blockReportCount = 0;
    private boolean heartbeatedSinceFailover = false;
    private boolean blockContentsStale = true;

    public static StorageType[] toStorageTypes(DatanodeStorageInfo[] storages) {
        StorageType[] storageTypes = new StorageType[storages.length];
        for (int i = 0; i < storageTypes.length; ++i) {
            storageTypes[i] = storages[i].getStorageType();
        }
        return storageTypes;
    }

    static Iterable<StorageType> toStorageTypes(final Iterable<DatanodeStorageInfo> infos) {
        return new Iterable<StorageType>(){

            @Override
            public Iterator<StorageType> iterator() {
                return new Iterator<StorageType>(){
                    final Iterator<DatanodeStorageInfo> i;
                    {
                        this.i = infos.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public StorageType next() {
                        return this.i.next().getStorageType();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static String[] toStorageIDs(DatanodeStorageInfo[] storages) {
        String[] storageIDs = new String[storages.length];
        for (int i = 0; i < storageIDs.length; ++i) {
            storageIDs[i] = storages[i].getStorageID();
        }
        return storageIDs;
    }

    public static DatanodeInfo[] toDatanodeInfos(DatanodeStorageInfo[] storages) {
        return DatanodeStorageInfo.toDatanodeInfos(Arrays.asList(storages));
    }

    public static DatanodeInfo[] toDatanodeInfos(List<DatanodeStorageInfo> storages) {
        DatanodeInfo[] datanodes = new DatanodeInfo[storages.size()];
        for (int i = 0; i < storages.size(); ++i) {
            datanodes[i] = storages.get(i).getDatanodeDescriptor();
        }
        return datanodes;
    }

    static DatanodeDescriptor[] toDatanodeDescriptors(DatanodeStorageInfo[] storages) {
        DatanodeDescriptor[] datanodes = new DatanodeDescriptor[storages.length];
        for (int i = 0; i < storages.length; ++i) {
            datanodes[i] = storages[i].getDatanodeDescriptor();
        }
        return datanodes;
    }

    public DatanodeStorageInfo(DatanodeDescriptor dn, DatanodeStorage s) {
        this.dn = dn;
        this.storageID = s.getStorageID();
        this.storageType = s.getStorageType();
        this.state = s.getState();
    }

    int getBlockReportCount() {
        return this.blockReportCount;
    }

    void setBlockReportCount(int blockReportCount) {
        this.blockReportCount = blockReportCount;
    }

    boolean areBlockContentsStale() {
        return this.blockContentsStale;
    }

    void markStaleAfterFailover() {
        this.heartbeatedSinceFailover = false;
        this.blockContentsStale = true;
    }

    void receivedHeartbeat(StorageReport report) {
        this.updateState(report);
        this.heartbeatedSinceFailover = true;
    }

    void receivedBlockReport() {
        if (this.heartbeatedSinceFailover) {
            this.blockContentsStale = false;
        }
        ++this.blockReportCount;
    }

    @VisibleForTesting
    public void setUtilization(long capacity, long dfsUsed, long remaining) {
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.remaining = remaining;
    }

    public Iterator<BlockInfo> getBlockIterator() throws IOException {
        return this.getAllStorageBlockInfos().iterator();
    }

    private List<BlockInfo> getAllStorageBlockInfos() throws IOException {
        final int sid = this.sid;
        LightWeightRequestHandler findBlocksHandler = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_STORAGE_IDS){

            public Object performTask() throws StorageException, IOException {
                BlockInfoDataAccess da = (BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class);
                HdfsStorageFactory.getConnector().beginTransaction();
                List list = da.findBlockInfosByStorageId(sid);
                HdfsStorageFactory.getConnector().commit();
                return list;
            }
        };
        return (List)findBlocksHandler.handle();
    }

    public void setState(DatanodeStorage.State s) {
        this.state = s;
    }

    boolean areBlocksOnFailedStorage() throws IOException {
        return this.getState() == DatanodeStorage.State.FAILED && this.numBlocks() != 0;
    }

    public DatanodeStorage.State getState() {
        return this.state;
    }

    public String getStorageID() {
        return this.storageID;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public int getSid() {
        return this.sid;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getDfsUsed() {
        return this.dfsUsed;
    }

    public long getRemaining() {
        return this.remaining;
    }

    long getBlockPoolUsed() {
        return this.blockPoolUsed;
    }

    public void updateFromStorage(DatanodeStorage storage) {
        this.state = storage.getState();
        this.storageType = storage.getStorageType();
    }

    public boolean addBlock(BlockInfo b) throws TransactionContextException, StorageException {
        return b.addReplica(this);
    }

    public boolean removeBlock(BlockInfo b) throws TransactionContextException, StorageException {
        return b.removeReplica(this) != null;
    }

    public int numBlocks() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.COUNT_REPLICAS_ON_NODE){

            public Object performTask() throws StorageException, IOException {
                ReplicaDataAccess da = (ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class);
                return da.countAllReplicasForStorageId(DatanodeStorageInfo.this.getSid());
            }
        }.handle();
    }

    public void updateState(StorageReport r) {
        this.capacity = r.getCapacity();
        this.dfsUsed = r.getDfsUsed();
        this.remaining = r.getRemaining();
        this.blockPoolUsed = r.getBlockPoolUsed();
    }

    public DatanodeDescriptor getDatanodeDescriptor() {
        return this.dn;
    }

    public static void incrementBlocksScheduled(DatanodeStorageInfo ... storages) {
        for (DatanodeStorageInfo s : storages) {
            s.getDatanodeDescriptor().incrementBlocksScheduled(s.getStorageType());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DatanodeStorageInfo)) {
            return false;
        }
        DatanodeStorageInfo that = (DatanodeStorageInfo)obj;
        return this.storageID.equals(that.storageID);
    }

    public int hashCode() {
        return this.storageID.hashCode();
    }

    public String toString() {
        return this.getDatanodeDescriptor().toString() + "[" + (Object)((Object)this.storageType) + "]" + this.storageID + ":" + (Object)((Object)this.state);
    }

    StorageReport toStorageReport() {
        return new StorageReport(new DatanodeStorage(this.storageID, this.state, this.storageType), false, this.capacity, this.dfsUsed, this.remaining, this.blockPoolUsed);
    }

    public Map<Long, Integer> getAllStorageReplicas() throws IOException {
        LightWeightRequestHandler findBlocksHandler = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_STORAGE_BLOCKS_IDS){

            public Object performTask() throws StorageException, IOException {
                ReplicaDataAccess da = (ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class);
                return da.findBlockAndInodeIdsByStorageId(DatanodeStorageInfo.this.getSid());
            }
        };
        return (Map)findBlocksHandler.handle();
    }

    public Map<Long, Integer> getAllStorageReplicasInBuckets(final List<Integer> mismatchedBuckets) throws IOException {
        LightWeightRequestHandler findReplicasHandler = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_STORAGE_BLOCKS_IN_BUCKETS){

            public Object performTask() throws IOException {
                ReplicaDataAccess da = (ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class);
                return da.findBlockAndInodeIdsByStorageIdAndBucketIds(DatanodeStorageInfo.this.sid, mismatchedBuckets);
            }
        };
        return (Map)findReplicasHandler.handle();
    }

    public Map<Long, Long> getAllStorageInvalidatedReplicasWithGenStamp() throws IOException {
        LightWeightRequestHandler findBlocksHandler = new LightWeightRequestHandler(HDFSOperationType.GET_ALL_STORAGE_BLOCKS_IDS){

            public Object performTask() throws StorageException, IOException {
                InvalidateBlockDataAccess da = (InvalidateBlockDataAccess)HdfsStorageFactory.getDataAccess(InvalidateBlockDataAccess.class);
                return da.findInvalidatedBlockBySidUsingMySQLServer(DatanodeStorageInfo.this.getSid());
            }
        };
        return (Map)findBlocksHandler.handle();
    }

    @VisibleForTesting
    public void setUtilizationForTesting(long capacity, long dfsUsed, long remaining, long blockPoolUsed) {
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.remaining = remaining;
        this.blockPoolUsed = blockPoolUsed;
    }

    static DatanodeStorageInfo getDatanodeStorageInfo(Iterable<DatanodeStorageInfo> infos, DatanodeDescriptor datanode) {
        if (datanode == null) {
            return null;
        }
        for (DatanodeStorageInfo storage : infos) {
            if (storage.getDatanodeDescriptor() != datanode) continue;
            return storage;
        }
        return null;
    }
}

