/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.metadata.common.FinderType;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;

public class PendingBlockInfo {
    private long blockId;
    private int inodeId;
    private long timeStamp;
    private final List<String> targets;

    public PendingBlockInfo(long blockId, int inodeId, long timestamp, DatanodeDescriptor[] targets) {
        this.blockId = blockId;
        this.inodeId = inodeId;
        this.timeStamp = timestamp;
        this.targets = new ArrayList<String>();
        if (targets != null) {
            for (DatanodeDescriptor dn : targets) {
                this.targets.add(dn.getDatanodeUuid());
            }
        }
    }

    public PendingBlockInfo(long blockId, int inodeId, long timestamp, List<String> targets) {
        this.blockId = blockId;
        this.inodeId = inodeId;
        this.timeStamp = timestamp;
        this.targets = targets;
    }

    public PendingBlockInfo(long blockId, int inodeId, long timestamp, String target) {
        this.blockId = blockId;
        this.inodeId = inodeId;
        this.timeStamp = timestamp;
        this.targets = new ArrayList<String>();
        this.targets.add(target);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    void setTimeStamp(long timestamp) {
        this.timeStamp = timestamp;
    }

    void incrementReplicas(DatanodeDescriptor ... newTargets) {
        if (newTargets != null) {
            for (DatanodeDescriptor dn : newTargets) {
                this.targets.add(dn.getDatanodeUuid());
            }
        }
    }

    boolean decrementReplicas(DatanodeDescriptor dn) {
        return this.targets.remove(dn.getDatanodeUuid());
    }

    public int getNumReplicas() {
        return this.targets.size();
    }

    public long getBlockId() {
        return this.blockId;
    }

    public int getInodeId() {
        return this.inodeId;
    }

    public void setBlockId(long blockId) {
        this.blockId = blockId;
    }

    public void setInodeId(int inodeId) {
        this.inodeId = inodeId;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PendingBlockInfo)) {
            return false;
        }
        PendingBlockInfo other = (PendingBlockInfo)obj;
        return this.getBlockId() == other.getBlockId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (int)(this.blockId ^ this.blockId >>> 32);
        return hash;
    }

    public static enum Finder implements FinderType<PendingBlockInfo>
    {
        ByBlockIdAndINodeId,
        ByINodeId,
        ByINodeIds,
        All;


        public Class getType() {
            return PendingBlockInfo.class;
        }

        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByBlockIdAndINodeId: 
                case ByINodeId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case ByINodeIds: {
                    return FinderType.Annotation.BatchedPrunedIndexScan;
                }
                case All: {
                    return FinderType.Annotation.FullTable;
                }
            }
            throw new IllegalStateException();
        }
    }
}

