/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.Replica;
import java.util.Comparator;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;

public class ReplicaUnderConstruction
extends Replica {
    HdfsServerConstants.ReplicaState state;
    private boolean chosenAsPrimary;
    private long generationStamp;

    public ReplicaUnderConstruction(HdfsServerConstants.ReplicaState state, int storageId, long blockId, int inodeId, int bucketId, long genStamp) {
        this(state, storageId, blockId, inodeId, bucketId, false, genStamp);
    }

    public ReplicaUnderConstruction(HdfsServerConstants.ReplicaState state, int storageId, long blockId, int inodeId, int bucketId, boolean chosenAsPrimary, long generationStamp) {
        super(storageId, blockId, inodeId, bucketId);
        this.state = state;
        this.chosenAsPrimary = chosenAsPrimary;
        this.generationStamp = generationStamp;
    }

    public DatanodeStorageInfo getExpectedStorageLocation(DatanodeManager manager) {
        return manager.getStorage(this.getStorageId());
    }

    public HdfsServerConstants.ReplicaState getState() {
        return this.state;
    }

    public boolean getChosenAsPrimary() {
        return this.chosenAsPrimary;
    }

    public void setState(HdfsServerConstants.ReplicaState state) {
        this.state = state;
    }

    void setChosenAsPrimary(boolean chosenAsPrimary) throws TransactionContextException, StorageException {
        this.chosenAsPrimary = chosenAsPrimary;
    }

    public long getGenerationStamp() {
        return this.generationStamp;
    }

    public void setGenerationStamp(long generationStamp) {
        this.generationStamp = generationStamp;
    }

    public static enum Order implements Comparator<ReplicaUnderConstruction>
    {
        ByStorageId{

            @Override
            public int compare(ReplicaUnderConstruction o1, ReplicaUnderConstruction o2) {
                return Integer.valueOf(o1.getStorageId()).compareTo(o2.getStorageId());
            }
        };

    }

    public static enum Finder implements FinderType<ReplicaUnderConstruction>
    {
        ByBlockIdAndINodeId,
        ByINodeId,
        ByINodeIds;


        public Class getType() {
            return ReplicaUnderConstruction.class;
        }

        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByBlockIdAndINodeId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case ByINodeId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case ByINodeIds: {
                    return FinderType.Annotation.BatchedPrunedIndexScan;
                }
            }
            throw new IllegalStateException();
        }
    }
}

