/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.namenode.Lease;
import org.apache.hadoop.hdfs.server.namenode.MetaRecoveryContext;

@InterfaceAudience.Private
public final class HdfsServerConstants {
    public static int READ_TIMEOUT = 60000;
    public static int READ_TIMEOUT_EXTENSION = 5000;
    public static int WRITE_TIMEOUT = 480000;
    public static int WRITE_TIMEOUT_EXTENSION = 5000;
    public static final String NAMENODE_LEASE_HOLDER = "HDFS_NameNode";
    public static final int NAMENODE_LEASE_HOLDER_ID = Lease.getHolderId("HDFS_NameNode");
    public static final long NAMENODE_LEASE_RECHECK_INTERVAL = 2000L;

    private HdfsServerConstants() {
    }

    public static enum BlockUCState {
        COMPLETE,
        UNDER_CONSTRUCTION,
        UNDER_RECOVERY,
        COMMITTED;

    }

    public static enum ReplicaState {
        FINALIZED(0),
        RBW(1),
        RWR(2),
        RUR(3),
        TEMPORARY(4);

        private int value;

        private ReplicaState(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public static ReplicaState getState(int v) {
            return ReplicaState.values()[v];
        }

        public static ReplicaState read(DataInput in) throws IOException {
            return ReplicaState.values()[in.readByte()];
        }

        public void write(DataOutput out) throws IOException {
            out.writeByte(this.ordinal());
        }
    }

    public static enum NamenodeRole {
        NAMENODE("NameNode"),
        BACKUP("Backup Node"),
        CHECKPOINT("Checkpoint Node"),
        LEADER_NAMENODE("Leader Node"),
        SECONDARY("Secondary Node");

        private String description = null;

        private NamenodeRole(String arg) {
            this.description = arg;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum StartupOption {
        FORMAT("-format"),
        DROP_AND_CREATE_DB("-dropAndCreateDB"),
        SET_BLOCK_REPORT_PROCESS_SIZE("-setBlkRptProcessSize"),
        FORMAT_ALL("-formatAll"),
        CLUSTERID("-clusterid"),
        GENCLUSTERID("-genclusterid"),
        REGULAR("-regular"),
        BACKUP("-backup"),
        CHECKPOINT("-checkpoint"),
        UPGRADE("-upgrade"),
        ROLLBACK("-rollback"),
        FINALIZE("-finalize"),
        ROLLINGUPGRADE("-rollingUpgrade"),
        IMPORT("-importCheckpoint"),
        BOOTSTRAPSTANDBY("-bootstrapStandby"),
        INITIALIZESHAREDEDITS("-initializeSharedEdits"),
        RECOVER("-recover"),
        FORCE("-force"),
        NONINTERACTIVE("-nonInteractive");

        private static final Pattern ENUM_WITH_ROLLING_UPGRADE_OPTION;
        private final String name;
        private String clusterId = null;
        private RollingUpgradeStartupOption rollingUpgradeStartupOption;
        private boolean isForceFormat = false;
        private boolean isInteractiveFormat = true;
        private int force = 0;
        private long maxBlkReptProcessSize = 0L;

        private StartupOption(String arg) {
            this.name = arg;
        }

        public String getName() {
            return this.name;
        }

        public NamenodeRole toNodeRole() {
            switch (this) {
                case BACKUP: {
                    return NamenodeRole.BACKUP;
                }
                case CHECKPOINT: {
                    return NamenodeRole.CHECKPOINT;
                }
            }
            return NamenodeRole.NAMENODE;
        }

        public void setClusterId(String cid) {
            this.clusterId = cid;
        }

        public void setMaxBlkRptProcessSize(long maxBlkReptProcessSize) {
            this.maxBlkReptProcessSize = maxBlkReptProcessSize;
        }

        public long getMaxBlkRptProcessSize() {
            return this.maxBlkReptProcessSize;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setRollingUpgradeStartupOption(String opt) {
            Preconditions.checkState((this == ROLLINGUPGRADE ? 1 : 0) != 0);
            this.rollingUpgradeStartupOption = RollingUpgradeStartupOption.fromString(opt);
        }

        public RollingUpgradeStartupOption getRollingUpgradeStartupOption() {
            Preconditions.checkState((this == ROLLINGUPGRADE ? 1 : 0) != 0);
            return this.rollingUpgradeStartupOption;
        }

        public MetaRecoveryContext createRecoveryContext() {
            if (!this.name.equals(StartupOption.RECOVER.name)) {
                return null;
            }
            return new MetaRecoveryContext(this.force);
        }

        public void setForce(int force) {
            this.force = force;
        }

        public int getForce() {
            return this.force;
        }

        public boolean getForceFormat() {
            return this.isForceFormat;
        }

        public void setForceFormat(boolean force) {
            this.isForceFormat = force;
        }

        public boolean getInteractiveFormat() {
            return this.isInteractiveFormat;
        }

        public void setInteractiveFormat(boolean interactive) {
            this.isInteractiveFormat = interactive;
        }

        public String toString() {
            if (this == ROLLINGUPGRADE) {
                return super.toString() + "(" + (Object)((Object)this.getRollingUpgradeStartupOption()) + ")";
            }
            return super.toString();
        }

        public static StartupOption getEnum(String value) {
            Matcher matcher = ENUM_WITH_ROLLING_UPGRADE_OPTION.matcher(value);
            if (matcher.matches()) {
                StartupOption option = StartupOption.valueOf(matcher.group(1));
                option.setRollingUpgradeStartupOption(matcher.group(2));
                return option;
            }
            return StartupOption.valueOf(value);
        }

        static {
            ENUM_WITH_ROLLING_UPGRADE_OPTION = Pattern.compile("(\\w+)\\((\\w+)\\)");
        }
    }

    public static enum RollingUpgradeStartupOption {
        ROLLBACK,
        DOWNGRADE,
        STARTED;

        private static final RollingUpgradeStartupOption[] VALUES;

        public String getOptionString() {
            return StartupOption.ROLLINGUPGRADE.getName() + " " + this.name().toLowerCase();
        }

        public boolean matches(StartupOption option) {
            return option == StartupOption.ROLLINGUPGRADE && option.getRollingUpgradeStartupOption() == this;
        }

        static RollingUpgradeStartupOption fromString(String s) {
            for (RollingUpgradeStartupOption opt : VALUES) {
                if (!opt.name().equalsIgnoreCase(s)) continue;
                return opt;
            }
            throw new IllegalArgumentException("Failed to convert \"" + s + "\" to " + RollingUpgradeStartupOption.class.getSimpleName());
        }

        static {
            VALUES = RollingUpgradeStartupOption.values();
        }
    }

    public static enum NodeType {
        NAME_NODE,
        DATA_NODE,
        JOURNAL_NODE;

    }
}

