/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.io.nativeio.SharedFileDescriptorFactory;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.DomainSocketWatcher;

public class ShortCircuitRegistry {
    public static final Log LOG = LogFactory.getLog(ShortCircuitRegistry.class);
    private static final int SHM_LENGTH = 8192;
    private boolean enabled;
    private final SharedFileDescriptorFactory shmFactory;
    private final DomainSocketWatcher watcher;
    private final HashMap<ShortCircuitShm.ShmId, RegisteredShm> segments = new HashMap(0);
    private final HashMultimap<ExtendedBlockId, ShortCircuitShm.Slot> slots = HashMultimap.create((int)0, (int)1);

    public synchronized void removeShm(ShortCircuitShm shm) {
        RegisteredShm removedShm;
        if (LOG.isTraceEnabled()) {
            LOG.debug((Object)("removing shm " + shm));
        }
        Preconditions.checkState(((removedShm = this.segments.remove(shm.getShmId())) == shm ? 1 : 0) != 0, (Object)("failed to remove " + shm.getShmId()));
        ShortCircuitShm.SlotIterator iter = shm.slotIterator();
        while (iter.hasNext()) {
            ShortCircuitShm.Slot slot = (ShortCircuitShm.Slot)iter.next();
            boolean removed = this.slots.remove((Object)slot.getBlockId(), (Object)slot);
            Preconditions.checkState((boolean)removed);
            slot.makeInvalid();
        }
        shm.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortCircuitRegistry(Configuration conf) throws IOException {
        boolean enabled = false;
        SharedFileDescriptorFactory shmFactory = null;
        DomainSocketWatcher watcher = null;
        try {
            int interruptCheck = conf.getInt("dfs.short.circuit.shared.memory.watcher.interrupt.check.ms", 60000);
            if (interruptCheck <= 0) {
                throw new IOException("dfs.short.circuit.shared.memory.watcher.interrupt.check.ms was set to " + interruptCheck);
            }
            String[] shmPaths = conf.getTrimmedStrings("dfs.datanode.shared.file.descriptor.paths");
            if (shmPaths.length == 0) {
                shmPaths = "/dev/shm,/tmp".split(",");
            }
            shmFactory = SharedFileDescriptorFactory.create((String)"HadoopShortCircuitShm_", (String[])shmPaths);
            String dswLoadingFailure = DomainSocketWatcher.getLoadingFailureReason();
            if (dswLoadingFailure != null) {
                throw new IOException(dswLoadingFailure);
            }
            watcher = new DomainSocketWatcher(interruptCheck, "ShortCircuitRegistry");
            enabled = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("created new ShortCircuitRegistry with interruptCheck=" + interruptCheck + ", shmPath=" + shmFactory.getPath()));
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Disabling ShortCircuitRegistry", (Throwable)e);
            }
        }
        finally {
            this.enabled = enabled;
            this.shmFactory = shmFactory;
            this.watcher = watcher;
        }
    }

    public synchronized void processBlockMlockEvent(ExtendedBlockId blockId) {
        if (!this.enabled) {
            return;
        }
        Set affectedSlots = this.slots.get((Object)blockId);
        for (ShortCircuitShm.Slot slot : affectedSlots) {
            slot.makeAnchorable();
        }
    }

    public synchronized boolean processBlockMunlockRequest(ExtendedBlockId blockId) {
        if (!this.enabled) {
            return true;
        }
        boolean allowMunlock = true;
        Set affectedSlots = this.slots.get((Object)blockId);
        for (ShortCircuitShm.Slot slot : affectedSlots) {
            slot.makeUnanchorable();
            if (!slot.isAnchored()) continue;
            allowMunlock = false;
        }
        return allowMunlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NewShmInfo createNewMemorySegment(String clientName, DomainSocket sock) throws IOException {
        NewShmInfo info = null;
        RegisteredShm shm = null;
        ShortCircuitShm.ShmId shmId = null;
        ShortCircuitRegistry shortCircuitRegistry = this;
        synchronized (shortCircuitRegistry) {
            FileInputStream fis;
            block9: {
                if (!this.enabled) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"createNewMemorySegment: ShortCircuitRegistry is not enabled.");
                    }
                    throw new UnsupportedOperationException();
                }
                fis = null;
                try {
                    while (this.segments.containsKey(shmId = ShortCircuitShm.ShmId.createRandom())) {
                    }
                    fis = this.shmFactory.createDescriptor(clientName, 8192);
                    shm = new RegisteredShm(shmId, fis, this);
                    if (shm != null) break block9;
                }
                catch (Throwable throwable) {
                    if (shm == null) {
                        IOUtils.closeQuietly(fis);
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            info = new NewShmInfo(shmId, fis);
            this.segments.put(shmId, shm);
        }
        this.watcher.add(sock, (DomainSocketWatcher.Handler)shm);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("createNewMemorySegment: created " + info.shmId));
        }
        return info;
    }

    public synchronized void registerSlot(ExtendedBlockId blockId, ShortCircuitShm.SlotId slotId, boolean isCached) throws InvalidRequestException {
        if (!this.enabled) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this + " can't register a slot because the ShortCircuitRegistry is not enabled."));
            }
            throw new UnsupportedOperationException();
        }
        ShortCircuitShm.ShmId shmId = slotId.getShmId();
        RegisteredShm shm = this.segments.get(shmId);
        if (shm == null) {
            throw new InvalidRequestException("there is no shared memory segment registered with shmId " + shmId);
        }
        ShortCircuitShm.Slot slot = shm.registerSlot(slotId.getSlotIdx(), blockId);
        if (isCached) {
            slot.makeAnchorable();
        } else {
            slot.makeUnanchorable();
        }
        boolean added = this.slots.put((Object)blockId, (Object)slot);
        Preconditions.checkState((boolean)added);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + ": registered " + blockId + " with slot " + slotId + " (isCached=" + isCached + ")"));
        }
    }

    public synchronized void unregisterSlot(ShortCircuitShm.SlotId slotId) throws InvalidRequestException {
        if (!this.enabled) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"unregisterSlot: ShortCircuitRegistry is not enabled.");
            }
            throw new UnsupportedOperationException();
        }
        ShortCircuitShm.ShmId shmId = slotId.getShmId();
        RegisteredShm shm = this.segments.get(shmId);
        if (shm == null) {
            throw new InvalidRequestException("there is no shared memory segment registered with shmId " + shmId);
        }
        ShortCircuitShm.Slot slot = shm.getSlot(slotId.getSlotIdx());
        slot.makeInvalid();
        shm.unregisterSlot(slotId.getSlotIdx());
        this.slots.remove((Object)slot.getBlockId(), (Object)slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ShortCircuitRegistry shortCircuitRegistry = this;
        synchronized (shortCircuitRegistry) {
            if (!this.enabled) {
                return;
            }
            this.enabled = false;
        }
        IOUtils.closeQuietly((Closeable)this.watcher);
    }

    public static class NewShmInfo
    implements Closeable {
        public final ShortCircuitShm.ShmId shmId;
        public final FileInputStream stream;

        NewShmInfo(ShortCircuitShm.ShmId shmId, FileInputStream stream) {
            this.shmId = shmId;
            this.stream = stream;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }

    private static class RegisteredShm
    extends ShortCircuitShm
    implements DomainSocketWatcher.Handler {
        private final ShortCircuitRegistry registry;

        RegisteredShm(ShortCircuitShm.ShmId shmId, FileInputStream stream, ShortCircuitRegistry registry) throws IOException {
            super(shmId, stream);
            this.registry = registry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handle(DomainSocket sock) {
            ShortCircuitRegistry shortCircuitRegistry = this.registry;
            synchronized (shortCircuitRegistry) {
                RegisteredShm registeredShm = this;
                synchronized (registeredShm) {
                    this.registry.removeShm(this);
                }
            }
            return true;
        }
    }
}

