/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.EntityManager;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.CacheDirective;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolStats;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public final class CachePool {
    @Nonnull
    private final String poolName;
    @Nonnull
    private String ownerName;
    @Nonnull
    private String groupName;
    @Nonnull
    private FsPermission mode;
    private long limit;
    private long maxRelativeExpiryMs;
    private long bytesNeeded;
    private long bytesCached;
    private long filesNeeded;
    private long filesCached;

    static CachePool createFromInfoAndDefaults(CachePoolInfo info) throws IOException {
        String groupName;
        UserGroupInformation ugi = null;
        String ownerName = info.getOwnerName();
        if (ownerName == null) {
            if (ugi == null) {
                ugi = NameNode.getRemoteUser();
            }
            ownerName = ugi.getShortUserName();
        }
        if ((groupName = info.getGroupName()) == null) {
            if (ugi == null) {
                ugi = NameNode.getRemoteUser();
            }
            groupName = ugi.getPrimaryGroupName();
        }
        FsPermission mode = info.getMode() == null ? FsPermission.getCachePoolDefault() : info.getMode();
        long limit = info.getLimit() == null ? Long.MAX_VALUE : info.getLimit();
        long maxRelativeExpiry = info.getMaxRelativeExpiryMs() == null ? 0x1FFFFFFFFFFFFFFFL : info.getMaxRelativeExpiryMs();
        return new CachePool(info.getPoolName(), ownerName, groupName, mode, limit, maxRelativeExpiry);
    }

    static CachePool createFromInfo(CachePoolInfo info) {
        return new CachePool(info.getPoolName(), info.getOwnerName(), info.getGroupName(), info.getMode(), info.getLimit(), info.getMaxRelativeExpiryMs());
    }

    CachePool(String poolName, String ownerName, String groupName, FsPermission mode, long limit, long maxRelativeExpiry) {
        Preconditions.checkNotNull((Object)poolName);
        Preconditions.checkNotNull((Object)ownerName);
        Preconditions.checkNotNull((Object)groupName);
        Preconditions.checkNotNull((Object)mode);
        this.poolName = poolName;
        this.ownerName = ownerName;
        this.groupName = groupName;
        this.mode = new FsPermission(mode);
        this.limit = limit;
        this.maxRelativeExpiryMs = maxRelativeExpiry;
    }

    public CachePool(String poolName, String ownerName, String groupName, FsPermission mode, long limit, long maxRelativeExpiry, long bytesNeeded, long bytesCached, long filesNeeded, long filesCached) {
        this.poolName = poolName;
        this.ownerName = ownerName;
        this.groupName = groupName;
        this.mode = mode;
        this.limit = limit;
        this.maxRelativeExpiryMs = maxRelativeExpiry;
        this.bytesNeeded = bytesNeeded;
        this.bytesCached = bytesCached;
        this.filesNeeded = filesNeeded;
        this.filesCached = filesCached;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public CachePool setOwnerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public CachePool setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public FsPermission getMode() {
        return this.mode;
    }

    public CachePool setMode(FsPermission mode) {
        this.mode = new FsPermission(mode);
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public CachePool setLimit(long bytes) {
        this.limit = bytes;
        return this;
    }

    public long getMaxRelativeExpiryMs() {
        return this.maxRelativeExpiryMs;
    }

    public CachePool setMaxRelativeExpiryMs(long expiry) {
        this.maxRelativeExpiryMs = expiry;
        return this;
    }

    CachePoolInfo getInfo(boolean fullInfo) {
        CachePoolInfo info = new CachePoolInfo(this.poolName);
        if (!fullInfo) {
            return info;
        }
        return info.setOwnerName(this.ownerName).setGroupName(this.groupName).setMode(new FsPermission(this.mode)).setLimit(this.limit).setMaxRelativeExpiryMs(this.maxRelativeExpiryMs);
    }

    public void resetStatistics() throws TransactionContextException, StorageException {
        this.bytesNeeded = 0L;
        this.bytesCached = 0L;
        this.filesNeeded = 0L;
        this.filesCached = 0L;
        this.save();
    }

    public void addBytesNeeded(long bytes) {
        this.bytesNeeded += bytes;
    }

    public void addBytesCached(long bytes) {
        this.bytesCached += bytes;
    }

    public void addFilesNeeded(long files) {
        this.filesNeeded += files;
    }

    public void addFilesCached(long files) {
        this.filesCached += files;
    }

    public long getBytesNeeded() {
        return this.bytesNeeded;
    }

    public long getBytesCached() {
        return this.bytesCached;
    }

    public long getBytesOverlimit() {
        return Math.max(this.bytesNeeded - this.limit, 0L);
    }

    public long getFilesNeeded() {
        return this.filesNeeded;
    }

    public long getFilesCached() {
        return this.filesCached;
    }

    private CachePoolStats getStats() {
        return new CachePoolStats.Builder().setBytesNeeded(this.bytesNeeded).setBytesCached(this.bytesCached).setBytesOverlimit(this.getBytesOverlimit()).setFilesNeeded(this.filesNeeded).setFilesCached(this.filesCached).build();
    }

    public CachePoolEntry getEntry(FSPermissionChecker pc) {
        boolean hasPermission = true;
        if (pc != null) {
            try {
                pc.checkPermission(this, FsAction.READ);
            }
            catch (AccessControlException e) {
                hasPermission = false;
            }
        }
        return new CachePoolEntry(this.getInfo(hasPermission), hasPermission ? this.getStats() : new CachePoolStats.Builder().build());
    }

    public String toString() {
        return "{ " + "poolName:" + this.poolName + ", ownerName:" + this.ownerName + ", groupName:" + this.groupName + ", mode:" + this.mode + ", limit:" + this.limit + ", maxRelativeExpiryMs:" + this.maxRelativeExpiryMs + " }";
    }

    public List<CacheDirective> getDirectiveList() throws TransactionContextException, StorageException {
        return (List)EntityManager.findList((FinderType)CacheDirective.Finder.ByPoolName, (Object[])new Object[]{this.poolName});
    }

    public void save() throws TransactionContextException, StorageException {
        EntityManager.update((Object)this);
    }

    public static enum Finder implements FinderType<CachePool>
    {
        ByName,
        All;


        public Class getType() {
            return CachePool.class;
        }

        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByName: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case All: {
                    return FinderType.Annotation.FullTable;
                }
            }
            throw new IllegalStateException();
        }
    }
}

