/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.EntityManager;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Quota;

public class DirectoryWithQuotaFeature
implements INode.Feature {
    public DirectoryWithQuotaFeature() {
    }

    DirectoryWithQuotaFeature(INodeDirectory dir, long nsQuota, long nsCount, long dsQuota, long dsCount) throws StorageException, TransactionContextException {
        this.createINodeAttributes(dir, nsQuota, nsCount, dsQuota, dsCount);
        this.setQuota(dir, nsQuota, dsQuota);
    }

    Quota.Counts getQuota(INodeDirectory dir) throws StorageException, TransactionContextException {
        return this.getINodeAttributes(dir).getQuotaCounts();
    }

    void setQuota(INodeDirectory dir, Long nsQuota, Long dsQuota) throws StorageException, TransactionContextException {
        this.getINodeAttributes(dir).setNsQuota(nsQuota);
        this.getINodeAttributes(dir).setDsQuota(dsQuota);
    }

    Quota.Counts addNamespaceDiskspace(INodeDirectory dir, Quota.Counts counts) throws StorageException, TransactionContextException {
        INodeAttributes iNodeAttributes = this.getINodeAttributes(dir);
        counts.add(Quota.NAMESPACE, iNodeAttributes.getNsCount());
        counts.add(Quota.DISKSPACE, iNodeAttributes.getDiskspace());
        return counts;
    }

    INode.DirCounts spaceConsumedInTree(INodeDirectory dir, INode.DirCounts counts) throws StorageException, TransactionContextException {
        counts.nsCount += this.getINodeAttributes(dir).getNsCount().longValue();
        counts.dsCount += this.getINodeAttributes(dir).getDiskspace().longValue();
        return counts;
    }

    ContentSummaryComputationContext computeContentSummary(INodeDirectory dir, ContentSummaryComputationContext summary) throws StorageException, TransactionContextException {
        long original = summary.getCounts().get(Content.DISKSPACE);
        long oldYieldCount = summary.getYieldCount();
        dir.computeDirectoryContentSummary(summary);
        if (oldYieldCount == summary.getYieldCount()) {
            this.checkDiskspace(dir, summary.getCounts().get(Content.DISKSPACE) - original);
        }
        return summary;
    }

    private void checkDiskspace(INodeDirectory dir, long computed) throws StorageException, TransactionContextException {
        long diskspace = this.diskspaceConsumed(dir);
        if (-1L != this.getQuota(dir).get(Quota.DISKSPACE) && diskspace != computed) {
            NameNode.LOG.error((Object)("BUG: Inconsistent diskspace for directory " + dir.getFullPathName() + ". Cached = " + diskspace + " != Computed = " + computed));
        }
    }

    Long numItemsInTree(INodeDirectory dir) throws StorageException, TransactionContextException {
        return this.getINodeAttributes(dir).getNsCount();
    }

    Long diskspaceConsumed(INodeDirectory dir) throws StorageException, TransactionContextException {
        return this.getINodeAttributes(dir).getDiskspace();
    }

    void addSpaceConsumed(INodeDirectory dir, Long nsDelta, Long dsDelta) throws StorageException, TransactionContextException {
        if (dir.isQuotaSet()) {
            this.setSpaceConsumed(dir, this.getINodeAttributes(dir).getNsCount() + nsDelta, this.getINodeAttributes(dir).getDiskspace() + dsDelta);
        }
    }

    void setSpaceConsumed(INodeDirectory dir, Long namespace, Long diskspace) throws StorageException, TransactionContextException {
        this.getINodeAttributes(dir).setNsCount(namespace);
        this.getINodeAttributes(dir).setDiskspace(diskspace);
    }

    public Quota.Counts getSpaceConsumed(INodeDirectory dir) throws StorageException, TransactionContextException {
        INodeAttributes iNodeAttributes = this.getINodeAttributes(dir);
        return Quota.Counts.newInstance(iNodeAttributes.getNsCount(), iNodeAttributes.getDiskspace());
    }

    void setSpaceConsumedNoPersistance(INodeDirectory dir, Long namespace, Long diskSpace) throws StorageException, TransactionContextException {
        this.getINodeAttributes(dir).setNsCountNoPersistance(namespace);
        this.getINodeAttributes(dir).setDiskspaceNoPersistance(diskSpace);
    }

    void verifyQuota(INodeDirectory dir, Long nsDelta, Long dsDelta) throws QuotaExceededException, StorageException, TransactionContextException {
        INodeAttributes iNodeAttributes = this.getINodeAttributes(dir);
        Quota.Counts counts = this.getQuota(dir);
        this.verifyNamespaceQuota(iNodeAttributes, counts, nsDelta);
        this.verifyDiskspaceQuota(iNodeAttributes, counts, dsDelta);
    }

    private void verifyNamespaceQuota(INodeAttributes iNodeAttributes, Quota.Counts counts, Long nsDelta) throws NSQuotaExceededException {
        Long newNamespace = iNodeAttributes.getNsCount() + nsDelta;
        Long namespace = counts.get(Quota.NAMESPACE);
        if (namespace >= 0L && namespace < newNamespace) {
            throw new NSQuotaExceededException(namespace, newNamespace);
        }
    }

    private void verifyDiskspaceQuota(INodeAttributes iNodeAttributes, Quota.Counts counts, Long dsDelta) throws DSQuotaExceededException {
        Long newDiskspace = iNodeAttributes.getDiskspace() + dsDelta;
        Long diskSpace = counts.get(Quota.DISKSPACE);
        if (diskSpace >= 0L && diskSpace < newDiskspace) {
            throw new DSQuotaExceededException(diskSpace, newDiskspace);
        }
    }

    public INodeAttributes getINodeAttributes(INodeDirectory dir) throws StorageException, TransactionContextException {
        return (INodeAttributes)EntityManager.find((FinderType)INodeAttributes.Finder.ByINodeId, (Object[])new Object[]{dir.getId()});
    }

    private void createINodeAttributes(INodeDirectory dir, Long nsQuota, Long nameSpace, Long dsQuota, Long diskSpace) throws StorageException, TransactionContextException {
        INodeAttributes iNodeAttributes = new INodeAttributes(dir.getId(), dir.isInTree(), nsQuota, nameSpace, dsQuota, diskSpace);
        EntityManager.add((Object)iNodeAttributes);
    }

    void removeAttributes(INodeDirectory dir) throws StorageException, TransactionContextException {
        INodeAttributes iNodeAttributes = this.getINodeAttributes(dir);
        if (iNodeAttributes != null) {
            iNodeAttributes.removeAttributes();
        }
    }

    void changeAttributesPkNoPersistance(INodeDirectory dir, Integer id, boolean inTree) throws StorageException, TransactionContextException {
        this.getINodeAttributes(dir).setInodeIdNoPersistance(id, inTree);
    }
}

