/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.EntityManager;
import org.apache.hadoop.hdfs.server.namenode.Quota;

public class INodeAttributes {
    private Integer inodeId;
    private boolean inTree;
    private Long nsQuota;
    private Long nsCount;
    private Long dsQuota;
    private Long diskspace;

    public INodeAttributes(Integer inodeId, Long nsQuota, Long nsCount, Long dsQuota, Long diskspace) {
        this(inodeId, true, nsQuota, nsCount, dsQuota, diskspace);
    }

    public INodeAttributes(Integer inodeId, boolean inTree, Long nsQuota, Long nsCount, Long dsQuota, Long diskspace) {
        this.inodeId = inodeId;
        this.inTree = inTree;
        this.nsQuota = nsQuota != null ? nsQuota : Long.valueOf(-1L);
        this.nsCount = nsCount != null ? nsCount : Long.valueOf(1L);
        this.dsQuota = dsQuota != null ? dsQuota : Long.valueOf(Long.MAX_VALUE);
        if (diskspace == null) {
            throw new IllegalStateException("default value for diskspace is not defined");
        }
        this.diskspace = diskspace;
    }

    public Integer getInodeId() {
        return this.inodeId;
    }

    public boolean isInTree() {
        return this.inTree;
    }

    public Long getNsCount() {
        return this.nsCount;
    }

    public Quota.Counts getQuotaCounts() {
        return Quota.Counts.newInstance(this.nsQuota, this.dsQuota);
    }

    public Long getDiskspace() {
        return this.diskspace;
    }

    public void setInodeId(Integer inodeId, boolean inTree) throws StorageException, TransactionContextException {
        this.setInodeIdNoPersistance(inodeId, inTree);
        this.saveAttributes();
    }

    public void setNsQuota(Long nsQuota) throws StorageException, TransactionContextException {
        this.setNsQuotaNoPersistance(nsQuota);
        this.saveAttributes();
    }

    public void setNsCount(Long nsCount) throws StorageException, TransactionContextException {
        this.setNsCountNoPersistance(nsCount);
        this.saveAttributes();
    }

    public void setDsQuota(Long dsQuota) throws StorageException, TransactionContextException {
        this.setDsQuotaNoPersistance(dsQuota);
        this.saveAttributes();
    }

    public void setDiskspace(Long diskspace) throws StorageException, TransactionContextException {
        this.setDiskspaceNoPersistance(diskspace);
        this.saveAttributes();
    }

    public void setNsQuotaNoPersistance(Long nsQuota) {
        this.nsQuota = nsQuota;
    }

    public void setNsCountNoPersistance(Long nsCount) {
        this.nsCount = nsCount;
    }

    public void setDsQuotaNoPersistance(Long dsQuota) {
        this.dsQuota = dsQuota;
    }

    public void setDiskspaceNoPersistance(Long diskspace) {
        this.diskspace = diskspace;
    }

    public void setInodeIdNoPersistance(Integer inodeId, boolean inTree) {
        this.inodeId = inodeId;
        this.inTree = inTree;
    }

    protected void saveAttributes() throws StorageException, TransactionContextException {
        EntityManager.update((Object)this);
    }

    protected void removeAttributes() throws StorageException, TransactionContextException {
        EntityManager.remove((Object)this);
    }

    public static enum Finder implements FinderType<INodeAttributes>
    {
        ByINodeId,
        ByINodeIds;


        public Class getType() {
            return INodeAttributes.class;
        }

        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByINodeId: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByINodeIds: {
                    return FinderType.Annotation.Batched;
                }
            }
            throw new IllegalStateException();
        }
    }
}

