/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class MetaRecoveryContext {
    public static final Log LOG = LogFactory.getLog((String)MetaRecoveryContext.class.getName());
    public static final int FORCE_NONE = 0;
    public static final int FORCE_FIRST_CHOICE = 1;
    public static final int FORCE_ALL = 2;
    private int force;

    public MetaRecoveryContext(int force) {
        this.force = force;
    }

    public String ask(String prompt, String firstChoice, String ... choices) throws IOException {
        while (true) {
            int c;
            LOG.info((Object)prompt);
            if (this.force > 0) {
                LOG.info((Object)("automatically choosing " + firstChoice));
                return firstChoice;
            }
            StringBuilder responseBuilder = new StringBuilder();
            while ((c = System.in.read()) != -1 && c != 13 && c != 10) {
                responseBuilder.append((char)c);
            }
            String response = responseBuilder.toString();
            if (response.equalsIgnoreCase(firstChoice)) {
                return firstChoice;
            }
            for (String c2 : choices) {
                if (!response.equalsIgnoreCase(c2)) continue;
                return c2;
            }
            LOG.error((Object)"I'm sorry, I cannot understand your response.\n");
        }
    }

    public static void editLogLoaderPrompt(String prompt, MetaRecoveryContext recovery, String contStr) throws IOException, RequestStopException {
        if (recovery == null) {
            throw new IOException(prompt);
        }
        LOG.error((Object)prompt);
        String answer = recovery.ask("\nEnter 'c' to continue, " + contStr + "\nEnter 's' to stop reading the edit log here, abandoning any later edits\nEnter 'q' to quit without saving\nEnter 'a' to always select the first choice in the future without prompting. (c/s/q/a)\n", "c", "s", "q", "a");
        if (answer.equals("c")) {
            LOG.info((Object)"Continuing");
            return;
        }
        if (answer.equals("s")) {
            throw new RequestStopException("user requested stop");
        }
        if (!answer.equals("q")) {
            recovery.setForce(1);
            return;
        }
        recovery.quit();
    }

    public void quit() {
        LOG.error((Object)"Exiting on user request.");
        System.exit(0);
    }

    public int getForce() {
        return this.force;
    }

    public void setForce(int force) {
        this.force = force;
    }

    public static class RequestStopException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public RequestStopException(String msg) {
            super(msg);
        }
    }
}

