/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingService;
import io.hops.exception.ForeignKeyConstraintViolationException;
import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.security.Users;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastUpdatedContentSummary;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.NodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.security.proto.RefreshAuthorizationPolicyProtocolProtos;
import org.apache.hadoop.security.proto.RefreshUserMappingsProtocolProtos;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.tools.proto.GetUserMappingsProtocolProtos;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolPB;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;

class NameNodeRpcServer
implements NamenodeProtocols {
    private static final Log LOG = NameNode.LOG;
    private static final Log stateChangeLog = NameNode.stateChangeLog;
    private static final Log blockStateChangeLog = NameNode.blockStateChangeLog;
    protected final FSNamesystem namesystem;
    protected final NameNode nn;
    private final NameNodeMetrics metrics;
    private final boolean serviceAuthEnabled;
    private final RPC.Server serviceRpcServer;
    private final InetSocketAddress serviceRPCAddress;
    protected final RPC.Server clientRpcServer;
    protected final InetSocketAddress clientRpcAddress;
    private final String minimumDataNodeVersion;

    public NameNodeRpcServer(Configuration conf, NameNode nn) throws IOException {
        InetSocketAddress listenAddr;
        this.nn = nn;
        this.namesystem = nn.getNamesystem();
        this.metrics = NameNode.getNameNodeMetrics();
        int handlerCount = conf.getInt("dfs.namenode.handler.count", 10);
        RPC.setProtocolEngine((Configuration)conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine.class);
        ClientNamenodeProtocolServerSideTranslatorPB clientProtocolServerTranslator = new ClientNamenodeProtocolServerSideTranslatorPB(this);
        BlockingService clientNNPbService = ClientNamenodeProtocolProtos.ClientNamenodeProtocol.newReflectiveBlockingService(clientProtocolServerTranslator);
        DatanodeProtocolServerSideTranslatorPB dnProtoPbTranslator = new DatanodeProtocolServerSideTranslatorPB(this);
        BlockingService dnProtoPbService = DatanodeProtocolProtos.DatanodeProtocolService.newReflectiveBlockingService(dnProtoPbTranslator);
        NamenodeProtocolServerSideTranslatorPB namenodeProtocolXlator = new NamenodeProtocolServerSideTranslatorPB(this);
        BlockingService NNPbService = NamenodeProtocolProtos.NamenodeProtocolService.newReflectiveBlockingService(namenodeProtocolXlator);
        RefreshAuthorizationPolicyProtocolServerSideTranslatorPB refreshAuthPolicyXlator = new RefreshAuthorizationPolicyProtocolServerSideTranslatorPB((RefreshAuthorizationPolicyProtocol)this);
        BlockingService refreshAuthService = RefreshAuthorizationPolicyProtocolProtos.RefreshAuthorizationPolicyProtocolService.newReflectiveBlockingService((RefreshAuthorizationPolicyProtocolProtos.RefreshAuthorizationPolicyProtocolService.BlockingInterface)refreshAuthPolicyXlator);
        RefreshUserMappingsProtocolServerSideTranslatorPB refreshUserMappingXlator = new RefreshUserMappingsProtocolServerSideTranslatorPB((RefreshUserMappingsProtocol)this);
        BlockingService refreshUserMappingService = RefreshUserMappingsProtocolProtos.RefreshUserMappingsProtocolService.newReflectiveBlockingService((RefreshUserMappingsProtocolProtos.RefreshUserMappingsProtocolService.BlockingInterface)refreshUserMappingXlator);
        GetUserMappingsProtocolServerSideTranslatorPB getUserMappingXlator = new GetUserMappingsProtocolServerSideTranslatorPB((GetUserMappingsProtocol)this);
        BlockingService getUserMappingService = GetUserMappingsProtocolProtos.GetUserMappingsProtocolService.newReflectiveBlockingService((GetUserMappingsProtocolProtos.GetUserMappingsProtocolService.BlockingInterface)getUserMappingXlator);
        WritableRpcEngine.ensureInitialized();
        InetSocketAddress serviceRpcAddr = nn.getServiceRpcServerAddress(conf);
        if (serviceRpcAddr != null) {
            String bindHost = nn.getServiceRpcServerBindHost(conf);
            if (bindHost == null) {
                bindHost = serviceRpcAddr.getHostName();
            }
            LOG.info((Object)("Service RPC server is binding to " + bindHost + ":" + serviceRpcAddr.getPort()));
            int serviceHandlerCount = conf.getInt("dfs.namenode.service.handler.count", 10);
            this.serviceRpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance((Object)clientNNPbService).setBindAddress(bindHost).setPort(serviceRpcAddr.getPort()).setNumHandlers(serviceHandlerCount).setVerbose(false).setSecretManager((SecretManager)this.namesystem.getDelegationTokenSecretManager()).build();
            DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.serviceRpcServer);
            listenAddr = this.serviceRpcServer.getListenerAddress();
            this.serviceRPCAddress = new InetSocketAddress(serviceRpcAddr.getHostName(), listenAddr.getPort());
            this.serviceRpcServer.setThreadNamePrefix("Service");
            nn.setRpcServiceServerAddress(conf, this.serviceRPCAddress);
        } else {
            this.serviceRpcServer = null;
            this.serviceRPCAddress = null;
        }
        InetSocketAddress rpcAddr = nn.getRpcServerAddress(conf);
        String bindHost = nn.getRpcServerBindHost(conf);
        if (bindHost == null) {
            bindHost = rpcAddr.getHostName();
        }
        LOG.info((Object)("RPC server is binding to " + bindHost + ":" + rpcAddr.getPort()));
        this.clientRpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance((Object)clientNNPbService).setBindAddress(bindHost).setPort(rpcAddr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager((SecretManager)this.namesystem.getDelegationTokenSecretManager()).build();
        DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.clientRpcServer);
        this.serviceAuthEnabled = conf.getBoolean("hadoop.security.authorization", false);
        if (this.serviceAuthEnabled) {
            this.clientRpcServer.refreshServiceAcl(conf, (PolicyProvider)new HDFSPolicyProvider());
            if (this.serviceRpcServer != null) {
                this.serviceRpcServer.refreshServiceAcl(conf, (PolicyProvider)new HDFSPolicyProvider());
            }
        }
        listenAddr = this.clientRpcServer.getListenerAddress();
        this.clientRpcAddress = new InetSocketAddress(rpcAddr.getHostName(), listenAddr.getPort());
        this.clientRpcServer.setThreadNamePrefix("RPC");
        nn.setRpcServerAddress(conf, this.clientRpcAddress);
        this.minimumDataNodeVersion = conf.get("dfs.namenode.min.supported.datanode.version", "2.1.0-beta");
        this.clientRpcServer.addTerseExceptions(new Class[]{SafeModeException.class, FileNotFoundException.class, HadoopIllegalArgumentException.class, FileAlreadyExistsException.class, InvalidPathException.class, ParentNotDirectoryException.class, UnresolvedLinkException.class, AlreadyBeingCreatedException.class, QuotaExceededException.class, RecoveryInProgressException.class, AccessControlException.class, SecretManager.InvalidToken.class, LeaseExpiredException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, AclException.class, FSLimitException.PathComponentTooLongException.class, FSLimitException.MaxDirectoryItemsExceededException.class});
    }

    @VisibleForTesting
    RPC.Server getClientRpcServer() {
        return this.clientRpcServer;
    }

    void start() {
        this.clientRpcServer.start();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.start();
        }
    }

    void join() throws InterruptedException {
        this.clientRpcServer.join();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.join();
        }
    }

    void stop() {
        if (this.clientRpcServer != null) {
            this.clientRpcServer.stop();
        }
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.stop();
        }
    }

    InetSocketAddress getServiceRpcAddress() {
        return this.serviceRPCAddress;
    }

    InetSocketAddress getRpcAddress() {
        return this.clientRpcAddress;
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        return NameNode.getRemoteUser();
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        if (size <= 0L) {
            throw new IllegalArgumentException("Unexpected not positive size: " + size);
        }
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getBlockManager().getBlocks(datanode, size);
    }

    @Override
    public ExportedBlockKeys getBlockKeys() throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getBlockManager().getBlockKeys();
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.namesystem.getDelegationToken(renewer);
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        return this.namesystem.renewDelegationToken(token);
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.namesystem.cancelDelegationToken(token);
    }

    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        this.metrics.incrGetBlockLocations();
        return this.namesystem.getBlockLocations(NameNodeRpcServer.getClientMachine(), src, offset, length);
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.namesystem.getServerDefaults();
    }

    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws IOException {
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.create: file " + src + " for " + clientName + " at " + clientMachine));
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("create: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        HdfsFileStatus stat = this.namesystem.startFile(src, new PermissionStatus(NameNodeRpcServer.getRemoteUser().getShortUserName(), null, masked), clientName, clientMachine, flag.get(), createParent, replication, blockSize);
        this.metrics.incrFilesCreated();
        this.metrics.incrCreateFileOps();
        return stat;
    }

    @Override
    public LocatedBlock append(String src, String clientName) throws IOException {
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.append: file " + src + " for " + clientName + " at " + clientMachine));
        }
        LocatedBlock info = this.namesystem.appendFile(src, clientName, clientMachine);
        this.metrics.incrFilesAppended();
        return info;
    }

    @Override
    public boolean recoverLease(String src, String clientName) throws IOException {
        String clientMachine = NameNodeRpcServer.getClientMachine();
        return this.namesystem.recoverLease(src, clientName, clientMachine);
    }

    @Override
    public boolean setReplication(String src, short replication) throws IOException {
        return this.namesystem.setReplication(src, replication);
    }

    @Override
    public void setStoragePolicy(String src, String policyName) throws IOException {
        this.namesystem.setStoragePolicy(src, policyName);
    }

    @Override
    public BlockStoragePolicy getStoragePolicy(byte storagePolicyID) throws IOException {
        return this.namesystem.getStoragePolicy(storagePolicyID);
    }

    @Override
    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        return this.namesystem.getStoragePolicies();
    }

    @Override
    public void setMetaEnabled(String src, boolean metaEnabled) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        this.namesystem.setMetaEnabled(src, metaEnabled);
    }

    @Override
    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.namesystem.setPermissionSTO(src, permissions);
    }

    @Override
    public void setOwner(String src, String username, String groupname) throws IOException {
        try {
            this.namesystem.setOwnerSTO(src, username, groupname);
        }
        catch (ForeignKeyConstraintViolationException ex) {
            LOG.debug((Object)("setOwner: cache is outdated, flush old values and restart the operation - " + (Object)((Object)ex)));
            Users.flushCache(username, groupname);
            this.namesystem.setOwnerSTO(src, username, groupname);
        }
    }

    @Override
    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludedNodes, long fileId, String[] favoredNodes) throws IOException {
        List<String> favoredNodesList;
        LocatedBlock locatedBlock;
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*BLOCK* NameNode.addBlock: file " + src + " fileId=" + fileId + " for " + clientName));
        }
        HashSet<Node> excludedNodesSet = null;
        if (excludedNodes != null) {
            excludedNodesSet = new HashSet<Node>(excludedNodes.length);
            for (DatanodeInfo node : excludedNodes) {
                excludedNodesSet.add(node);
            }
        }
        if ((locatedBlock = this.namesystem.getAdditionalBlock(src, fileId, clientName, previous, excludedNodesSet, favoredNodesList = favoredNodes == null ? null : Arrays.asList(favoredNodes))) != null) {
            this.metrics.incrAddBlockOps();
        }
        return locatedBlock;
    }

    @Override
    public LocatedBlock getAdditionalDatanode(String src, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getAdditionalDatanode: src=" + src + ", blk=" + blk + ", existings=" + Arrays.asList(existings) + ", excludes=" + Arrays.asList(excludes) + ", numAdditionalNodes=" + numAdditionalNodes + ", clientName=" + clientName));
        }
        this.metrics.incrGetAdditionalDatanodeOps();
        HashSet<Node> excludeSet = null;
        if (excludes != null) {
            excludeSet = new HashSet<Node>(excludes.length);
            for (DatanodeInfo node : excludes) {
                excludeSet.add(node);
            }
        }
        return this.namesystem.getAdditionalDatanode(src, blk, existings, existingStorageIDs, excludeSet, numAdditionalNodes, clientName);
    }

    @Override
    public void abandonBlock(ExtendedBlock b, String src, String holder) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*BLOCK* NameNode.abandonBlock: " + b + " of file " + src));
        }
        if (!this.namesystem.abandonBlock(b, src, holder)) {
            throw new IOException("Cannot abandon block during write to " + src);
        }
    }

    @Override
    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId, byte[] data) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.complete: " + src + " fileId=" + fileId + " for " + clientName));
        }
        return this.namesystem.completeFile(src, clientName, last, fileId, data);
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.namesystem.reportBadBlocks(blocks);
    }

    @Override
    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        return this.namesystem.updateBlockForPipeline(block, clientName);
    }

    @Override
    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs) throws IOException {
        this.namesystem.updatePipeline(clientName, oldBlock, newBlock, newNodes, newStorageIDs);
    }

    @Override
    public void commitBlockSynchronization(ExtendedBlock block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException {
        this.namesystem.commitBlockSynchronization(block, newgenerationstamp, newlength, closeFile, deleteblock, newtargets, newtargetstorages);
    }

    @Override
    public long getPreferredBlockSize(String filename) throws IOException {
        return this.namesystem.getPreferredBlockSize(filename);
    }

    @Override
    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.rename: " + src + " to " + dst));
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        boolean ret = this.namesystem.multiTransactionalRename(src, dst);
        if (ret) {
            this.metrics.incrFilesRenamed();
        }
        return ret;
    }

    @Override
    public void concat(String trg, String[] src) throws IOException {
        this.namesystem.concat(trg, src);
    }

    @Override
    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.rename: " + src + " to " + dst));
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        this.namesystem.multiTransactionalRename(src, dst, options);
        this.metrics.incrFilesRenamed();
    }

    @Override
    public boolean delete(String src, boolean recursive) throws IOException {
        boolean ret;
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* Namenode.delete: src=" + src + ", recursive=" + recursive));
        }
        if (ret = this.namesystem.multiTransactionalDelete(src, recursive)) {
            this.metrics.incrDeleteFileOps();
        }
        return ret;
    }

    private boolean checkPathLength(String src) {
        Path srcPath = new Path(src);
        return src.length() <= HdfsConstants.MAX_PATH_LENGTH && srcPath.depth() <= HdfsConstants.MAX_PATH_DEPTH;
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.mkdirs: " + src));
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("mkdirs: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        return this.namesystem.mkdirs(src, new PermissionStatus(NameNodeRpcServer.getRemoteUser().getShortUserName(), null, masked), createParent);
    }

    @Override
    public void renewLease(String clientName) throws IOException {
        this.namesystem.renewLease(clientName);
    }

    @Override
    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        DirectoryListing files = this.namesystem.getListing(src, startAfter, needLocation);
        if (files != null) {
            this.metrics.incrGetListingOps();
            this.metrics.incrFilesInGetListingOps(files.getPartialListing().length);
        }
        return files;
    }

    @Override
    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, true);
    }

    @Override
    public boolean isFileClosed(String src) throws IOException {
        return this.namesystem.isFileClosed(src);
    }

    @Override
    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, false);
    }

    @Override
    public long[] getStats() throws IOException {
        return this.namesystem.getStats();
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        DatanodeInfo[] results = this.namesystem.datanodeReport(type);
        if (results == null) {
            throw new IOException("Cannot find datanode report");
        }
        return results;
    }

    @Override
    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        DatanodeStorageReport[] reports = this.namesystem.getDatanodeStorageReport(type);
        if (reports == null) {
            throw new IOException("Failed to get datanode storage report for " + (Object)((Object)type) + " datanodes.");
        }
        return reports;
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        return this.namesystem.setSafeMode(action);
    }

    @Override
    public void refreshNodes() throws IOException {
        this.namesystem.refreshNodes();
    }

    @Override
    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        LOG.info((Object)("rollingUpgrade " + (Object)((Object)action)));
        switch (action) {
            case QUERY: {
                return this.namesystem.queryRollingUpgrade();
            }
            case PREPARE: {
                return this.namesystem.startRollingUpgrade();
            }
            case FINALIZE: {
                return this.namesystem.finalizeRollingUpgrade();
            }
        }
        throw new UnsupportedActionException((Object)((Object)action) + " is not yet supported.");
    }

    @Override
    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        String[] cookieTab = new String[]{cookie};
        Collection<FSNamesystem.CorruptFileBlockInfo> fbs = this.namesystem.listCorruptFileBlocks(path, cookieTab);
        String[] files = new String[fbs.size()];
        int i = 0;
        for (FSNamesystem.CorruptFileBlockInfo fb : fbs) {
            files[i++] = fb.path;
        }
        return new CorruptFileBlocks(files, cookieTab[0]);
    }

    @Override
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.namesystem.setBalancerBandwidth(bandwidth);
    }

    @Override
    public ContentSummary getContentSummary(String path) throws IOException {
        return this.namesystem.getContentSummary(path);
    }

    @Override
    public void setQuota(String path, long namespaceQuota, long diskspaceQuota) throws IOException {
        this.namesystem.multiTransactionalSetQuota(path, namespaceQuota, diskspaceQuota);
    }

    @Override
    public void fsync(String src, String clientName, long lastBlockLength) throws IOException {
        this.namesystem.fsync(src, clientName, lastBlockLength);
    }

    @Override
    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.namesystem.setTimes(src, mtime, atime);
    }

    @Override
    public void createSymlink(String target, String link, FsPermission dirPerms, boolean createParent) throws IOException {
        this.metrics.incrCreateSymlinkOps();
        if (!this.checkPathLength(link)) {
            throw new IOException("Symlink path exceeds " + HdfsConstants.MAX_PATH_LENGTH + " character limit");
        }
        if ("".equals(target)) {
            throw new IOException("Invalid symlink target");
        }
        UserGroupInformation ugi = NameNodeRpcServer.getRemoteUser();
        this.namesystem.createSymlink(target, link, new PermissionStatus(ugi.getShortUserName(), null, dirPerms), createParent);
    }

    @Override
    public String getLinkTarget(String path) throws IOException {
        this.metrics.incrGetLinkTargetOps();
        HdfsFileStatus stat = null;
        try {
            stat = this.namesystem.getFileInfo(path, false);
        }
        catch (UnresolvedPathException e) {
            return e.getResolvedPath().toString();
        }
        catch (UnresolvedLinkException e) {
            throw new AssertionError((Object)"UnresolvedLinkException thrown");
        }
        if (stat == null) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!stat.isSymlink()) {
            throw new IOException("Path " + path + " is not a symbolic link");
        }
        return stat.getSymlink().toString();
    }

    @Override
    public DatanodeRegistration registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.verifySoftwareVersion(nodeReg);
        this.namesystem.registerDatanode(nodeReg);
        return nodeReg;
    }

    @Override
    public HeartbeatResponse sendHeartbeat(DatanodeRegistration nodeReg, StorageReport[] reports, long dnCacheCapacity, long dnCacheUsed, int xmitsInProgress, int xceiverCount, int failedVolumes) throws IOException {
        this.verifyRequest(nodeReg);
        return this.namesystem.handleHeartbeat(nodeReg, reports, dnCacheCapacity, dnCacheUsed, xceiverCount, xmitsInProgress, failedVolumes);
    }

    @Override
    public DatanodeCommand blockReport(DatanodeRegistration nodeReg, String poolId, StorageBlockReport[] reports) throws IOException {
        this.verifyRequest(nodeReg);
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug((Object)("*BLOCK* NameNode.blockReport: from " + nodeReg + ", reports.length=" + reports.length));
        }
        BlockManager bm = this.namesystem.getBlockManager();
        boolean hasStaleStorages = true;
        for (StorageBlockReport r : reports) {
            BlockReport blocks = r.getReport();
            hasStaleStorages = bm.processReport(nodeReg, r.getStorage(), blocks);
            this.metrics.incrStorageBlockReportOps();
        }
        if (!hasStaleStorages) {
            return new FinalizeCommand(poolId);
        }
        return null;
    }

    @Override
    public DatanodeCommand cacheReport(DatanodeRegistration nodeReg, String poolId, List<Long> blockIds, long cacheCapacity, long cacheUsed) throws IOException {
        this.verifyRequest(nodeReg);
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug((Object)("*BLOCK* NameNode.cacheReport: from " + nodeReg + " " + blockIds.size() + " blocks"));
        }
        this.namesystem.getCacheManager().processCacheReport(nodeReg, blockIds, cacheCapacity, cacheUsed);
        return null;
    }

    @Override
    public void blockReceivedAndDeleted(DatanodeRegistration nodeReg, String poolId, StorageReceivedDeletedBlocks[] receivedAndDeletedBlocks) throws IOException {
        this.verifyRequest(nodeReg);
        this.metrics.incrBlockReceivedAndDeletedOps();
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug((Object)("*BLOCK* NameNode.blockReceivedAndDeleted: from " + nodeReg + " " + receivedAndDeletedBlocks.length + " blocks."));
        }
        for (StorageReceivedDeletedBlocks r : receivedAndDeletedBlocks) {
            this.namesystem.processIncrementalBlockReport(nodeReg, r);
        }
    }

    @Override
    public void errorReport(DatanodeRegistration nodeReg, int errorCode, String msg) throws IOException {
        String dnName;
        String string = dnName = nodeReg == null ? "Unknown DataNode" : nodeReg.toString();
        if (errorCode == 0) {
            LOG.info((Object)("Error report from " + dnName + ": " + msg));
            return;
        }
        this.verifyRequest(nodeReg);
        if (errorCode == 1) {
            LOG.warn((Object)("Disk error on " + dnName + ": " + msg));
        } else if (errorCode == 3) {
            LOG.warn((Object)("Fatal disk error on " + dnName + ": " + msg));
            this.namesystem.getBlockManager().getDatanodeManager().removeDatanode(nodeReg);
        } else {
            LOG.info((Object)("Error report from " + dnName + ": " + msg));
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getNamespaceInfo();
    }

    @Override
    public byte[] getSmallFileData(int id) throws IOException {
        return this.namesystem.getSmallFileData(id);
    }

    private void verifyRequest(NodeRegistration nodeReg) throws IOException {
        String id = nodeReg.getRegistrationID();
        String expectedID = this.namesystem.getRegistrationID();
        if (!expectedID.equals(id)) {
            LOG.warn((Object)("Registration IDs mismatched: the " + nodeReg.getClass().getSimpleName() + " ID is " + id + " but the expected ID is " + expectedID));
            throw new UnregisteredNodeException(nodeReg);
        }
    }

    public void refreshServiceAcl() throws IOException {
        if (!this.serviceAuthEnabled) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        this.clientRpcServer.refreshServiceAcl(new Configuration(), (PolicyProvider)new HDFSPolicyProvider());
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.refreshServiceAcl(new Configuration(), (PolicyProvider)new HDFSPolicyProvider());
        }
    }

    public void refreshUserToGroupsMappings() throws IOException {
        LOG.info((Object)("Refreshing all user-to-groups mappings. Requested by user: " + NameNodeRpcServer.getRemoteUser().getShortUserName()));
        Groups.getUserToGroupsMappingService().refresh();
    }

    public void refreshSuperUserGroupsConfiguration() {
        LOG.info((Object)"Refreshing SuperUser proxy group mapping list ");
        ProxyUsers.refreshSuperUserGroupsConfiguration();
    }

    public String[] getGroupsForUser(String user) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting groups for user " + user));
        }
        return UserGroupInformation.createRemoteUser((String)user).getGroupNames();
    }

    void verifyLayoutVersion(int version) throws IOException {
        if (version != HdfsConstants.NAMENODE_LAYOUT_VERSION) {
            throw new IncorrectVersionException(HdfsConstants.NAMENODE_LAYOUT_VERSION, version, "data node");
        }
    }

    private void verifySoftwareVersion(DatanodeRegistration dnReg) throws IncorrectVersionException, IOException {
        String dnVersion = dnReg.getSoftwareVersion();
        if (VersionUtil.compareVersions((String)dnVersion, (String)this.minimumDataNodeVersion) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(this.minimumDataNodeVersion, dnVersion, "DataNode", "NameNode");
            LOG.warn((Object)(ive.getMessage() + " DN: " + dnReg));
            throw ive;
        }
        String nnVersion = VersionInfo.getVersion();
        if (!dnVersion.equals(nnVersion)) {
            long dnCTime;
            String messagePrefix = "Reported DataNode version '" + dnVersion + "' of DN " + dnReg + " does not match NameNode version '" + nnVersion + "'";
            long nnCTime = StorageInfo.getStorageInfoFromDB().getCTime();
            if (nnCTime != (dnCTime = dnReg.getStorageInfo().getCTime())) {
                IncorrectVersionException ive = new IncorrectVersionException(messagePrefix + " and CTime of DN ('" + dnCTime + "') does not match CTime of NN ('" + nnCTime + "')");
                LOG.warn((Object)ive);
                throw ive;
            }
            LOG.info((Object)(messagePrefix + ". Note: This is normal during a rolling upgrade."));
        }
    }

    private static String getClientMachine() {
        String clientMachine = NamenodeWebHdfsMethods.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = Server.getRemoteAddress();
        }
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }

    @Override
    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        return this.namesystem.getBlockManager().generateDataEncryptionKey();
    }

    @Override
    public SortedActiveNodeList getActiveNamenodes() throws IOException {
        return this.nn.getActiveNameNodes();
    }

    @Override
    public ActiveNode getNextNamenodeToSendBlockReport(long noOfBlks, DatanodeRegistration nodeReg) throws IOException {
        this.verifyRequest(nodeReg);
        return this.nn.getNextNamenodeToSendBlockReport(noOfBlks, nodeReg);
    }

    @Override
    public ActiveNode getNextNamenodeToSendCacheReport(long noOfBlks, DatanodeRegistration nodeReg) throws IOException {
        this.verifyRequest(nodeReg);
        return this.nn.getNextNamenodeToSendCacheReport(noOfBlks, nodeReg);
    }

    @Override
    public void ping() throws IOException {
    }

    @Override
    public SortedActiveNodeList getActiveNamenodesForClient() throws IOException {
        return this.nn.getActiveNameNodes();
    }

    @Override
    public void changeConf(List<String> props, List<String> newVals) throws IOException {
        this.namesystem.changeConf(props, newVals);
    }

    @Override
    public void flushCache(String userName, String groupName) throws IOException {
        this.namesystem.flushCache(userName, groupName);
    }

    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, EncodingPolicy policy) throws IOException {
        HdfsFileStatus stat = this.create(src, masked, clientName, flag, createParent, replication, blockSize);
        if (policy != null) {
            if (!this.namesystem.isErasureCodingEnabled()) {
                throw new IOException("Requesting encoding although erasure coding was disabled");
            }
            LOG.info((Object)("Create file " + src + " with policy " + policy.toString()));
            this.namesystem.addEncodingStatus(src, policy, EncodingStatus.Status.ENCODING_REQUESTED, false);
        }
        return stat;
    }

    @Override
    public EncodingStatus getEncodingStatus(String filePath) throws IOException {
        EncodingStatus status = this.namesystem.getEncodingStatus(filePath);
        if (status.getStatus() == EncodingStatus.Status.DELETED) {
            throw new IOException("Trying to read encoding status of a deleted file");
        }
        return status;
    }

    @Override
    public void encodeFile(String filePath, EncodingPolicy policy) throws IOException {
        if (!this.namesystem.isErasureCodingEnabled()) {
            throw new IOException("Requesting encoding although erasure coding was disabled");
        }
        this.namesystem.addEncodingStatus(filePath, policy, EncodingStatus.Status.COPY_ENCODING_REQUESTED, true);
    }

    @Override
    public void revokeEncoding(String filePath, short replication) throws IOException {
        if (!this.namesystem.isErasureCodingEnabled()) {
            throw new IOException("Requesting revoke although erasure coding was disabled");
        }
        this.namesystem.revokeEncoding(filePath, replication);
    }

    @Override
    public LocatedBlocks getMissingBlockLocations(String filePath) throws IOException {
        return this.namesystem.getMissingBlockLocations(NameNodeRpcServer.getClientMachine(), filePath);
    }

    @Override
    public void addBlockChecksum(String src, int blockIndex, long checksum) throws IOException {
        this.namesystem.addBlockChecksum(src, blockIndex, checksum);
    }

    @Override
    public long getBlockChecksum(String src, int blockIndex) throws IOException {
        return this.namesystem.getBlockChecksum(src, blockIndex);
    }

    @Override
    public LocatedBlock getRepairedBlockLocations(String sourcePath, String parityPath, LocatedBlock block, boolean isParity) throws IOException {
        return this.namesystem.getRepairedBlockLocations(NameNodeRpcServer.getClientMachine(), sourcePath, parityPath, block, isParity);
    }

    @Override
    public void checkAccess(String path, FsAction mode) throws IOException {
        this.namesystem.checkAccess(path, mode);
    }

    @Override
    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.namesystem.modifyAclEntries(src, aclSpec);
    }

    @Override
    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.namesystem.removeAclEntries(src, aclSpec);
    }

    @Override
    public void removeDefaultAcl(String src) throws IOException {
        this.namesystem.removeDefaultAcl(src);
    }

    @Override
    public void removeAcl(String src) throws IOException {
        this.namesystem.removeAcl(src);
    }

    @Override
    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.namesystem.setAcl(src, aclSpec);
    }

    @Override
    public AclStatus getAclStatus(String src) throws IOException {
        return this.namesystem.getAclStatus(src);
    }

    @Override
    public LastUpdatedContentSummary getLastUpdatedContentSummary(String path) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.namesystem.getLastUpdatedContentSummary(path);
    }

    @Override
    public long addCacheDirective(CacheDirectiveInfo path, EnumSet<CacheFlag> flags) throws IOException {
        return this.namesystem.addCacheDirective(path, flags);
    }

    @Override
    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        this.namesystem.modifyCacheDirective(directive, flags);
    }

    @Override
    public void removeCacheDirective(long id) throws IOException {
        this.namesystem.removeCacheDirective(id);
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        if (filter == null) {
            filter = new CacheDirectiveInfo.Builder().build();
        }
        return this.namesystem.listCacheDirectives(prevId, filter);
    }

    @Override
    public void addCachePool(CachePoolInfo info) throws IOException {
        this.namesystem.addCachePool(info);
    }

    @Override
    public void modifyCachePool(CachePoolInfo info) throws IOException {
        this.namesystem.modifyCachePool(info);
    }

    @Override
    public void removeCachePool(String cachePoolName) throws IOException {
        this.namesystem.removeCachePool(cachePoolName);
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        return this.namesystem.listCachePools(prevKey != null ? prevKey : "");
    }
}

