/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Preconditions;
import io.hops.leader_election.node.ActiveNode;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.FailoverProxyHelper;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;

public class HopsRandomStickyFailoverProxyProvider<T>
implements FailoverProxyProvider<T> {
    public static final Log LOG = LogFactory.getLog(HopsRandomStickyFailoverProxyProvider.class);
    private final Configuration conf;
    private final List<FailoverProxyHelper.AddressRpcProxyPair<T>> proxies = new ArrayList<FailoverProxyHelper.AddressRpcProxyPair<T>>();
    private final UserGroupInformation ugi;
    private final Class<T> xface;
    private final Random rand = new Random(System.currentTimeMillis());
    private final URI uri;
    protected String name = this.getClass().getSimpleName() + " (" + this.hashCode() + ") ";
    protected int currentProxyIndex = -1;

    public HopsRandomStickyFailoverProxyProvider(Configuration conf, URI uri, Class<T> xface) {
        Preconditions.checkArgument((boolean)xface.isAssignableFrom(NamenodeProtocols.class), (Object)"Interface class %s is not a valid NameNode protocol!");
        this.xface = xface;
        this.conf = new Configuration(conf);
        int maxRetries = this.conf.getInt("dfs.client.failover.connection.retries", 0);
        this.conf.setInt("ipc.client.connect.max.retries", maxRetries);
        int maxRetriesOnSocketTimeouts = this.conf.getInt("dfs.client.failover.connection.retries.on.timeouts", 0);
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", maxRetriesOnSocketTimeouts);
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
            this.uri = uri;
            List<ActiveNode> anl = FailoverProxyHelper.getActiveNamenodes(conf, xface, this.ugi, uri);
            this.updateProxies(anl);
            this.setRandProxyIndex();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<T> getInterface() {
        return this.xface;
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        try {
            if (this.currentProxyIndex == -1) {
                LOG.debug((Object)(this.name + " returning default proxy"));
                return new FailoverProxyProvider.ProxyInfo(NameNodeProxies.createNonHAProxy(this.conf, NameNode.getAddress(this.uri), this.xface, this.ugi, false).getProxy(), null);
            }
            FailoverProxyHelper.AddressRpcProxyPair<T> current = this.proxies.get(this.currentProxyIndex);
            if (current.namenode == null) {
                current.namenode = NameNodeProxies.createNonHAProxy(this.conf, current.address, this.xface, this.ugi, false).getProxy();
            }
            LOG.debug((Object)(this.name + " returning proxy for index: " + this.currentProxyIndex + " address: " + current.address + " Total proxies are: " + this.proxies.size()));
            return new FailoverProxyProvider.ProxyInfo(current.namenode, null);
        }
        catch (IOException e) {
            LOG.error((Object)(this.name + " failed to create RPC proxy to NameNode"), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public synchronized void performFailover(T currentProxy) {
        try {
            LOG.debug((Object)(this.name + " failover happened"));
            List<ActiveNode> anl = FailoverProxyHelper.getActiveNamenodes(this.conf, this.xface, this.ugi, this.uri);
            LOG.debug((Object)(this.name + " failover happened 2"));
            this.updateProxies(anl);
            this.setRandProxyIndex();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void close() throws IOException {
        for (FailoverProxyHelper.AddressRpcProxyPair<T> proxy : this.proxies) {
            if (proxy.namenode == null) continue;
            if (proxy.namenode instanceof Closeable) {
                ((Closeable)proxy.namenode).close();
            } else {
                RPC.stopProxy(proxy.namenode);
            }
            proxy.namenode = null;
        }
        this.proxies.clear();
    }

    private void setRandProxyIndex() {
        if (this.proxies.size() > 0) {
            this.currentProxyIndex = this.rand.nextInt(this.proxies.size());
            LOG.debug((Object)(this.name + " random proxy index is set to: " + this.currentProxyIndex + " NN address: " + this.proxies.get((int)this.currentProxyIndex).address));
        }
    }

    void updateProxies(List<ActiveNode> anl) throws IOException {
        if (anl != null) {
            this.close();
            for (ActiveNode node : anl) {
                FailoverProxyHelper.AddressRpcProxyPair pair = new FailoverProxyHelper.AddressRpcProxyPair(node.getRpcServerAddressForClients());
                this.proxies.add(pair);
            }
            LOG.debug((Object)(this.name + " new set of proxies are: " + Arrays.toString(anl.toArray())));
        } else {
            LOG.warn((Object)(this.name + " no new namenodes were found"));
        }
    }
}

