/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Test;

public class TestInodeLock {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInodeLockWithWrongPath() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            final MiniDFSCluster clusterFinal = cluster;
            DistributedFileSystem hdfs = cluster.getFileSystem();
            hdfs.mkdirs(new Path("/tmp"));
            DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp/f1"), 0L, (short)1, 0L);
            new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, new String[]{"/tmp/f1", "/tmp/f2"}).setNameNodeID(clusterFinal.getNameNode().getId()).setActiveNameNodes((Collection)clusterFinal.getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                    locks.add((Lock)il);
                }

                public Object performTask() throws IOException {
                    return null;
                }
            }.handle();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

