/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;

public class AppendTestUtil {
    static final Long RANDOM_NUMBER_GENERATOR_SEED = null;
    public static final Log LOG = LogFactory.getLog(AppendTestUtil.class);
    private static final Random SEED = new Random();
    private static final ThreadLocal<Random> RANDOM;
    static final int BLOCK_SIZE = 1024;
    static final int NUM_BLOCKS = 10;
    static final int FILE_SIZE = 10241;
    static long seed;

    static int nextInt() {
        return RANDOM.get().nextInt();
    }

    public static int nextInt(int n) {
        return RANDOM.get().nextInt(n);
    }

    static int nextLong() {
        return RANDOM.get().nextInt();
    }

    public static byte[] randomBytes(long seed, int size) {
        LOG.info((Object)("seed=" + seed + ", size=" + size));
        byte[] b = new byte[size];
        Random rand = new Random(seed);
        rand.nextBytes(b);
        return b;
    }

    static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            LOG.info((Object)("ms=" + ms), (Throwable)e);
        }
    }

    public static FileSystem createHdfsWithDifferentUsername(Configuration conf) throws IOException, InterruptedException {
        String username = UserGroupInformation.getCurrentUser().getShortUserName() + "_XXX";
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)username, (String[])new String[]{"supergroup"});
        return DFSTestUtil.getFileSystemAs(ugi, conf);
    }

    public static void write(OutputStream out, int offset, int length) throws IOException {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(offset + i);
        }
        out.write(bytes);
    }

    public static void check(FileSystem fs, Path p, long length) throws IOException {
        int i = -1;
        try {
            FileStatus status = fs.getFileStatus(p);
            FSDataInputStream in = fs.open(p);
            if (in.getWrappedStream() instanceof DFSInputStream) {
                long len = ((DFSInputStream)in.getWrappedStream()).getFileLength();
                Assert.assertEquals((long)length, (long)len);
            } else {
                Assert.assertEquals((long)length, (long)status.getLen());
            }
            ++i;
            while ((long)i < length) {
                Assert.assertEquals((long)((byte)i), (long)((byte)in.read()));
                ++i;
            }
            i = -((int)length);
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
        catch (IOException ioe) {
            throw new IOException("p=" + p + ", length=" + length + ", i=" + i, ioe);
        }
    }

    public static byte[] initBuffer(int size) {
        if (seed == -1L) {
            seed = AppendTestUtil.nextLong();
        }
        return AppendTestUtil.randomBytes(seed, size);
    }

    public static FSDataOutputStream createFile(FileSystem fileSys, Path name, int repl) throws IOException {
        return fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 1024L);
    }

    public static void checkFullFile(FileSystem fs, Path name, int len, byte[] compareContent, String message) throws IOException {
        FSDataInputStream stm = fs.open(name);
        byte[] actual = new byte[len];
        stm.readFully(0L, actual);
        AppendTestUtil.checkData(actual, 0, compareContent, message);
        stm.close();
    }

    private static void checkData(byte[] actual, int from, byte[] expected, String message) {
        for (int idx = 0; idx < actual.length; ++idx) {
            Assert.assertEquals((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]), (long)expected[from + idx], (long)actual[idx]);
            actual[idx] = 0;
        }
    }

    public static void testAppend(FileSystem fs, Path p) throws IOException {
        byte[] bytes = new byte[1000];
        FSDataOutputStream out = fs.create(p, (short)1);
        out.write(bytes);
        out.close();
        Assert.assertEquals((long)bytes.length, (long)fs.getFileStatus(p).getLen());
        for (int i = 2; i < 500; ++i) {
            FSDataOutputStream out2 = fs.append(p);
            out2.write(bytes);
            out2.close();
            Assert.assertEquals((long)(i * bytes.length), (long)fs.getFileStatus(p).getLen());
        }
    }

    static {
        long seed = RANDOM_NUMBER_GENERATOR_SEED == null ? SEED.nextLong() : RANDOM_NUMBER_GENERATOR_SEED.longValue();
        LOG.info((Object)("seed=" + seed));
        SEED.setSeed(seed);
        RANDOM = new ThreadLocal<Random>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Random initialValue() {
                Random r = new Random();
                Random random = SEED;
                synchronized (random) {
                    long seed = SEED.nextLong();
                    r.setSeed(seed);
                    LOG.info((Object)(Thread.currentThread().getName() + ": seed=" + seed));
                }
                return r;
            }
        };
        AppendTestUtil.seed = -1L;
    }
}

